/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.NotifyRemote;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import java.rmi.RemoteException;
import psdi.app.system.CrontaskParamInfo;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.server.MXServer;
import psdi.server.SimpleCronTask;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

public class NotificationReloadCrontask
extends SimpleCronTask {
    private static CrontaskParamInfo[] params = new CrontaskParamInfo[1];
    public static final String NOTIFICATION_NAMES = "NotificationNames";
    private boolean initialized = false;
    private String[] notificationNames = null;

    public void init() throws MXException {
        MXLogger logger2 = this.getCronTaskLogger();
        logger2.info((Object)"Initializing the Informer notification reload cron task");
        try {
            super.init();
            String tmp = this.getParamAsString(NOTIFICATION_NAMES);
            if (tmp == null || tmp.trim().length() <= 0) {
                logger2.warn((Object)"No notifications have been configured for refresh, no refresh will occur.");
            } else {
                this.notificationNames = tmp.split(",");
            }
        }
        catch (RemoteException e) {
            logger2.error((Object)("An error occurred while reading the notification names; " + e.getMessage() + ", the CronTask will not run."));
            this.initialized = false;
            return;
        }
        this.initialized = true;
        logger2.info((Object)"Initialized the Informer Notification reload cron task");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void cronAction() {
        MXLogger logger2 = this.getCronTaskLogger();
        try {
            String tmp = this.getParamAsString(NOTIFICATION_NAMES);
            if (tmp == null || tmp.trim().length() <= 0) {
                logger2.warn((Object)"No notifications have been configured for refresh, no refresh will occur.");
            } else {
                this.notificationNames = tmp.split(",");
            }
        }
        catch (Exception e) {
            logger2.error((Object)"Error reading notification reload cron task parameters", (Throwable)e);
        }
        if (this.initialized && this.notificationNames != null) {
            logger2.info((Object)"Refreshing user notifications");
            SqlFormat sqlf = new SqlFormat("notifynum = :1");
            MboSetRemote notifySet = null;
            try {
                notifySet = MXServer.getMXServer().getMboSet("ISNOTIFY", super.getRunasUserInfo());
                for (String name : this.notificationNames) {
                    sqlf.setObject(1, "ISNOTIFY", "NOTIFYNUM", name);
                    notifySet.setWhere(sqlf.format());
                    notifySet.reset();
                    if (notifySet.isEmpty()) continue;
                    ((NotifyRemote)notifySet.getMbo(0)).refreshNotifications();
                    notifySet.save();
                }
            }
            catch (MXException e) {
                logger2.error((Object)("An error occurred while purging catalog transactions;" + e.getMessage()));
                NotifyUtil.closeAndCleanup(notifySet);
            }
            catch (RemoteException e2) {
                logger2.error((Object)("An error occurred while purging catalog transactions;" + e2.getMessage()));
                {
                    catch (Throwable throwable) {
                        NotifyUtil.closeAndCleanup(notifySet);
                        throw throwable;
                    }
                }
                NotifyUtil.closeAndCleanup(notifySet);
            }
            NotifyUtil.closeAndCleanup(notifySet);
        }
    }

    public CrontaskParamInfo[] getParameters() throws RemoteException, MXException {
        return params;
    }

    static {
        CrontaskParamInfo retentionPeriod = new CrontaskParamInfo();
        retentionPeriod.setName(NOTIFICATION_NAMES);
        retentionPeriod.setDescription("informer", "notificationNames");
        retentionPeriod.setDefault("");
        NotificationReloadCrontask.params[0] = retentionPeriod;
    }
}

