/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.CatalogEventListener;
import com.interlocsolutions.maximo.notify.CatalogEventRegistration;
import com.interlocsolutions.maximo.notify.CatalogRemote;
import com.interlocsolutions.maximo.notify.NotificationEventRegistration;
import com.interlocsolutions.maximo.notify.NotifyEventListener;
import com.interlocsolutions.maximo.notify.NotifyRemote;
import com.interlocsolutions.maximo.notify.err.InformerException;
import com.interlocsolutions.maximo.notify.err.NoSuchCatalogException;
import com.interlocsolutions.maximo.notify.util.CachedCatalog;
import com.interlocsolutions.maximo.notify.util.CachedNotifyAttribute;
import com.interlocsolutions.maximo.notify.util.CachedNotifyObject;
import com.interlocsolutions.maximo.notify.util.CachedNotifyProfile;
import com.interlocsolutions.maximo.notify.util.InformerThreadIndefinite;
import com.interlocsolutions.maximo.notify.util.ListenerRegistrations;
import com.interlocsolutions.maximo.notify.util.MboUtil;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.util.PropUtil;
import com.interlocsolutions.maximo.notify.util.PropUtils;
import com.interlocsolutions.maximo.util.MXServerFactory;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.mbo.MaximoCache;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetInfo;
import psdi.mbo.MboSetRemote;
import psdi.mbo.RelationInfo;
import psdi.mbo.SqlFormat;
import psdi.server.MXServer;
import psdi.server.event.EventListener;
import psdi.server.event.EventMessage;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

public class NotificationEventListenerManager
extends InformerThreadIndefinite {
    public static final String PROFILE_CACHE_NAME = "ISPROFILEMANAGER";
    public static final Pattern RELOAD_KEY_PATTERN_CATALOG = Pattern.compile("c(\\d*)");
    private static final String CACHE_KEY_ALL_CATALOGS = "c";
    private static final Object syncLock = new Object();
    private static MXLogger LOGGER = NotifyConstants.INFORMER_LOGGER;
    private static HashMap<Long, CachedNotifyProfile> cachedNotifyProfiles = new HashMap();
    private static HashMap<Long, String> cachedNotifyClauses = new HashMap();
    private HashMap<Long, NotificationEventRegistration> activeNotifications = new HashMap();
    private Boolean listenerMonitorTableEnabled;
    private ExecutorService executorService;
    private Deque<Future<?>> jobs = new ArrayDeque();
    private CountDownLatch initDone = new CountDownLatch(1);

    public NotificationEventListenerManager(String name) {
        super(name, TimeUnit.MINUTES.toMillis(30L), false, true, NotifyConstants.INFORMER_LOGGER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getClause(long notifyid) {
        Object object = syncLock;
        synchronized (object) {
            return cachedNotifyClauses.get(notifyid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static CachedNotifyObject getCachedNotificationObject(long notifyid) {
        MboSetRemote notifySet;
        block15: {
            CachedNotifyObject cachedNotifyObject;
            Object object = syncLock;
            // MONITORENTER : object
            CachedNotifyProfile profile = cachedNotifyProfiles.get(notifyid);
            if (profile != null) {
                CachedNotifyObject object2 = profile.getMainObject();
                if (object2 == null) return null;
                // MONITOREXIT : object
                return object2.clone();
            }
            notifySet = null;
            try {
                CachedNotifyObject cachedNotifyObject2;
                notifySet = MXServer.getMXServer().getMboSet("ISNOTIFY", MXServer.getMXServer().getSystemUserInfo());
                NotifyRemote notify = (NotifyRemote)notifySet.getMboForUniqueId(notifyid);
                if (notify == null || (cachedNotifyObject2 = NotificationEventListenerManager.getNotifyObject(notify)) == null) break block15;
                Object object3 = syncLock;
                // MONITORENTER : object3
                if (cachedNotifyProfiles.containsKey(notifyid)) {
                    cachedNotifyProfiles.remove(notifyid);
                }
                CachedNotifyProfile cProfile = new CachedNotifyProfile(notify.getLong("NOTIFYID"), notify.getString("NOTIFYNUM"), notify.getString("CLAUSENAME"), cachedNotifyObject2);
                cachedNotifyProfiles.put(notifyid, cProfile);
                CachedNotifyObject object4 = cProfile.getMainObject();
                if (object4 == null) break block15;
                cachedNotifyObject = object4.clone();
                // MONITOREXIT : object3
            }
            catch (RemoteException e) {
                NotifyConstants.INFORMER_LOGGER.error((Object)e);
                {
                    catch (Throwable throwable) {
                        NotifyUtil.closeAndCleanup(notifySet);
                        throw throwable;
                    }
                }
                NotifyUtil.closeAndCleanup(notifySet);
                return null;
                catch (MXException e2) {
                    NotifyConstants.INFORMER_LOGGER.error((Object)e2);
                    NotifyUtil.closeAndCleanup(notifySet);
                    return null;
                }
            }
            NotifyUtil.closeAndCleanup(notifySet);
            // MONITOREXIT : object
            return cachedNotifyObject;
        }
        NotifyUtil.closeAndCleanup(notifySet);
        return null;
    }

    private static CachedNotifyObject getNotifyObject(NotifyRemote notify) throws RemoteException, MXException {
        MboSetRemote objects = notify.getMboSet("NOTIFYOBJECT");
        objects.setWhere("ISMAIN = :yes");
        objects.reset();
        if (!objects.isEmpty()) {
            MboRemote objConfig = objects.getMbo(0);
            return NotificationEventListenerManager.getNotifyObject(objConfig);
        }
        return null;
    }

    private static CachedNotifyObject getNotifyObject(MboRemote objConfig) throws MXException, RemoteException {
        if (objConfig == null) {
            return null;
        }
        CachedNotifyObject object = new CachedNotifyObject(objConfig.getString("OBJECTNAME"));
        if (!objConfig.isNull("PARENT")) {
            object.setParent(objConfig.getString("PARENT"));
            if (!objConfig.isNull("RELATIONSHIP")) {
                object.setRelationship(objConfig.getString("RELATIONSHIP"));
            }
        }
        MboSetRemote attributes = objConfig.getMboSet("NOTIFYATTRIBUTE");
        attributes.reset();
        MboRemote attribute = null;
        while ((attribute = attributes.getMbo(0)) != null) {
            object.addAttribute(new CachedNotifyAttribute(attribute.getString("ATTRIBUTENAME"), attribute.getBoolean("CANEDIT")));
            attributes.remove(0);
        }
        MboSetRemote childSet = objConfig.getMboSet("CHILDREN");
        SqlFormat sqlf = new SqlFormat("notifyobjectid!=:1 and objorder > :2");
        sqlf.setLong(1, objConfig.getUniqueIDValue());
        sqlf.setLong(2, (long)objConfig.getInt("OBJORDER"));
        childSet.setWhere(sqlf.format());
        childSet.setOrderBy("OBJORDER");
        childSet.reset();
        MboRemote child = null;
        while ((child = childSet.getMbo(0)) != null) {
            object.addChild(NotificationEventListenerManager.getNotifyObject(child));
            childSet.remove(0);
        }
        return object;
    }

    @Override
    protected void initTask() throws RemoteException, MXException, InformerThreadIndefinite.InformerTaskException {
        try {
            if (!PropUtil.INSTANCE.getProp("informer.startup.wait").asBoolean(true)) {
                NotifyConstants.INFORMER_LOGGER.warn((Object)"Informer is not waiting for listener registration to complete.  Some data changes might be missed.");
                this.initDone.countDown();
            }
            this.ensureRevisionsSet();
            this.cleanListenerRecords();
            ProfMaxCache profMaxCache = new ProfMaxCache();
            MXServer.getMXServer().addToMaximoCache(PROFILE_CACHE_NAME, (MaximoCache)profMaxCache);
            profMaxCache.init();
            this.registerCacheRefreshListeners();
            this.executorService = Executors.newSingleThreadExecutor();
        }
        finally {
            this.initDone.countDown();
        }
    }

    @Override
    protected void cleanUpTask() {
        this.executorService.shutdown();
    }

    @Override
    protected void runRecurringInformerTask() throws RemoteException, MXException, InformerThreadIndefinite.InformerTaskException {
        this.reloadProfileCacheSync();
    }

    private ListenerRegistrations registerCacheRefreshListeners() throws MXException {
        EventListener profileChangeListener = new EventListener(){

            public boolean eventValidate(EventMessage eventMessage) throws MXException {
                return true;
            }

            public void preSaveEventAction(EventMessage eventMessage) throws MXException {
            }

            public void eventAction(EventMessage eventMessage) throws MXException {
            }

            public void postCommitEventAction(EventMessage eventMessage) throws MXException {
                NotificationEventListenerManager.this.reloadProfileCacheAsync();
            }
        };
        return new ListenerRegistrations().add(profileChangeListener, "maximo.isnotify.add").add(profileChangeListener, "maximo.isnotify.update").add(profileChangeListener, "maximo.isnotify.delete").add(profileChangeListener, "maximo.isnotifyobject.add").add(profileChangeListener, "maximo.isnotifyobject.update").add(profileChangeListener, "maximo.isnotifyobject.delete").add(profileChangeListener, "maximo.isnotifyattribute.add").add(profileChangeListener, "maximo.isnotifyattribute.update").add(profileChangeListener, "maximo.isnotifyattribute.delete").add(profileChangeListener, "maximo.query.update").add(profileChangeListener, "maximo.iscatalog.add").add(profileChangeListener, "maximo.iscatalog.update").add(profileChangeListener, "maximo.iscatalog.delete").add(profileChangeListener, "maximo.iscatalogattribute.add").add(profileChangeListener, "maximo.iscatalogattribute.update").add(profileChangeListener, "maximo.iscatalogattribute.delete").add(profileChangeListener, "maximo.iscataloglistener.add").add(profileChangeListener, "maximo.iscataloglistener.update").add(profileChangeListener, "maximo.iscataloglistener.delete").registerAll();
    }

    private synchronized Future<?> reloadProfileCacheAsync() {
        Future<?> latestJob;
        Future<?> job = this.jobs.peekFirst();
        while (job != null && (job.isDone() || job.isCancelled())) {
            this.jobs.removeFirst();
            job = this.jobs.peekFirst();
        }
        if (this.jobs.size() >= 2) {
            latestJob = this.jobs.peekLast();
        } else {
            latestJob = this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        MXServer.getMXServer().reloadMaximoCache(NotificationEventListenerManager.PROFILE_CACHE_NAME, true);
                    }
                    catch (Exception e) {
                        NotifyConstants.INFORMER_LOGGER.error((Object)"Reload Maximo cache was failed.", (Throwable)e);
                    }
                }
            });
            this.jobs.push(latestJob);
        }
        return latestJob;
    }

    private void reloadProfileCacheSync() throws MXException {
        try {
            this.reloadProfileCacheAsync().get();
        }
        catch (InterruptedException e) {
            throw new InformerException("evalError", new Object[]{"Informer Profile Cache initialization", e.getMessage()}, e);
        }
        catch (ExecutionException e) {
            throw new InformerException("evalError", new Object[]{"Informer Profile Cache initialization", e.getMessage()}, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void reevaluate() {
        this.listenerMonitorTableEnabled = !PropUtils.getBooleanMaxProp("informer.monitor.listeners.disable", false);
        SqlFormat sqlf = new SqlFormat("active = :1 and revision is not null");
        sqlf.setBoolean(1, true);
        String activeWhere = sqlf.format();
        sqlf.setBoolean(1, false);
        String inactiveWhere = sqlf.format();
        if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
            NotifyConstants.INFORMER_LOGGER.debug((Object)"Evaluating Interloc Mobile Informer notification and catalog event listeners.");
            Set<Long> keys = this.activeNotifications.keySet();
            NotifyConstants.INFORMER_LOGGER.debug((Object)("There are currently " + keys.size() + " active notification registrations."));
            for (long key : keys) {
                List<CatalogEventRegistration> catalogs;
                NotificationEventRegistration ner = this.activeNotifications.get(key);
                HashMap<String, Integer> registrations = ner.getRegistrations();
                if (registrations != null) {
                    NotifyConstants.INFORMER_LOGGER.debug((Object)("Notification ID: " + ner.getNotifyId() + " is for revision " + ner.getRevision() + " with " + registrations.size() + " notification event listeners"));
                }
                if ((catalogs = ner.getCatalogs()) == null) continue;
                NotifyConstants.INFORMER_LOGGER.debug((Object)("Notification ID:" + ner.getNotifyId() + " has " + catalogs.size() + " catalog event listeners"));
            }
        }
        try {
            MboSetRemote set = MXServer.getMXServer().getMboSet("ISNOTIFY", MXServer.getMXServer().getSystemUserInfo());
            try {
                set.setWhere(activeWhere);
                set.reset();
                if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                    int count = set.count();
                    NotifyConstants.INFORMER_LOGGER.debug((Object)("Found " + count + " active Interloc Mobile Informer profile" + (count != 0 ? "s" : "")));
                }
                ArrayList<NotificationEventRegistration> invalidNotifications = new ArrayList<NotificationEventRegistration>();
                MboRemote notify = set.moveFirst();
                while (notify != null) {
                    NotificationEventRegistration ner;
                    if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                        NotifyConstants.INFORMER_LOGGER.debug((Object)("Evaluating active Interloc Mobile Informer profile " + notify.getString("NOTIFYNUM")));
                    }
                    if ((ner = this.activeNotifications.get(notify.getUniqueIDValue())) != null && ner.getRevision() < notify.getLong("REVISION")) {
                        if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                            NotifyConstants.INFORMER_LOGGER.debug((Object)("The current profile revision number " + notify.getLong("REVISION") + " is greater than the current registered listener revision of " + ner.getRevision()));
                        }
                        long notifyid = notify.getUniqueIDValue();
                        NotificationEventRegistration newRegistration = this.registerNotificationListener((NotifyRemote)notify);
                        this.activeNotifications.put(notifyid, newRegistration);
                        invalidNotifications.add(ner);
                        Object object = syncLock;
                        synchronized (object) {
                            MboSetRemote querySet = notify.getMboSet("QUERY");
                            querySet.reset();
                            String clause = "1!=1";
                            if (!querySet.isEmpty()) {
                                clause = querySet.getMbo(0).getString("CLAUSE");
                            }
                            cachedNotifyProfiles.remove(notifyid);
                            cachedNotifyClauses.put(notifyid, clause);
                        }
                    }
                    if (ner == null) {
                        if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                            NotifyConstants.INFORMER_LOGGER.debug((Object)"An existing listener registration was not found, creating new listener registration");
                        }
                        this.activeNotifications.put(notify.getUniqueIDValue(), this.registerNotificationListener((NotifyRemote)notify));
                        Object notifyid = syncLock;
                        synchronized (notifyid) {
                            MboSetRemote querySet = notify.getMboSet("QUERY");
                            querySet.reset();
                            String clause = "1!=1";
                            if (!querySet.isEmpty()) {
                                clause = querySet.getMbo(0).getString("CLAUSE");
                            }
                            cachedNotifyClauses.put(notify.getUniqueIDValue(), clause);
                        }
                    }
                    notify = set.moveNext();
                }
                set.resetQbe();
                set.setWhere(inactiveWhere);
                set.reset();
                if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                    int count = set.count();
                    NotifyConstants.INFORMER_LOGGER.debug((Object)("Found " + count + " inactive Interloc Mobile Informer profile" + (count != 0 ? "s" : "")));
                }
                Object notify2 = set.moveFirst();
                while (notify2 != null) {
                    long notifyid = notify2.getUniqueIDValue();
                    NotificationEventRegistration ner = this.activeNotifications.get(notifyid);
                    if (ner != null) {
                        if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                            NotifyConstants.INFORMER_LOGGER.debug((Object)("Found existing listener registration for inactive Interloc Mobile Informer profile ID " + notifyid));
                        }
                        this.unregisterNotificationListener(this.activeNotifications.remove(ner.getNotifyId()));
                        Object object = syncLock;
                        synchronized (object) {
                            cachedNotifyProfiles.remove(notifyid);
                            cachedNotifyClauses.remove(notifyid);
                        }
                    }
                    notify2 = set.moveNext();
                }
                if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                    NotifyConstants.INFORMER_LOGGER.debug((Object)("There are " + invalidNotifications.size() + " invalid notification listeners"));
                }
                for (NotificationEventRegistration ner : invalidNotifications) {
                    this.unregisterNotificationListener(ner);
                }
                set.setWhere("");
                set.resetQbe();
                set.reset();
                HashSet<Long> keys = new HashSet<Long>(this.activeNotifications.keySet());
                for (long key : keys) {
                    if (set.getMboForUniqueId(key) != null) continue;
                    if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                        NotifyConstants.INFORMER_LOGGER.debug((Object)("Found existing listener registration for deleted Interloc Mobile Informer profile ID " + key));
                    }
                    this.unregisterNotificationListener(this.activeNotifications.remove(key));
                }
            }
            finally {
                NotifyUtil.closeAndCleanup(set);
            }
        }
        catch (RemoteException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
        }
        catch (MXException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
        }
    }

    private void unregisterNotificationListener(NotificationEventRegistration ner) {
        List<CatalogEventRegistration> catalogs;
        HashMap<String, Integer> registrations;
        if (ner == null) {
            if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                NotifyConstants.INFORMER_LOGGER.debug((Object)"Cannot unregister null registration.");
            }
            return;
        }
        if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
            NotifyConstants.INFORMER_LOGGER.debug((Object)("Unregistering notification listener for Interloc Mobile Informer profile ID " + ner.getNotifyId()));
        }
        if ((registrations = ner.getRegistrations()) != null) {
            if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                NotifyConstants.INFORMER_LOGGER.debug((Object)("There are " + registrations.size() + " notification registrations to unregister."));
            }
            Set<String> subjects = registrations.keySet();
            for (String subject : subjects) {
                try {
                    if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                        NotifyConstants.INFORMER_LOGGER.debug((Object)("Unregistering notification subject " + subject + " with event registration ID " + registrations.get(subject)));
                    }
                    MXServer.getEventTopicTree().unregister(subject, registrations.get(subject).intValue());
                    this.removeListenerRecord(registrations.get(subject), subject);
                }
                catch (MXException e) {
                    NotifyConstants.INFORMER_LOGGER.warn((Object)"An error occurred while unregistering notification listener.", (Throwable)e);
                }
            }
        }
        if ((catalogs = ner.getCatalogs()) != null) {
            if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                NotifyConstants.INFORMER_LOGGER.debug((Object)("There are " + catalogs.size() + " catalog registrations to unregister."));
            }
            for (CatalogEventRegistration cer : catalogs) {
                this.unregisterCatalogListener(cer);
            }
        }
    }

    private void unregisterCatalogListener(CatalogEventRegistration cer) {
        if (cer == null) {
            return;
        }
        try {
            if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                NotifyConstants.INFORMER_LOGGER.debug((Object)("Unregistering catalog subject " + cer.getSubject() + " with event registration ID " + cer.getRegId()));
            }
            MXServer.getEventTopicTree().unregister(cer.getSubject(), cer.getRegId());
            this.removeListenerRecord(cer.getRegId(), cer.getSubject());
        }
        catch (MXException e) {
            NotifyConstants.INFORMER_LOGGER.warn((Object)"An error occurred while unregistering notification listener.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NotificationEventRegistration registerNotificationListener(NotifyRemote notify) throws RemoteException, MXException {
        if (notify != null) {
            CachedNotifyObject cachedNotifyObject = NotificationEventListenerManager.getNotifyObject(notify);
            if (cachedNotifyObject != null) {
                Object object = syncLock;
                synchronized (object) {
                    long notifyid = notify.getUniqueIDValue();
                    if (cachedNotifyProfiles.containsKey(notifyid)) {
                        cachedNotifyProfiles.remove(notifyid);
                    }
                    String[] profile = new CachedNotifyProfile(notify.getLong("NOTIFYID"), notify.getString("NOTIFYNUM"), notify.getString("CLAUSENAME"), cachedNotifyObject);
                    cachedNotifyProfiles.put(notifyid, (CachedNotifyProfile)profile);
                }
            }
            LinkedList<String> triggerRoots = new LinkedList<String>();
            if (!notify.isNull("PROCESSNAME")) {
                triggerRoots.add("WFASSIGNMENT");
            }
            if (!notify.isNull("ALTTRIGROOT")) {
                String delimiter = ";";
                if (notify.getString("ALTTRIGROOT").contains(",")) {
                    delimiter = ",";
                }
                if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                    NotifyConstants.INFORMER_LOGGER.debug((Object)("Parsing alternative trigger roots " + notify.getString("ALTTRIGROOT") + " for Interloc Mobile Informer profile " + notify.getString("NOTIFYNUM") + " with " + delimiter + " delimter."));
                }
                String[] triggers = notify.getString("ALTTRIGROOT").toLowerCase().split(delimiter);
                if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                    NotifyConstants.INFORMER_LOGGER.debug((Object)("Found " + triggers.length + " alternative triggers."));
                }
                for (String trigger : triggers) {
                    if (triggerRoots.contains(trigger)) continue;
                    if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                        NotifyConstants.INFORMER_LOGGER.debug((Object)("Adding alternative trigger " + trigger));
                    }
                    triggerRoots.add(trigger);
                }
            }
            MboSetRemote objectSet = notify.getMboSet("NOTIFYOBJECT");
            objectSet.setWhere("");
            objectSet.resetQbe();
            objectSet.reset();
            MboRemote object = objectSet.moveFirst();
            while (object != null) {
                MboSetRemote msr;
                String viewName;
                String objName;
                block42: {
                    objName = object.getString("OBJECTNAME").toLowerCase();
                    viewName = null;
                    if (!triggerRoots.contains(objName)) {
                        if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                            NotifyConstants.INFORMER_LOGGER.debug((Object)("Adding trigger " + objName));
                        }
                        triggerRoots.add(objName);
                    }
                    msr = null;
                    try {
                        msr = MXServer.getMXServer().getMboSet(objName.toUpperCase(), MXServer.getMXServer().getSystemUserInfo());
                        MboSetInfo msi = msr.getMboSetInfo();
                        if (!msi.isView()) break block42;
                        viewName = objName;
                        objName = msi.getBaseMboInfo().getObjectName();
                        if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                            NotifyConstants.INFORMER_LOGGER.debug((Object)("Found root view object name: " + objName));
                        }
                    }
                    catch (Throwable throwable) {
                        NotifyUtil.closeAndCleanup(msr);
                        throw throwable;
                    }
                }
                NotifyUtil.closeAndCleanup(msr);
                HashMap relationships = MXServerFactory.getMXServer().getMaximoDD().getRelationships(objName.toUpperCase());
                MboSetRemote attributeSet = object.getMboSet("NOTIFYATTRIBUTE");
                MboRemote mbo = attributeSet.moveFirst();
                while (mbo != null) {
                    String attribute = mbo.getString("ATTRIBUTENAME");
                    if (attribute != null && attribute.contains(".")) {
                        String relationshipName = attribute.substring(0, attribute.indexOf("."));
                        String relTrigger = null;
                        RelationInfo ri = (RelationInfo)relationships.get(relationshipName);
                        if (ri == null) {
                            if (viewName != null) {
                                HashMap viewRelationships = MXServerFactory.getMXServer().getMaximoDD().getRelationships(viewName.toUpperCase());
                                ri = (RelationInfo)viewRelationships.get(relationshipName);
                                if (ri != null) {
                                    relTrigger = ri.getDest().toLowerCase();
                                } else {
                                    NotifyConstants.INFORMER_LOGGER.warn((Object)("Could not find the relationship " + relationshipName + " for the view " + viewName + " on the base object " + objName + " and attribute " + attribute));
                                }
                            } else {
                                NotifyConstants.INFORMER_LOGGER.warn((Object)("Could not find the relationship " + relationshipName + " for the object " + objName + " and attribute " + attribute));
                            }
                        } else {
                            relTrigger = ri.getDest().toLowerCase();
                        }
                        if (!triggerRoots.contains(relTrigger)) {
                            if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                                NotifyConstants.INFORMER_LOGGER.debug((Object)("Adding related trigger  " + relTrigger));
                            }
                            triggerRoots.add(relTrigger);
                        }
                    }
                    mbo = attributeSet.moveNext();
                }
                object = objectSet.moveNext();
            }
            NotifyEventListener nel = new NotifyEventListener(notify);
            NotificationEventRegistration registration = new NotificationEventRegistration(notify.getUniqueIDValue(), notify.getLong("REVISION"));
            try {
                for (String trigger : triggerRoots) {
                    String subject = "maximo." + trigger + ".*";
                    int regId = MXServer.getEventTopicTree().register(subject, (EventListener)nel);
                    registration.add(subject, regId);
                    this.addListenerRecord(regId, subject, registration.getNotifyId(), -1L, registration.getRevision());
                    if (!NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) continue;
                    NotifyConstants.INFORMER_LOGGER.debug((Object)("Adding event registration for " + subject + " with event registration ID " + regId + " for profile " + notify.getString("NOTIFYNUM")));
                }
                MboSetRemote catalogSet = notify.getMboSet("CATALOG");
                catalogSet.setLogLargFetchResultDisabled(true);
                MboRemote mbo = catalogSet.moveFirst();
                while (mbo != null) {
                    CatalogRemote catalog = (CatalogRemote)mbo;
                    if (catalog.isEventStrategy()) {
                        registration.add(this.registerCatalogListener(catalog));
                    }
                    mbo = catalogSet.moveNext();
                }
                return registration;
            }
            catch (RemoteException e) {
                try {
                    this.unregisterNotificationListener(registration);
                }
                catch (Throwable t) {
                    NotifyConstants.INFORMER_LOGGER.error((Object)("Error while attempting to undo registration of listeners for Informer profile " + registration.getNotifyId()), t);
                }
                throw e;
            }
            catch (MXException e) {
                try {
                    this.unregisterNotificationListener(registration);
                }
                catch (Throwable t) {
                    NotifyConstants.INFORMER_LOGGER.error((Object)("Error while attempting to undo registration of listeners for Informer profile " + registration.getNotifyId()), t);
                }
                throw e;
            }
            catch (RuntimeException rte) {
                try {
                    this.unregisterNotificationListener(registration);
                }
                catch (Throwable t) {
                    NotifyConstants.INFORMER_LOGGER.error((Object)("Error while attempting to undo registration of listeners for Informer profile " + registration.getNotifyId()), t);
                }
                throw rte;
            }
        }
        return null;
    }

    private List<CatalogEventRegistration> registerCatalogListener(CatalogRemote catalog) throws RemoteException, MXException {
        if (catalog != null) {
            if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                NotifyConstants.INFORMER_LOGGER.debug((Object)("Registering event listeners for catalog " + catalog.getString("CATALOG")));
            }
            ArrayList<CatalogEventRegistration> registrations = new ArrayList<CatalogEventRegistration>();
            try {
                String subject = "maximo." + catalog.getString("OBJECTNAME").toLowerCase() + ".*";
                int regId = MXServer.getEventTopicTree().register(subject, (EventListener)new CatalogEventListener(catalog));
                registrations.add(new CatalogEventRegistration(catalog, regId, subject));
                this.addListenerRecord(regId, subject, catalog.getLong("NOTIFYID"), -1L, catalog.getLong("NOTIFY.REVISION"));
                if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                    NotifyConstants.INFORMER_LOGGER.debug((Object)("Adding event registration for " + subject + " with event registration ID " + regId + " for catalog " + catalog.getString("CATALOG")));
                }
                MboSetRemote listenerSet = catalog.getMboSet("CATALOGLISTENER");
                MboRemote listener = listenerSet.moveFirst();
                while (listener != null) {
                    String listenerObjectName = listener.getString("OBJECTNAME").toLowerCase();
                    subject = "maximo." + listenerObjectName + ".*";
                    String listenerRelationship = null;
                    String listenerWhereClause = null;
                    if (!listener.isNull("WHERECLAUSE")) {
                        listenerWhereClause = listener.getString("WHERECLAUSE");
                    } else if (!listener.isNull("RELATIONSHIP")) {
                        listenerRelationship = listener.getString("RELATIONSHIP");
                    }
                    regId = MXServer.getEventTopicTree().register(subject, (EventListener)new CatalogEventListener(catalog, listenerObjectName, listenerRelationship, listenerWhereClause));
                    registrations.add(new CatalogEventRegistration(catalog, regId, subject));
                    this.addListenerRecord(regId, subject, catalog.getLong("NOTIFYID"), -1L, catalog.getLong("NOTIFY.REVISION"));
                    if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                        NotifyConstants.INFORMER_LOGGER.debug((Object)("Adding event registration for " + subject + " with event registration ID " + regId + " for catalog " + catalog.getString("CATALOG")));
                    }
                    listener = listenerSet.moveNext();
                }
                return registrations;
            }
            catch (RemoteException e) {
                for (CatalogEventRegistration cer : registrations) {
                    try {
                        this.unregisterCatalogListener(cer);
                    }
                    catch (Throwable t) {
                        NotifyConstants.INFORMER_LOGGER.error((Object)("Error while attempting to undo registration of listener " + cer.getRegId() + " for subject " + cer.getSubject()), t);
                    }
                }
                throw e;
            }
            catch (MXException e) {
                for (CatalogEventRegistration cer : registrations) {
                    try {
                        this.unregisterCatalogListener(cer);
                    }
                    catch (Throwable t) {
                        NotifyConstants.INFORMER_LOGGER.error((Object)("Error while attempting to undo registration of listener " + cer.getRegId() + " for subject " + cer.getSubject()), t);
                    }
                }
                throw e;
            }
            catch (RuntimeException rte) {
                for (CatalogEventRegistration cer : registrations) {
                    try {
                        this.unregisterCatalogListener(cer);
                    }
                    catch (Throwable t) {
                        NotifyConstants.INFORMER_LOGGER.error((Object)("Error while attempting to undo registration of listener " + cer.getRegId() + " for subject " + cer.getSubject()), t);
                    }
                }
                throw rte;
            }
        }
        return null;
    }

    private synchronized void ensureRevisionsSet() {
        MboSetRemote notifySet = null;
        try {
            notifySet = MXServer.getMXServer().getMboSet("ISNOTIFY", MXServer.getMXServer().getSystemUserInfo());
            notifySet.setWhere("revision is null");
            notifySet.reset();
            MboRemote notify = notifySet.moveFirst();
            while (notify != null) {
                notify.setValue("REVISION", 0);
                notify = notifySet.moveNext();
            }
            notifySet.save();
        }
        catch (Exception e) {
            try {
                NotifyConstants.INFORMER_LOGGER.warn((Object)"An error occurred while trying to set default revision numbers to zero.");
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(notifySet);
                throw throwable;
            }
            NotifyUtil.closeAndCleanup(notifySet);
        }
        NotifyUtil.closeAndCleanup(notifySet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void addListenerRecord(int regId, String subject, long notifyid, long catalogid, long revision) {
        if (!this.listenerMonitorTableEnabled.booleanValue()) {
            return;
        }
        MboSetRemote set = null;
        String host = "Unknown Host";
        String node = "Unknown MXServer";
        try {
            host = MXServer.getMXServer().getRegistryHostName();
            if (host == null) {
                host = InetAddress.getLocalHost().getHostName();
            }
        }
        catch (Throwable t) {
            NotifyConstants.INFORMER_NRQP_LOGGER.error((Object)t);
        }
        try {
            node = MXServer.getMXServer().getName();
        }
        catch (Throwable t) {
            NotifyConstants.INFORMER_NRQP_LOGGER.error((Object)t);
        }
        if (node == null) {
            node = "Unknown MXServer";
        }
        try {
            set = MXServer.getMXServer().getMboSet("ISNOTIFYLISTENERREG", MXServer.getMXServer().getSystemUserInfo());
            MboRemote mbo = set.add();
            if (catalogid > 0L) {
                mbo.setValue("CATALOGID", catalogid);
            }
            mbo.setValue("NOTIFYID", notifyid);
            mbo.setValue("HOST", host);
            mbo.setValue("NODE", node);
            mbo.setValue("REGID", regId);
            mbo.setValue("SUBJECT", subject);
            mbo.setValue("CREATEDATE", MXServer.getMXServer().getDate());
            mbo.setValue("REVISION", revision);
            set.save();
        }
        catch (RemoteException e) {
            NotifyConstants.INFORMER_LOGGER.warn((Object)"Error adding listener record.", (Throwable)e);
            NotifyUtil.closeAndCleanup(set);
        }
        catch (MXException e2) {
            NotifyConstants.INFORMER_LOGGER.warn((Object)"Error adding listener record.", (Throwable)e2);
            {
                catch (Throwable throwable) {
                    NotifyUtil.closeAndCleanup(set);
                    throw throwable;
                }
            }
            NotifyUtil.closeAndCleanup(set);
        }
        NotifyUtil.closeAndCleanup(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void removeListenerRecord(int regId, String subject) {
        if (!this.listenerMonitorTableEnabled.booleanValue()) {
            return;
        }
        MboSetRemote set = null;
        String host = "Unknown Host";
        String node = "Unknown MXServer";
        try {
            host = MXServer.getMXServer().getRegistryHostName();
            if (host == null) {
                host = InetAddress.getLocalHost().getHostName();
            }
        }
        catch (Throwable t) {
            NotifyConstants.INFORMER_NRQP_LOGGER.error((Object)t);
        }
        try {
            node = MXServer.getMXServer().getName();
        }
        catch (Throwable t) {
            NotifyConstants.INFORMER_NRQP_LOGGER.error((Object)t);
        }
        if (node == null) {
            node = "Unknown MXServer";
        }
        try {
            set = MXServer.getMXServer().getMboSet("ISNOTIFYLISTENERREG", MXServer.getMXServer().getSystemUserInfo());
            SqlFormat sqlf = new SqlFormat("regid = :1 and subject = :2 and host = :3 and node = :4");
            sqlf.setLong(1, (long)regId);
            sqlf.setObject(2, "ISNOTIFYLISTENERREG", "SUBJECT", subject);
            sqlf.setObject(3, "ISNOTIFYLISTENERREG", "HOST", host);
            sqlf.setObject(4, "ISNOTIFYLISTENERREG", "NODE", node);
            set.setWhere(sqlf.format());
            set.deleteAll();
            set.save();
        }
        catch (RemoteException e) {
            NotifyConstants.INFORMER_LOGGER.warn((Object)"Error removing listener record.", (Throwable)e);
            NotifyUtil.closeAndCleanup(set);
        }
        catch (MXException e2) {
            NotifyConstants.INFORMER_LOGGER.warn((Object)"Error removing listener record.", (Throwable)e2);
            {
                catch (Throwable throwable) {
                    NotifyUtil.closeAndCleanup(set);
                    throw throwable;
                }
            }
            NotifyUtil.closeAndCleanup(set);
        }
        NotifyUtil.closeAndCleanup(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cleanListenerRecords() {
        MboSetRemote set = null;
        String host = "Unknown Host";
        String node = "Unknown MXServer";
        try {
            host = MXServer.getMXServer().getRegistryHostName();
            if (host == null) {
                host = InetAddress.getLocalHost().getHostName();
            }
        }
        catch (Throwable t) {
            NotifyConstants.INFORMER_NRQP_LOGGER.error((Object)t);
        }
        try {
            node = MXServer.getMXServer().getName();
        }
        catch (Throwable t) {
            NotifyConstants.INFORMER_NRQP_LOGGER.error((Object)t);
        }
        if (node == null) {
            node = "Unknown MXServer";
        }
        try {
            SqlFormat sqlf = new SqlFormat("host = :1 and node = :2");
            sqlf.setObject(1, "ISNOTIFYLISTENERREG", "HOST", host);
            sqlf.setObject(2, "ISNOTIFYLISTENERREG", "NODE", node);
            MboUtil.deleteIteratively(MXServer.getMXServer().getSystemUserInfo(), "ISNOTIFYLISTENERREG", sqlf.format());
        }
        catch (RemoteException e) {
            NotifyConstants.INFORMER_LOGGER.warn((Object)"Error cleaning listener record.", (Throwable)e);
        }
        catch (MXException e) {
            NotifyConstants.INFORMER_LOGGER.warn((Object)"Error cleaning listener record.", (Throwable)e);
        }
        finally {
            NotifyUtil.closeAndCleanup(set);
        }
    }

    public void waitForInitCompletion() throws InterruptedException {
        this.initDone.await();
    }

    private class ProfMaxCache
    implements MaximoCache {
        private ProfMaxCache() {
        }

        public void init() throws MXException {
            CatalogCache.clearCatalogCache();
            NotificationEventListenerManager.this.reevaluate();
        }

        public void reload() throws MXException {
            this.reload("p");
        }

        public void reload(String s) throws MXException {
            if ("p".equals(s)) {
                CatalogCache.clearCatalogCache();
                NotificationEventListenerManager.this.reevaluate();
            } else {
                Matcher matcher = RELOAD_KEY_PATTERN_CATALOG.matcher(s);
                if (matcher.matches()) {
                    String catalogIdStr = matcher.group(1);
                    if (catalogIdStr.isEmpty()) {
                        CatalogCache.clearCatalogCache();
                    } else {
                        try {
                            long catalogId = Long.parseLong(catalogIdStr);
                            CatalogCache.clearCatalogCacheForCatalog(catalogId);
                        }
                        catch (NumberFormatException e) {
                            LOGGER.warn((Object)String.format("MaxCache %s received a refresh key of \"%s\", but ID component %s could not be parsed. Performing a refresh of all Catalogs as the safest default.", NotificationEventListenerManager.PROFILE_CACHE_NAME, s, catalogIdStr));
                            CatalogCache.clearCatalogCache();
                        }
                    }
                } else {
                    LOGGER.warn((Object)String.format("MaxCache %s received a refresh key of \"%s\", but this key was not recognized. Performing a full refresh as the safest default.", NotificationEventListenerManager.PROFILE_CACHE_NAME, s));
                    CatalogCache.clearCatalogCache();
                    NotificationEventListenerManager.this.reevaluate();
                }
            }
        }

        public String getName() {
            return NotificationEventListenerManager.PROFILE_CACHE_NAME;
        }
    }

    public static class ProfileCache {
        private static MXLogger LOGGER = NotifyConstants.INFORMER_LOGGER;

        public static long[] getNotifyIds(Collection<String> notifyNums) {
            long[] results = new long[notifyNums.size()];
            int i = 0;
            for (String notifyNum : notifyNums) {
                results[i++] = ProfileCache.getNotifyId(notifyNum);
            }
            return results;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static long getNotifyId(String notifyNum) {
            if (notifyNum == null) {
                return -1L;
            }
            for (CachedNotifyProfile cachedProfile : cachedNotifyProfiles.values()) {
                String thisNotifyNum = cachedProfile.getNotifynum();
                if (!notifyNum.equals(thisNotifyNum)) continue;
                return cachedProfile.getNotifyId();
            }
            LOGGER.debug((Object)("A cached copy of Profile " + notifyNum + " was not found. Fetching."));
            try {
                MXServer mxServer = MXServer.getMXServer();
                MboSetRemote profileSet = mxServer.getMboSet("ISNOTIFY", mxServer.getSystemUserInfo());
                try {
                    SqlFormat sqlf = new SqlFormat("notifynum = :1");
                    sqlf.setObject(1, "ISNOTIFY", "NOTIFYNUM", notifyNum);
                    profileSet.setWhere(sqlf.format());
                    MboRemote profile = profileSet.getMbo(0);
                    if (profile != null) {
                        long l = profile.getLong("NOTIFYID");
                        return l;
                    }
                    LOGGER.info((Object)("Profile " + notifyNum + " does not exist."));
                    long l = -1L;
                    return l;
                }
                finally {
                    NotifyUtil.closeAndCleanup(profileSet);
                }
            }
            catch (RemoteException e) {
                LOGGER.info((Object)String.format("Attempt to fetch Profile info from persistence for Profile with NotifyNum %s failed. Giving up.", notifyNum), (Throwable)e);
                return -1L;
            }
            catch (MXException e) {
                LOGGER.info((Object)String.format("Attempt to fetch Profile info from persistence for Profile with NotifyNum %s failed. Giving up.", notifyNum), (Throwable)e);
                return -1L;
            }
        }
    }

    public static class CatalogCache {
        private static final Map<Long, CachedCatalog> cachedCatalogMap = Collections.synchronizedMap(new HashMap());
        private static MXLogger LOGGER = NotifyConstants.INFORMER_LOGGER;

        @Deprecated
        @Nullable
        public static CachedCatalog getCachedCatalog(long catalogId) {
            try {
                return CatalogCache.getCatalogOrNull(catalogId);
            }
            catch (RemoteException e) {
                LOGGER.info((Object)String.format("Attempt to fetch Catalog info from persistence for Catalog with ID %1$d failed. Giving up.", catalogId), (Throwable)e);
                return null;
            }
            catch (MXException e) {
                LOGGER.info((Object)String.format("Attempt to fetch Catalog info from persistence for Catalog with ID %1$d failed. Giving up.", catalogId), (Throwable)e);
                return null;
            }
        }

        @Nullable
        public static CachedCatalog getCatalogOrNull(long catalogId) throws MXException, RemoteException {
            try {
                return CatalogCache.getCatalogOrThrow(catalogId);
            }
            catch (NoSuchCatalogException e) {
                LOGGER.debug((Object)e.getMessage());
                return null;
            }
        }

        @NotNull
        public static CachedCatalog getCatalogOrThrow(long catalogId) throws MXException, RemoteException, NoSuchCatalogException {
            CachedCatalog fetchResult = cachedCatalogMap.get(catalogId);
            if (fetchResult == null) {
                LOGGER.info((Object)String.format("Attempt to fetch cached Catalog failed. No Catalog with ID %1$d was found. An attempt will be made to load this Catalog from persistence.", catalogId));
                fetchResult = CatalogCache.freshPullOrThrow(catalogId);
                LOGGER.info((Object)String.format("Catalog with ID %d was found and will be cached for further requests.", catalogId));
                cachedCatalogMap.put(fetchResult.catalogId, fetchResult);
            }
            return fetchResult;
        }

        @Deprecated
        @Nullable
        public static CachedCatalog getCachedCatalog(long catalogId, long catalogRevision) {
            try {
                return CatalogCache.getCatalogOrNull(catalogId, catalogRevision);
            }
            catch (RemoteException e) {
                LOGGER.info((Object)String.format("Attempt to fetch Catalog info from persistence for Catalog with ID %1$d and Revision %2$d failed. Giving up.", catalogId, catalogRevision), (Throwable)e);
                return null;
            }
            catch (MXException e) {
                LOGGER.info((Object)String.format("Attempt to fetch Catalog info from persistence for Catalog with ID %1$d and Revision %2$d failed. Giving up.", catalogId, catalogRevision), (Throwable)e);
                return null;
            }
        }

        @Nullable
        public static CachedCatalog getCatalogOrNull(long catalogId, long catalogRevision) throws RemoteException, MXException {
            try {
                return CatalogCache.getCatalogOrThrow(catalogId, catalogRevision);
            }
            catch (NoSuchCatalogException e) {
                LOGGER.debug((Object)String.format("Catalog with ID %1$d and Revision %2$d could not be found: %3$s", catalogId, catalogRevision, e.getMessage()));
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public static CachedCatalog getCatalogOrThrow(long catalogId, long catalogRevision) throws RemoteException, MXException, NoSuchCatalogException {
            CachedCatalog initialResult = CatalogCache.getCatalogOrNull(catalogId);
            if (initialResult == null) {
                throw NoSuchCatalogException.catalogIdInvalid(catalogId);
            }
            if (initialResult.catalogRevision == catalogRevision) {
                return initialResult;
            }
            if (catalogRevision < initialResult.catalogRevision) {
                LOGGER.debug((Object)String.format("A request was made for Catalog %1$d, revision %2$d, but the current official revision is >= %3$d. This request cannot be served.", catalogId, catalogRevision, initialResult.catalogRevision));
                throw NoSuchCatalogException.revisionOutdated(catalogId, catalogRevision);
            }
            LOGGER.debug((Object)String.format("A request was made for Catalog %1$d, revision %2$d. A copy of Catalog %1$d was found, but with a lower revision number of %3$d. Checking for a newer copy.", catalogId, catalogRevision, initialResult.catalogRevision));
            CachedCatalog refetchResult = CatalogCache.freshPullOrThrow(catalogId);
            if (refetchResult.catalogRevision != initialResult.catalogRevision) {
                Map<Long, CachedCatalog> map = cachedCatalogMap;
                synchronized (map) {
                    LOGGER.info((Object)String.format("Catalog with ID %d, revision %d was found and will be cached for further requests.", catalogId, catalogRevision));
                    cachedCatalogMap.put(refetchResult.catalogId, refetchResult);
                }
            }
            if (catalogRevision < refetchResult.catalogRevision) {
                LOGGER.debug((Object)String.format("A request was made for Catalog %1$d, revision %2$d, but the current official revision in persistence is >= %3$d. This request cannot be served.", catalogId, catalogRevision, refetchResult.catalogRevision));
                throw NoSuchCatalogException.revisionOutdated(catalogId, catalogRevision);
            }
            if (catalogRevision > refetchResult.catalogRevision) {
                LOGGER.debug((Object)String.format("A request was made for Catalog %1$d, revision %2$d, but the current official revision in persistence is >= %3$d. This request cannot be served.", catalogId, catalogRevision, refetchResult.catalogRevision));
                throw NoSuchCatalogException.revisionInvalid(catalogId, catalogRevision);
            }
            return refetchResult;
        }

        @Deprecated
        @Nullable
        public static CachedCatalog getCachedCatalog(long notifyId, @NotNull String catalogName) {
            try {
                return CatalogCache.getCatalogOrThrow(notifyId, catalogName);
            }
            catch (NoSuchCatalogException e) {
                LOGGER.debug((Object)e.getMessage());
                return null;
            }
            catch (RemoteException e) {
                LOGGER.info((Object)String.format("Attempt to fetch Catalog info from persistence for Catalog  %2$s of Profile %1$d failed. Giving up.", notifyId, catalogName), (Throwable)e);
                return null;
            }
            catch (MXException e) {
                LOGGER.info((Object)String.format("Attempt to fetch Catalog info from persistence for Catalog  %2$s of Profile %1$d failed. Giving up.", notifyId, catalogName), (Throwable)e);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public static CachedCatalog getCatalogOrThrow(long notifyId, @NotNull String catalogName) throws MXException, RemoteException, NoSuchCatalogException {
            CachedCatalog fetchResult = null;
            Map<Long, CachedCatalog> map = cachedCatalogMap;
            synchronized (map) {
                for (CachedCatalog cat : cachedCatalogMap.values()) {
                    if (cat.notifyId != notifyId || !cat.catalogName.equals(catalogName)) continue;
                    fetchResult = cat;
                    break;
                }
            }
            if (fetchResult == null) {
                LOGGER.info((Object)String.format("Attempt to fetch cached Catalog failed. No Catalog \"%2$s\" of Profile %1$d was found. An attempt will be made to load this Catalog from persistence.", notifyId, catalogName));
                fetchResult = CatalogCache.freshPullOrThrow(notifyId, catalogName);
                LOGGER.info((Object)String.format("Catalog \"%2$s\" of Profile %1$d was found and will be cached for further requests.", notifyId, catalogName));
                cachedCatalogMap.put(fetchResult.catalogId, fetchResult);
            }
            return fetchResult;
        }

        @Deprecated
        @Nullable
        public static CachedCatalog getCachedCatalog(@NotNull String notifyNum, @NotNull String catalogName) {
            try {
                return CatalogCache.getCatalogOrThrow(notifyNum, catalogName);
            }
            catch (NoSuchCatalogException e) {
                LOGGER.debug((Object)e.getMessage());
                return null;
            }
            catch (RemoteException e) {
                LOGGER.info((Object)String.format("Attempt to fetch Catalog info from persistence for Catalog \"%s\" of Profile \"%s\" failed. Giving up.", catalogName, notifyNum), (Throwable)e);
                return null;
            }
            catch (MXException e) {
                LOGGER.info((Object)String.format("Attempt to fetch Catalog info from persistence for Catalog \"%s\" of Profile \"%s\" failed. Giving up.", catalogName, notifyNum), (Throwable)e);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public static CachedCatalog getCatalogOrThrow(@NotNull String notifyNum, @NotNull String catalogName) throws NoSuchCatalogException, RemoteException, MXException {
            CachedCatalog fetchResult = null;
            Map<Long, CachedCatalog> map = cachedCatalogMap;
            synchronized (map) {
                for (CachedCatalog cat : cachedCatalogMap.values()) {
                    if (!cat.notifyNum.equals(notifyNum) || !cat.catalogName.equals(catalogName)) continue;
                    fetchResult = cat;
                    break;
                }
            }
            if (fetchResult == null) {
                LOGGER.info((Object)String.format("Attempt to fetch cached Catalog failed. No Catalog \"%s\" of Profile \"%s\" was found. An attempt will be made to load this Catalog from persistence.", catalogName, notifyNum));
                fetchResult = CatalogCache.freshPullOrThrow(notifyNum, catalogName);
                LOGGER.info((Object)String.format("Catalog \"%s\" of Profile \"%s\" was found and will be cached for further requests.", catalogName, notifyNum));
                cachedCatalogMap.put(fetchResult.catalogId, fetchResult);
            }
            return fetchResult;
        }

        @NotNull
        private static CachedCatalog freshPullOrThrow(long catalogId) throws RemoteException, MXException, NoSuchCatalogException {
            MboSetRemote catalogSet = MXServer.getMXServer().getMboSet("ISCATALOG", MXServer.getMXServer().getSystemUserInfo());
            try {
                catalogSet.setFlag(39L, true);
                MboRemote catalog = catalogSet.getMboForUniqueId(catalogId);
                if (catalog != null) {
                    CachedCatalog cachedCatalog = new CachedCatalog(catalog);
                    return cachedCatalog;
                }
                throw NoSuchCatalogException.catalogIdInvalid(catalogId);
            }
            finally {
                NotifyUtil.closeAndCleanup(catalogSet);
            }
        }

        @NotNull
        private static CachedCatalog freshPullOrThrow(long notifyId, String catalogName) throws RemoteException, MXException, NoSuchCatalogException {
            MboSetRemote catalogSet = MXServer.getMXServer().getMboSet("ISCATALOG", MXServer.getMXServer().getSystemUserInfo());
            try {
                SqlFormat sqlf = new SqlFormat("notifyid = :1 AND catalog = :2");
                sqlf.setLong(1, notifyId);
                sqlf.setObject(2, "ISCATALOG", "CATALOG", catalogName);
                catalogSet.setWhere(sqlf.format());
                catalogSet.setFlag(39L, true);
                MboRemote catalog = catalogSet.getMbo(0);
                if (catalog != null) {
                    CachedCatalog cachedCatalog = new CachedCatalog(catalog);
                    return cachedCatalog;
                }
                throw NoSuchCatalogException.notifyidCatalogComboInvalid(notifyId, catalogName);
            }
            finally {
                NotifyUtil.closeAndCleanup(catalogSet);
            }
        }

        @NotNull
        private static CachedCatalog freshPullOrThrow(@NotNull String notifyNum, @NotNull String catalogName) throws RemoteException, MXException, NoSuchCatalogException {
            MboSetRemote catalogSet = MXServer.getMXServer().getMboSet("ISCATALOG", MXServer.getMXServer().getSystemUserInfo());
            try {
                SqlFormat sqlf = new SqlFormat("notifyid = (SELECT notifyid FROM isnotify WHERE notifynum = :1) AND catalog = :2");
                sqlf.setObject(1, "ISNOTIFY", "NOTIFYNUM", notifyNum);
                sqlf.setObject(2, "ISCATALOG", "CATALOG", catalogName);
                catalogSet.setWhere(sqlf.format());
                catalogSet.setFlag(39L, true);
                MboRemote catalog = catalogSet.getMbo(0);
                if (catalog != null) {
                    CachedCatalog cachedCatalog = new CachedCatalog(catalog);
                    return cachedCatalog;
                }
                throw NoSuchCatalogException.notifynumCatalogComboInvalid(notifyNum, catalogName);
            }
            finally {
                NotifyUtil.closeAndCleanup(catalogSet);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void clearCatalogCache() throws MXException {
            Map<Long, CachedCatalog> map = cachedCatalogMap;
            synchronized (map) {
                cachedCatalogMap.clear();
            }
        }

        private static void clearCatalogCacheForCatalog(long catalogId) throws MXException {
            cachedCatalogMap.remove(catalogId);
        }

        public static void reloadCache() throws RemoteException, MXException {
            MXServer.getMXServer().reloadMaximoCache(NotificationEventListenerManager.PROFILE_CACHE_NAME, NotificationEventListenerManager.CACHE_KEY_ALL_CATALOGS, true);
        }

        public static void reloadCacheForCatalog(long catalogId) throws RemoteException, MXException {
            MXServer.getMXServer().reloadMaximoCache(NotificationEventListenerManager.PROFILE_CACHE_NAME, NotificationEventListenerManager.CACHE_KEY_ALL_CATALOGS + catalogId, true);
        }
    }
}

