/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.util.MboSetIterator;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.util.StringUtils;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.security.ConnectionKey;
import psdi.security.UserInfo;
import psdi.server.DBManager;
import psdi.server.MXServer;
import psdi.server.SimpleCronTask;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

public class NotificationCleanupCrontask
extends SimpleCronTask {
    public void cronAction() {
        MXLogger logger2 = this.getCronTaskLogger();
        try {
            UserInfo userInfo = this.getRunasUserInfo();
            this.cleanupTrackingData(userInfo);
            this.cleanupUserNotifications(userInfo);
            logger2.info((Object)"Notification data purge operation complete");
        }
        catch (SQLException e) {
            logger2.error((Object)"An error occurred while purging obsolete Notification data", (Throwable)e);
        }
        catch (RemoteException e) {
            logger2.error((Object)"An error occurred while purging obsolete Notification data", (Throwable)e);
        }
        catch (MXException e) {
            logger2.error((Object)"An error occurred while purging obsolete Notification data", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupTrackingData(UserInfo userInfo) throws SQLException, RemoteException {
        MXLogger logger2 = this.getCronTaskLogger();
        if (NotifyUtil.isTrackingRetrieval()) {
            DBManager dbManager = MXServer.getMXServer().getDBManager();
            ConnectionKey key = userInfo.getConnectionKey();
            Connection cnn = dbManager.getConnection(key);
            try {
                try (Statement s = cnn.createStatement();){
                    s.execute("DELETE isretrievaltracking WHERE usernotificationid IN (SELECT usernotificationid FROM isusernotification un WHERE notifyid NOT IN (SELECT notifyid FROM isnotifyuser WHERE userid = un.userid))");
                }
                cnn.commit();
                logger2.info((Object)"Catalog data purge operation complete");
            }
            catch (SQLException e) {
                logger2.error((Object)"An error occurred while purging obsolete Catalog data", (Throwable)e);
            }
            finally {
                dbManager.freeConnection(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupUserNotifications(UserInfo userInfo) throws RemoteException, MXException, SQLException {
        MXLogger logger2 = this.getCronTaskLogger();
        logger2.debug((Object)"Identifying valid Informer Profiles");
        MboSetRemote profileSet = MXServer.getMXServer().getMboSet("ISNOTIFY", userInfo);
        profileSet.setFlag(7L, true);
        try {
            ArrayList<Long> notifyIds = new ArrayList<Long>();
            MboSetIterator profileItr = new MboSetIterator(profileSet);
            MboRemote profile = profileItr.moveFirst();
            while (profile != null) {
                notifyIds.add(profile.getLong("NOTIFYID"));
                profile = profileItr.moveNext();
            }
            String notifyIdsCsv = StringUtils.join(notifyIds, ", ");
            logger2.info((Object)String.format("Identified %d valid Profiles, with IDs (%s)", notifyIds.size(), notifyIdsCsv));
            logger2.debug((Object)"Deleting users associated with invalid Profiles");
            String whereClause = new SqlFormat("notifyid NOT IN (" + notifyIdsCsv + ")").format();
            int numDeleted = NotifyUtil.deleteIteratively(userInfo, "ISNOTIFYUSER", whereClause);
            logger2.info((Object)String.format("Deleted %d users associated with invalid Profiles", numDeleted));
            logger2.debug((Object)"Deleting user notifications associated with invalid Profiles");
            whereClause = new SqlFormat("notifyid NOT IN (" + notifyIdsCsv + ")").format();
            numDeleted = NotifyUtil.visitMbos(userInfo, "ISUSERNOTIFICATION", whereClause, new UserNotificationDeleter());
            logger2.info((Object)String.format("Deleted %d user notifications associated with invalid Profiles", numDeleted));
            MboSetIterator profileItr2 = new MboSetIterator(profileSet);
            MboRemote profile2 = profileItr2.moveFirst();
            while (profile2 != null) {
                logger2.debug((Object)String.format("Deleting user notifications associated with invalid Users of Profile %d", profile2.getLong("NOTIFYID")));
                String whereClause2 = new SqlFormat(profile2, "notifyid = :notifyid AND userid NOT IN (SELECT userid FROM isnotifyuser WHERE notifyid = :notifyid)").format();
                int numDeleted2 = NotifyUtil.visitMbos(userInfo, "ISUSERNOTIFICATION", whereClause2, new UserNotificationDeleter());
                logger2.info((Object)String.format("Deleted %d user notifications associated with invalid users of Profile %d", numDeleted2, profile2.getLong("NOTIFYID")));
                profile2 = profileItr2.moveNext();
            }
        }
        finally {
            NotifyUtil.closeAndCleanup(profileSet);
        }
    }

    private class UserNotificationDeleter
    implements NotifyUtil.MboVisitor {
        private UserNotificationDeleter() {
        }

        @Override
        public void visit(MboRemote mbo) throws RemoteException, MXException {
            mbo.setValue("DIRECTDELETE", true);
            mbo.delete();
        }
    }
}

