/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.NotifyUserSet;
import com.interlocsolutions.maximo.notify.SecurityChangeListener;
import com.interlocsolutions.maximo.notify.SecurityUserChangeListener;
import java.rmi.RemoteException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import psdi.app.signature.MaxUserRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.MboValue;
import psdi.mbo.MboValueAdapter;
import psdi.server.MXServer;
import psdi.util.MXApplicationException;
import psdi.util.MXException;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0002J\b\u0010\b\u001a\u00020\u0006H\u0002J\b\u0010\t\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"Lcom/interlocsolutions/maximo/notify/FldNotifyUserDisabled;", "Lpsdi/mbo/MboValueAdapter;", "mv", "Lpsdi/mbo/MboValue;", "(Lpsdi/mbo/MboValue;)V", "validate", "", "verifyApplicationAccess", "verifyLicense", "verifyUserStatus", "isinformer"})
public final class FldNotifyUserDisabled
extends MboValueAdapter {
    public FldNotifyUserDisabled(@NotNull MboValue mv) {
        Intrinsics.checkNotNullParameter((Object)mv, (String)"mv");
        super(mv);
    }

    public void validate() throws MXException, RemoteException {
        super.validate();
        if (!MXServer.getBulletinBoard().isPosted("informer.NotifyUserAdd") && !this.mboValue.getBoolean()) {
            this.verifyUserStatus();
            this.verifyApplicationAccess();
            this.verifyLicense();
        }
    }

    private final void verifyUserStatus() throws MXException, RemoteException {
        MaxUserRemote maxUser = (MaxUserRemote)this.mboValue.getMbo().getMboSet("MAXUSER").getMbo(0);
        if (maxUser == null) {
            throw new MXApplicationException("informer", "disabled.userDoesNotExist");
        }
        if (!SecurityUserChangeListener.verifyUserStatus(maxUser)) {
            Object[] objectArray = new String[]{maxUser.getString("STATUS")};
            throw new MXApplicationException("informer", "disabled.invalidUserStatus", objectArray);
        }
    }

    private final void verifyLicense() throws MXException, RemoteException {
        MboSetRemote mboSetRemote = this.mboValue.getMbo().getThisMboSet();
        Intrinsics.checkNotNullExpressionValue((Object)mboSetRemote, (String)"mboValue.mbo.thisMboSet");
        if (!NotifyUserSet.Companion.checkLicenseForUserCount$default(NotifyUserSet.Companion, mboSetRemote, 0, 2, null)) {
            throw new MXApplicationException("informer", "disabled.insufficientLicenses");
        }
    }

    private final void verifyApplicationAccess() throws MXException, RemoteException {
        List<String> apps2;
        String userId = this.getMboValue("USERID").getString();
        if (!SecurityChangeListener.hasSufficientAccess(userId, apps2 = SecurityChangeListener.getApplicationsForProfile(this.mboValue.getMbo().getMboSet("NOTIFY").getMbo(0)))) {
            throw new MXApplicationException("informer", "disabled.insufficientAccess");
        }
    }
}

