/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.util.License;
import com.interlocsolutions.maximo.notify.util.LicenseManager;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.util.MXServerFactory;
import com.interlocsolutions.maximo.util.MboValueFactory;
import java.rmi.RemoteException;
import psdi.mbo.MAXTableDomain;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.MboValue;
import psdi.mbo.MboValueAdapter;
import psdi.util.MXApplicationException;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

public class FldApp
extends MAXTableDomain {
    private static MXLogger logger = NotifyConstants.INFORMER_LOGGER;

    public FldApp(MboValue mbv) {
        super(mbv);
        try {
            License l = LicenseManager.INSTANCE.getLicense();
            if (l == null) {
                this.setRelationship("maxapps", "1!=1");
            } else if (l.isForDevelopment()) {
                this.setRelationship("maxapps", "app = :app");
            } else if (l.getApplications() != null && l.getApplications().size() > 0) {
                this.setRelationship("maxapps", "app = :app and app in (" + l.getApplicationList() + ")");
                this.setListCriteria("app in (" + l.getApplicationList() + ")");
            } else {
                this.setRelationship("maxapps", "app = :app");
            }
        }
        catch (RemoteException e) {
            logger.error((Object)e);
            this.setRelationship("maxapps", "1!=1");
        }
        catch (MXException e) {
            logger.error((Object)e);
            this.setRelationship("maxapps", "1!=1");
        }
        String[] target = new String[]{"app", "objectname"};
        String[] source = new String[]{"app", "maintbname"};
        this.setKeyMap("maxapp", target, source);
    }

    public boolean hasList() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void action() throws RemoteException, MXException {
        MboSetRemote objectSet;
        block12: {
            super.action();
            objectSet = null;
            try {
                MboSetRemote notifyUserSet;
                if (!MboValueFactory.getMboValue((MboValueAdapter)this).isNull()) {
                    MboRemote app = MboValueFactory.getMboValue((MboValueAdapter)this).getMbo().getMboSet("MAXAPPS").getMbo(0);
                    String tbname = app.getString("MAINTBNAME");
                    objectSet = MXServerFactory.getMXServer().getMboSet("MAXOBJECT", this.getMboValue().getMbo().getUserInfo());
                    objectSet.setWhere("entityname = '" + tbname + "' and mainobject = 1");
                    if (objectSet.isEmpty()) {
                        Object[] args = new String[]{this.getMboValue().getString()};
                        throw new MXApplicationException("informer", "mainObjectNotFount", args);
                    }
                    String objectName = objectSet.getMbo(0).getString("OBJECTNAME");
                    MboSetRemote notifyObjectSet = this.getMboValue().getMbo().getMboSet("NOTIFYOBJECT");
                    if (!notifyObjectSet.isEmpty()) {
                        notifyObjectSet.deleteAndRemoveAll(3L);
                    }
                    MboRemote notifyObject = notifyObjectSet.add();
                    notifyObject.setValue("ISMAIN", true, 3L);
                    notifyObject.setValue("OBJECTNAME", objectName, 3L);
                    if (!this.getMboValue().isModified()) break block12;
                    this.getMboValue("PROCESSNAME").setValueNull();
                    this.getMboValue("CLAUSENAME").setValueNull();
                    MboSetRemote notifyUserSet2 = this.getMboValue().getMbo().getInstanciatedMboSet("NOTIFYUSER");
                    if (notifyUserSet2 == null) {
                        notifyUserSet2 = this.getMboValue().getMbo().getMboSet("NOTIFYUSER");
                    }
                    MboSetRemote userSet = null;
                    try {
                        userSet = MXServerFactory.getMXServer().getMboSet("MAXUSER", this.getMboValue().getMbo().getUserInfo());
                        MboRemote mbo = notifyUserSet2.moveFirst();
                        while (mbo != null) {
                            userSet.reset();
                            userSet.setWhere("'" + mbo.getString("USERID") + "' in (select userid from groupuser where groupname in (select groupname from APPLICATIONAUTH where app = '" + this.getMboValue().getString() + "' and optionname = 'READ'))");
                            if (userSet.isEmpty()) {
                                mbo.delete(2L);
                            }
                            mbo = notifyUserSet2.moveNext();
                        }
                    }
                    catch (Throwable throwable) {
                        NotifyUtil.closeAndCleanup(userSet);
                        throw throwable;
                    }
                    NotifyUtil.closeAndCleanup(userSet);
                    break block12;
                }
                MboSetRemote notifyObjectSet = this.getMboValue().getMbo().getMboSet("NOTIFYOBJECT");
                if (!notifyObjectSet.isEmpty()) {
                    notifyObjectSet.deleteAll(2L);
                }
                if (!(notifyUserSet = this.getMboValue().getMbo().getMboSet("NOTIFYUSER")).isEmpty()) {
                    notifyUserSet.deleteAll(2L);
                }
            }
            catch (Throwable throwable) {
                NotifyUtil.closeAndCleanup(objectSet);
                throw throwable;
            }
        }
        NotifyUtil.closeAndCleanup(objectSet);
    }
}

