/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.Device;
import com.interlocsolutions.maximo.notify.DeviceLicenseTransactable;
import com.interlocsolutions.maximo.notify.DeviceSetRemote;
import com.interlocsolutions.maximo.notify.security.SessionInfo;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.util.PropUtils;
import java.rmi.RemoteException;
import java.util.ArrayList;
import psdi.mbo.Mbo;
import psdi.mbo.MboRemote;
import psdi.mbo.MboServerInterface;
import psdi.mbo.MboSet;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.server.MXServer;
import psdi.txn.Transactable;
import psdi.util.MXException;

public class DeviceSet
extends MboSet
implements DeviceSetRemote {
    private static final long serialVersionUID = 6726457891832566298L;

    public DeviceSet(MboServerInterface ms) throws RemoteException {
        super(ms);
    }

    public void saveMbos() throws MXException, RemoteException {
        this.getMXTransaction().add((Transactable)new DeviceLicenseTransactable(this));
        super.saveMbos();
    }

    protected Mbo getMboInstance(MboSet ms) throws MXException, RemoteException {
        return new Device(ms);
    }

    @Override
    public long addDevice(SessionInfo session) throws RemoteException, MXException {
        SqlFormat sqlf = new SqlFormat("serialnum = :1");
        sqlf.setObject(1, "ISDEVICE", "SERIALNUM", session.getDeviceSerialNumber());
        this.setWhere(sqlf.format());
        this.reset();
        MboRemote device = null;
        if (this.isEmpty()) {
            device = this.add();
            device.setValue("SERIALNUM", session.getDeviceSerialNumber());
        } else {
            device = this.getMbo(0);
            if (!device.getBoolean("ACTIVE")) {
                device.setValue("ACTIVE", true);
            }
        }
        device.setValue("NAME", session.getDeviceName());
        device.setValue("OS", session.getDeviceOS());
        return device.getUniqueIDValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MboRemote getDeviceForIdentifiers(String deviceSerialNumber, String deviceName, String lastUserId) throws RemoteException, MXException {
        MboSetRemote searchMboSet;
        long deviceUniqueId;
        block32: {
            deviceUniqueId = -1L;
            searchMboSet = null;
            try {
                searchMboSet = MXServer.getMXServer().getMboSet("ISDEVICE", this.getUserInfo());
                SqlFormat sqlf = new SqlFormat("serialnum = :1");
                sqlf.setObject(1, "ISDEVICE", "SERIALNUM", deviceSerialNumber);
                searchMboSet.setWhere(sqlf.format());
                searchMboSet.setOrderBy("active desc, deviceid asc");
                searchMboSet.reset();
                if (!searchMboSet.isEmpty()) {
                    if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                        int matchingCount = searchMboSet.count();
                        NotifyConstants.INFORMER_LOGGER.debug((Object)("Found " + matchingCount + " device(s) for serial number " + deviceSerialNumber));
                    }
                    deviceUniqueId = searchMboSet.getMbo(0).getUniqueIDValue();
                    break block32;
                }
                if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                    NotifyConstants.INFORMER_LOGGER.debug((Object)("No devices found for serial number " + deviceSerialNumber + " checking if updating serial numbers is enabled."));
                }
                if (PropUtils.getBooleanMaxProp("informer.update.serialnum.off", true)) break block32;
                if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                    NotifyConstants.INFORMER_LOGGER.debug((Object)("No devices found for serial number " + deviceSerialNumber + ". Attempting to find based on device name " + deviceName + " and last user " + lastUserId));
                }
                ArrayList<Long> activeCandidateDeviceUniqueIds = new ArrayList<Long>();
                ArrayList<Long> inactiveCandidateDeviceUniqueIds = new ArrayList<Long>();
                sqlf = new SqlFormat("name = :1");
                sqlf.setObject(1, "ISDEVICE", "NAME", deviceName);
                searchMboSet.setWhere(sqlf.format());
                searchMboSet.reset();
                if (searchMboSet.isEmpty()) break block32;
                if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                    int matchingCount = searchMboSet.count();
                    NotifyConstants.INFORMER_LOGGER.debug((Object)("Found " + matchingCount + " device(s) with device name " + deviceName));
                }
                MboRemote searchDeviceMbo = null;
                while ((searchDeviceMbo = searchMboSet.getMbo(0)) != null) {
                    if (lastUserId.equalsIgnoreCase(searchDeviceMbo.getString("DEVICEUSER.USERID"))) {
                        long searchDeviceUniqueIdValue = searchDeviceMbo.getUniqueIDValue();
                        if (searchDeviceMbo.getBoolean("ACTIVE")) {
                            activeCandidateDeviceUniqueIds.add(searchDeviceUniqueIdValue);
                            if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                                NotifyConstants.INFORMER_LOGGER.debug((Object)("ACTIVE device with id " + searchDeviceUniqueIdValue + " matches device name " + deviceName + " and last user " + lastUserId));
                            }
                        } else {
                            inactiveCandidateDeviceUniqueIds.add(searchDeviceUniqueIdValue);
                            if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                                NotifyConstants.INFORMER_LOGGER.debug((Object)("INACTIVE device with id " + searchDeviceUniqueIdValue + " matches device name " + deviceName + " and last user " + lastUserId));
                            }
                        }
                    }
                    searchMboSet.remove(0);
                }
                searchMboSet.reset();
                if (activeCandidateDeviceUniqueIds.size() > 0) {
                    if (activeCandidateDeviceUniqueIds.size() == 1) {
                        deviceUniqueId = (Long)activeCandidateDeviceUniqueIds.get(0);
                        if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                            NotifyConstants.INFORMER_LOGGER.debug((Object)("There is one ACTIVE device for device name " + deviceName + " and last user " + lastUserId));
                        }
                    } else if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                        NotifyConstants.INFORMER_LOGGER.debug((Object)(activeCandidateDeviceUniqueIds.size() + " ACTIVE devices were found for device name " + deviceName + " and last user " + lastUserId + ".  Unable to determine a unique existing device to match."));
                    }
                } else if (inactiveCandidateDeviceUniqueIds.size() > 0) {
                    if (inactiveCandidateDeviceUniqueIds.size() == 1) {
                        deviceUniqueId = (Long)inactiveCandidateDeviceUniqueIds.get(0);
                        if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                            NotifyConstants.INFORMER_LOGGER.debug((Object)("There is one INACTIVE device for device name " + deviceName + " and last user " + lastUserId));
                        }
                    } else if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                        NotifyConstants.INFORMER_LOGGER.debug((Object)("0 active and " + inactiveCandidateDeviceUniqueIds.size() + " INACTIVE devices were found for device name " + deviceName + " and last user " + lastUserId + ".  Unable to determine a unique existing device to match."));
                    }
                } else if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                    NotifyConstants.INFORMER_LOGGER.debug((Object)("No devices were found for device name " + deviceName + " and last user " + lastUserId));
                }
                if (deviceUniqueId < 0L) break block32;
                searchMboSet.reset();
                MboRemote device = searchMboSet.getMboForUniqueId(deviceUniqueId);
                if (device != null) {
                    String previousSerialNumber = device.getString("SERIALNUM");
                    device.setValue("SERIALNUM", deviceSerialNumber);
                    if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                        NotifyConstants.INFORMER_LOGGER.debug((Object)("Updated serial number from " + previousSerialNumber + " to " + deviceSerialNumber + " for device with id " + deviceUniqueId));
                    }
                    searchMboSet.save(2L);
                    searchMboSet.reset();
                }
            }
            catch (Throwable throwable) {
                NotifyUtil.close(searchMboSet);
                throw throwable;
            }
        }
        NotifyUtil.close(searchMboSet);
        if (deviceUniqueId != -1L) {
            if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
                NotifyConstants.INFORMER_LOGGER.debug((Object)("Returning device with id " + deviceUniqueId + " for serial number " + deviceSerialNumber + ", device name " + deviceName + ", last user " + lastUserId));
            }
        } else if (NotifyConstants.INFORMER_LOGGER.isDebugEnabled()) {
            NotifyConstants.INFORMER_LOGGER.debug((Object)("No unique device was found for serial number " + deviceSerialNumber + ", device name " + deviceName + ", last user " + lastUserId));
        }
        this.reset();
        return this.getMboForUniqueId(deviceUniqueId);
    }
}

