/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.DeleteTransactable;
import com.interlocsolutions.maximo.notify.DeviceDeleteTransactable;
import com.interlocsolutions.maximo.notify.DeviceRemote;
import com.interlocsolutions.maximo.notify.push.PushQueueManager;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.util.StringUtils;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import psdi.mbo.Mbo;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSet;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.mbo.StatefulMboRemote;
import psdi.server.MXServer;
import psdi.txn.Transactable;
import psdi.util.MXException;

public class Device
extends Mbo
implements DeviceRemote {
    private static final long serialVersionUID = 2633148075507511911L;
    private List<String> cachedProfileList;

    public Device(MboSet ms) throws RemoteException {
        super(ms);
    }

    public void init() throws MXException {
        super.init();
        try {
            if (this.isNull("LOGLEVEL")) {
                this.setValue("LOGLEVEL", "INFO");
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws RemoteException, MXException {
        String keephistory;
        String createAsset;
        MboRemote pushDevice;
        MboSetRemote pushDeviceSet;
        MboSetRemote sessionSet;
        if (this.toBeDeleted()) {
            MboSetRemote assetSet;
            block41: {
                this.undelete();
                this.getMXTransaction().add((Transactable)new DeviceDeleteTransactable(this));
                MboRemote owner = this.getOwner();
                if (owner != null && owner.isBasedOn("ISNOTIFY")) {
                    String profileName = owner.getString("NOTIFYNUM");
                    this.profileListRemove(profileName);
                }
                if (this.cachedProfileList == null) {
                    this.cachedProfileList = !this.isNull("PROFILES") ? StringUtils.splitListByDelimiter(this.getString("PROFILES"), "\\|") : new ArrayList<String>(3);
                }
                this.setValue("ACTIVE", !this.cachedProfileList.isEmpty(), 2L);
                this.setValue("BLOCKED", false, 2L);
                this.setValue("WIPE", false, 2L);
                MboSetRemote sessionSet2 = this.getMboSet("$issession", "ISSESSION", "deviceid = :deviceid");
                sessionSet2.deleteAll();
                MboSetRemote catalogDeviceSet = this.getMboSet("$iscatalogdevice", "ISCATALOGDEVICE", "devicekey = :deviceid");
                catalogDeviceSet.deleteAll();
                MboSetRemote pushDeviceSet2 = this.getMboSet("$ispushdevice", "ISPUSHDEVICE", "deviceuid = :deviceid");
                pushDeviceSet2.deleteAll();
                MboSetRemote deviceLogSet = this.getMboSet("$isdevicelog", "ISDEVICELOG", "deviceid = :deviceid");
                deviceLogSet.deleteAll();
                DeleteTransactable.resetDeleteAll(this.getMboSet("DEVICEINSTRUMENTHISTORY"), 0L);
                DeleteTransactable.resetDeleteAll(this.getMboSet("DEVICEATTRIBUTE"), 0L);
                assetSet = null;
                try {
                    SqlFormat sqlf = new SqlFormat("assetuid = :1");
                    sqlf.setLong(1, this.getLong("ASSETID"));
                    assetSet = MXServer.getMXServer().getMboSet("ASSET", this.getUserInfo());
                    assetSet.setWhere(sqlf.format());
                    assetSet.reset();
                    if (assetSet.isEmpty()) break block41;
                    StatefulMboRemote asset = (StatefulMboRemote)assetSet.getMbo(0);
                    try {
                        String decommissionedStatus = MXServer.getMXServer().getMaximoDD().getTranslator().toExternalDefaultValue("LOCASSETSTATUS", "DECOMMISSIONED", (MboRemote)asset);
                        asset.changeStatus(decommissionedStatus, MXServer.getMXServer().getDate(), null);
                        assetSet.save();
                    }
                    catch (Exception e) {
                        NotifyConstants.INFORMER_LOGGER.warn((Object)("Error decommissioning deleted device asset: " + e.getMessage()), (Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    NotifyUtil.closeAndCleanup(assetSet);
                    throw throwable;
                }
            }
            NotifyUtil.closeAndCleanup(assetSet);
        }
        if (this.getBoolean("WIPE")) {
            this.getMboSet("$iscatalogdevice", "ISCATALOGDEVICE", "devicekey = :deviceid").deleteAll();
            sessionSet = this.getMboSet("$issession", "ISSESSION", "deviceid = :deviceid");
            sessionSet.deleteAll();
            pushDeviceSet = this.getMboSet("$ispushdevice", "ISPUSHDEVICE", "deviceuid = :deviceid");
            if (!pushDeviceSet.isEmpty()) {
                pushDevice = pushDeviceSet.moveFirst();
                while (pushDevice != null) {
                    if (this.profileListContains(pushDevice.getString("PUSHREG.NOTIFY.NOTIFYNUM"))) {
                        PushQueueManager.getInstance().addQueuedItem(pushDevice.getUniqueIDValue(), PushQueueManager.PushType.WIPE);
                    }
                    pushDevice = pushDeviceSet.moveNext();
                }
            }
        }
        if (this.getBoolean("BLOCKED")) {
            sessionSet = this.getMboSet("$issession", "ISSESSION", "deviceid = :deviceid");
            sessionSet.deleteAll();
            pushDeviceSet = this.getMboSet("$ispushdevice", "ISPUSHDEVICE", "deviceuid = :deviceid");
            if (!pushDeviceSet.isEmpty()) {
                pushDevice = pushDeviceSet.moveFirst();
                while (pushDevice != null) {
                    if (this.profileListContains(pushDevice.getString("PUSHREG.NOTIFY.NOTIFYNUM"))) {
                        PushQueueManager.getInstance().addQueuedItem(pushDevice.getUniqueIDValue(), PushQueueManager.PushType.BLOCK);
                    }
                    pushDevice = pushDeviceSet.moveNext();
                }
            }
        }
        if (this.getMboValue("LOGLEVEL").isModified()) {
            this.setValue("LOGLEVELDATE", MXServer.getMXServer().getDate());
            this.setValue("LOGFETCHEDBYPOLL", false);
        }
        if ("true".equals(createAsset = MXServer.getMXServer().getProperty("informer.createasset")) || "1".equals(createAsset)) {
            MboSetRemote assetSet = null;
            try {
                String assetLoc = MXServer.getMXServer().getProperty("informer.createasset.loc");
                if (assetLoc != null && assetLoc.trim().length() > 0) {
                    String itemnum = MXServer.getMXServer().getProperty("informer.createasset.item");
                    String status = MXServer.getMXServer().getProperty("informer.createasset.status");
                    String site = MXServer.getMXServer().getProperty("informer.createasset.site");
                    assetSet = MXServer.getMXServer().getMboSet("ASSET", this.getUserInfo());
                    MboRemote newAsset = null;
                    if (this.isNull("ASSETID")) {
                        newAsset = assetSet.add();
                        newAsset.generateAutoKey();
                        if (newAsset.isNull("ASSETNUM")) {
                            NotifyConstants.INFORMER_LOGGER.error((Object)"Unable to create asset for device because an auto generated asset number could not be obtained.");
                        }
                        if (site != null && site.trim().length() > 0) {
                            newAsset.setValue("SITEID", site, 2L);
                        }
                        newAsset.setValue("LOCATION", assetLoc);
                        if (itemnum != null && itemnum.trim().length() > 0) {
                            newAsset.setValue("ITEMNUM", itemnum);
                        }
                    } else {
                        newAsset = assetSet.getMboForUniqueId(this.getLong("ASSETID"));
                    }
                    if (newAsset == null) {
                        newAsset = assetSet.add();
                        newAsset.generateAutoKey();
                        if (newAsset.isNull("ASSETNUM")) {
                            NotifyConstants.INFORMER_LOGGER.error((Object)"Unable to create asset for device because an auto generated asset number could not be obtained.");
                        }
                        if (site != null && site.trim().length() > 0) {
                            newAsset.setValue("SITEID", site, 2L);
                        }
                        newAsset.setValue("LOCATION", assetLoc);
                        if (itemnum != null && itemnum.trim().length() > 0) {
                            newAsset.setValue("ITEMNUM", itemnum);
                        }
                    }
                    newAsset.setValue("DESCRIPTION", this.getString("NAME"));
                    newAsset.setValue("SERIALNUM", this.getString("SERIALNUM"));
                    String operatingStatus = MXServer.getMXServer().getMaximoDD().getTranslator().toExternalDefaultValue("LOCASSETSTATUS", "OPERATING", newAsset);
                    newAsset.setValue("STATUS", status != null && !status.trim().isEmpty() ? status : operatingStatus, 2L);
                    if (this.getOwner() != null) {
                        SqlFormat sqlf = null;
                        sqlf = new SqlFormat("personid in (select personid from maxuser where userid in (select userid from issessionhistory where deviceid = :1))");
                        sqlf.setLong(1, this.getOwner().getUniqueIDValue());
                        MboSetRemote personSet = this.getMboSet("$person", "PERSON", sqlf.format());
                        MboRemote person = personSet.moveFirst();
                        while (person != null) {
                            MboRemote assetCust = newAsset.getMboSet("ASSETUSERCUST").add();
                            assetCust.setValue("PERSONID", person.getString("PERSONID"));
                            assetCust.setValue("ISUSER", true);
                            person = personSet.moveNext();
                        }
                        assetSet.save();
                        this.setValue("ASSETID", newAsset.getUniqueIDValue());
                    }
                } else {
                    NotifyConstants.INFORMER_LOGGER.error((Object)"No default location was specified for automatic asset creation.");
                }
            }
            catch (Throwable t) {
                NotifyConstants.INFORMER_LOGGER.error((Object)"An error occurred while attempting to automatically create an asset.", t);
            }
            finally {
                NotifyUtil.closeAndCleanup(assetSet);
            }
        }
        if (("1".equalsIgnoreCase(keephistory = MXServer.getMXServer().getProperty("informer.keepinstrumenthistory")) || "true".equalsIgnoreCase(keephistory)) && this.getMboValue("TIMESTAMPREADING").isModified()) {
            this.getMboSet("DEVICEINSTRUMENTHISTORY").add();
        }
        String populateLBSLocation = MXServer.getMXServer().getProperty("informer.lbs.populate");
        String laborcode = null;
        String orgid = null;
        try {
            laborcode = this.getString("DEVICEUSER.PERSON.LABOR.LABORCODE");
            orgid = this.getString("DEVICEUSER.PERSON.LABOR.ORGID");
        }
        catch (Throwable site) {
            // empty catch block
        }
        if (("1".equalsIgnoreCase(populateLBSLocation) || "true".equalsIgnoreCase(populateLBSLocation)) && laborcode != null) {
            MboSetRemote maxobjects;
            block43: {
                maxobjects = null;
                try {
                    maxobjects = MXServer.getMXServer().getMboSet("MAXOBJECT", MXServer.getMXServer().getSystemUserInfo());
                    maxobjects.setWhere("objectname = 'LBSLOCATION'");
                    maxobjects.reset();
                    if (maxobjects.isEmpty() || orgid == null || "".equals(orgid.trim()) || laborcode == null || "".equals(laborcode.trim())) break block43;
                    MboSetRemote lbsSet = this.getMboSet("$lbslocation", "LBSLOCATION", "key1 = '" + orgid + "' and key2 = '" + laborcode + "'");
                    MboRemote lbs = null;
                    lbs = lbsSet.isEmpty() ? lbsSet.add() : lbsSet.getMbo(0);
                    lbs.setValue("REFOBJECT", "LABOR");
                    lbs.setValue("KEY1", orgid);
                    lbs.setValue("KEY2", laborcode);
                    lbs.setValue("LONGITUDE", this.getDouble("LONGITUDE"));
                    lbs.setValue("LATITUDE", this.getDouble("LATITUDE"));
                    lbs.setValue("ALTITUDE", this.getDouble("ALTITUDE"));
                    lbs.setValue("LOCATIONACCURACY", this.getDouble("HACCURACY"));
                    lbs.setValue("ALTITUDEACCURACY", this.getDouble("VACCURACY"));
                    lbs.setValue("HEADING", this.getDouble("HEADING"));
                    lbs.setValue("SPEED", this.getDouble("SPEED"));
                    lbs.setValue("LASTUPDATE", this.getDate("TIMESTAMPREADING"));
                }
                catch (Throwable throwable) {
                    NotifyUtil.closeAndCleanup(maxobjects);
                    throw throwable;
                }
            }
            NotifyUtil.closeAndCleanup(maxobjects);
        }
        super.save();
    }

    @NotNull
    public List<String> getProfileList() throws RemoteException, MXException {
        if (this.cachedProfileList == null) {
            this.cachedProfileList = !this.isNull("PROFILES") ? StringUtils.splitListByDelimiter(this.getString("PROFILES"), "\\|") : new ArrayList<String>(3);
        }
        return this.cachedProfileList;
    }

    private void setProfileList(@NotNull List<String> profiles2) throws RemoteException, MXException {
        if (profiles2.isEmpty()) {
            this.setValueNull("PROFILES");
        } else {
            this.setValue("PROFILES", StringUtils.sortedConcat(profiles2, "|", "|", "|"));
        }
        this.cachedProfileList = profiles2;
    }

    public void writeProfileList() throws RemoteException, MXException {
        this.setProfileList(this.getProfileList());
    }

    @Override
    public boolean profileListContains(@NotNull String profileName) throws RemoteException, MXException {
        if (this.cachedProfileList == null) {
            this.cachedProfileList = !this.isNull("PROFILES") ? StringUtils.splitListByDelimiter(this.getString("PROFILES"), "\\|") : new ArrayList<String>(3);
        }
        return this.cachedProfileList.contains(profileName);
    }

    @Override
    public boolean profileListAdd(@NotNull String profileName) throws RemoteException, MXException {
        List<String> profiles2 = this.getProfileList();
        if (!profiles2.contains(profileName)) {
            profiles2.add(profileName);
            this.setProfileList(profiles2);
            return true;
        }
        return false;
    }

    @Override
    public boolean profileListRemove(@NotNull String profileName) throws RemoteException, MXException {
        List<String> profiles2 = this.getProfileList();
        if (profiles2.remove(profileName)) {
            this.setProfileList(profiles2);
            return true;
        }
        return false;
    }
}

