/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.Catalog;
import com.interlocsolutions.maximo.notify.DeleteTransactable;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalContext;
import com.interlocsolutions.maximo.notify.queue.catalog.JobConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.mbo.Mbo;
import psdi.mbo.MboRemote;
import psdi.mbo.SqlFormat;
import psdi.txn.MXTransaction;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/interlocsolutions/maximo/notify/CatalogDeleteTransactable;", "Lcom/interlocsolutions/maximo/notify/DeleteTransactable;", "Lcom/interlocsolutions/maximo/notify/Catalog;", "mbo", "(Lcom/interlocsolutions/maximo/notify/Catalog;)V", "notifyNum", "", "fireEventsAfterDBCommit", "", "p0", "Lpsdi/txn/MXTransaction;", "initializeDeleteRelatedMbos", "isinformer"})
public final class CatalogDeleteTransactable
extends DeleteTransactable<Catalog> {
    @NotNull
    private final String notifyNum;

    public CatalogDeleteTransactable(@NotNull Catalog mbo) {
        Intrinsics.checkNotNullParameter((Object)mbo, (String)"mbo");
        super((Mbo)mbo);
        MboRemote topNotify = mbo;
        while ((topNotify = topNotify.getOwner()) != null && !topNotify.isBasedOn("ISNOTIFY")) {
        }
        MboRemote mboRemote = topNotify;
        String string = mboRemote != null ? mboRemote.getString("NOTIFYNUM") : null;
        if (string == null) {
            String string2 = mbo.getMboSet("NOTIFY").getMbo(0).getString("NOTIFYNUM");
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"mbo.getMboSet(\"NOTIFY\").\u20260).getString(\"NOTIFYNUM\")");
        }
        this.notifyNum = string;
        if (!(this.notifyNum != null)) {
            String string3 = "Check failed.";
            throw new IllegalStateException(string3.toString());
        }
    }

    @Override
    protected void initializeDeleteRelatedMbos() {
        super.initializeDeleteRelatedMbos();
        this.addDeleteRelatedMbos("CATALOGDATA", 2L);
        this.addDeleteRelatedMbos("CATPRELOAD", 2L);
        this.addDeleteRelatedMbos("CATALOGDEVICE", 2L);
        this.addDeleteRelatedMbos("ISRETRIEVALTRACKING", "catalogid = :catalogid", 2L);
        this.addDeleteRelatedMbos("ISNOTIFYRESOURCE", "resourcetype = 'CATALOG' AND notifyid = :notifyid AND name = :catalog", 2L);
        this.addDeleteRelatedMbos("ISTRACKING", "catalogid = :catalogid", 2L);
        SqlFormat sf = new SqlFormat((MboRemote)this.getParentMbo(), "catalog = :catalog and notifynum = :1");
        sf.setObject(1, "ISSESSIONCATALOG", "NOTIFYNUM", this.notifyNum);
        String string = sf.format();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sf.format()");
        this.addDeleteRelatedMbos("ISSESSIONCATALOG", string, 2L);
    }

    @Override
    public void fireEventsAfterDBCommit(@Nullable MXTransaction p0) {
        super.fireEventsAfterDBCommit(p0);
        JobConfig.getJobDispatcher().cancelBefore(new EvalContext(null, null, null, 7, null), ((Catalog)this.getParentMbo()).getLong("CATALOGID"));
    }
}

