/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.CatalogRemote;
import com.interlocsolutions.maximo.notify.filter.AttributeFilterFactory;
import com.interlocsolutions.maximo.notify.filter.FilterConfig;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import java.rmi.RemoteException;
import psdi.mbo.Mbo;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSet;
import psdi.util.MXApplicationException;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

public class CatalogAttribute
extends Mbo {
    protected static final long serialVersionUID = 7514966417150556861L;
    private static MXLogger logger = NotifyConstants.INFORMER_LOGGER;

    public CatalogAttribute(MboSet ms) throws RemoteException {
        super(ms);
    }

    public void add() throws RemoteException, MXException {
        if (this.getOwner() != null && this.getOwner().getName().equalsIgnoreCase("ISCATALOG")) {
            if (this.getOwner().isNull("OBJECTNAME") || this.getOwner().isNull("CATALOG")) {
                throw new MXApplicationException("informer", "missingCatalogObject");
            }
        } else {
            Object[] args = new String[]{"Catalog Attribute"};
            throw new MXApplicationException("informer", "catalogRequired", args);
        }
        super.add();
        this.getOwner().setFieldFlag("OBJECTNAME", 7L, true);
        this.setValue("CATALOGID", this.getOwner().getUniqueIDValue());
        this.modify();
    }

    public void delete(long flag) throws RemoteException, MXException {
        super.delete(flag);
        this.modify();
    }

    public void initFieldFlagsOnMbo(String attrName) throws MXException {
        super.initFieldFlagsOnMbo(attrName);
        this.setFieldFlag("ATTRIBUTENAME", 128L, true);
        if (!this.toBeAdded()) {
            this.setFieldFlag("ATTRIBUTENAME", 7L, true);
        }
        try {
            Object o = FilterConfig.getInstance().getFilterFactory();
            if (!(o instanceof AttributeFilterFactory)) {
                this.setFieldFlag("INCATALOG", 7L, true);
                this.setFieldFlag("INFILTER", 7L, true);
            }
        }
        catch (RemoteException e) {
            throw new MXApplicationException("system", "remoteexception", (Throwable)e);
        }
    }

    public void modify() throws MXException, RemoteException {
        super.modify();
        MboRemote owner = this.getOwner();
        if (owner != null && owner instanceof CatalogRemote && owner.isBasedOn("ISCATALOG") && owner.getLong("CATALOGID") == this.getLong("CATALOGID")) {
            ((CatalogRemote)owner).modify();
        }
    }
}

