/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.CatalogDeleteTransactable;
import com.interlocsolutions.maximo.notify.CatalogRemote;
import com.interlocsolutions.maximo.notify.DeleteTransactable;
import com.interlocsolutions.maximo.notify.DeleteTransactableOwner;
import com.interlocsolutions.maximo.notify.NotifyRemote;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalContext;
import com.interlocsolutions.maximo.notify.queue.catalog.JobConfig;
import com.interlocsolutions.maximo.notify.queue.catalog.JobInit;
import com.interlocsolutions.maximo.notify.queue.catalog.JobPreload;
import com.interlocsolutions.maximo.notify.queue.catalog.JobReconcile;
import com.interlocsolutions.maximo.notify.util.MboSetIterator;
import com.interlocsolutions.maximo.notify.util.MboUtil;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.mbo.Mbo;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSet;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.security.UserInfo;
import psdi.server.MXServer;
import psdi.util.MXApplicationException;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

public class Catalog
extends Mbo
implements CatalogRemote,
DeleteTransactableOwner<CatalogDeleteTransactable> {
    private CatalogDeleteTransactable deleteTransactable;
    protected static final long serialVersionUID = -1566544333245158493L;
    public static final MXLogger LOGGER = NotifyConstants.INFORMER_LOGGER;
    private boolean doChildUpdating = true;

    public Catalog(MboSet ms) throws RemoteException {
        super(ms);
    }

    public void add() throws RemoteException, MXException {
        super.add();
        MboRemote owner = this.getOwner();
        if (!(owner != null && (owner instanceof MboRemote && owner.isBasedOn("ISNOTIFY") || owner.isBasedOn("ISCATALOG")))) {
            throw new MXApplicationException("informer", "catalogRequiresNotify");
        }
        MboRemote mboOwner = owner;
        if (mboOwner.isBasedOn("ISCATALOG")) {
            if (mboOwner.toBeAdded()) {
                throw new MXApplicationException("informer", "mustSaveBeforeMultiWhere");
            }
            if ("ISPROPERTIES".equals(mboOwner.getString("CATALOG"))) {
                throw new MXApplicationException("informer", "noPropMultiWhere");
            }
            this.setValue("NOTIFYID", mboOwner.getLong("NOTIFYID"));
            this.setValue("ISCHILD", true);
            this.setValue("PARENT", mboOwner.getString("CATALOG"));
            this.setValue("OBJECTNAME", mboOwner.getString("OBJECTNAME"));
            if (mboOwner.getBoolean("PRELOAD")) {
                this.setValue("PRELOAD", mboOwner.getBoolean("PRELOAD"));
                this.setValue("PAGESIZE", mboOwner.getInt("PAGESIZE"));
                this.setValue("PRELOADTHRESHOLD", mboOwner.getInt("PRELOADTHRESHOLD"));
            }
            this.setValue("DESCRIPTION", mboOwner.getString("DESCRIPTION"));
        } else if (mboOwner.isBasedOn("ISNOTIFY")) {
            if (mboOwner.getBoolean("ACTIVE")) {
                throw new MXApplicationException("informer", "cannotAddWhileActive");
            }
            this.setValue("NOTIFYID", mboOwner.getUniqueIDValue());
        }
        this.setValue("PRELOAD", true);
        this.setValue("PRELOADTHRESHOLD", 1000);
        this.setValue("PAGESIZE", 250);
        this.setValue("PARTITIONTYPE", PartitionType.UNPARTITIONED.toString());
        this.setValue("STRATEGY", Strategy.EVENT.toString());
        this.getOwner().setModified(true);
    }

    public void init() throws MXException {
        super.init();
        if (!this.toBeAdded()) {
            String[] readOnlyFields = new String[]{"CATALOG", "OBJECTNAME", "PREFIX"};
            super.setFieldFlag(readOnlyFields, 7L, true);
        } else {
            String[] requiredOnlyFields = new String[]{"CATALOG", "OBJECTNAME"};
            super.setFieldFlag(requiredOnlyFields, 128L, true);
        }
        try {
            boolean state = !this.isNull("PRELOAD") ? this.getBoolean("PRELOAD") : false;
            this.getMboValue("PAGESIZE").setFlag(7L, !state);
            this.getMboValue("PAGESIZE").setFlag(128L, state);
            this.getMboValue("PRELOADTHRESHOLD").setFlag(7L, !state);
            this.getMboValue("PRELOADTHRESHOLD").setFlag(128L, state);
            if (this.getString("PARTITIONTYPE").equals(PartitionType.UNPARTITIONED.toString())) {
                this.getMboValue("PARTITIONBYATTR").setFlag(7L, true);
                this.getMboValue("PARTITIONERCLASS").setFlag(7L, true);
            } else {
                this.getMboValue("PARTITIONBYATTR").setFlag(7L, false);
                this.getMboValue("PARTITIONERCLASS").setFlag(7L, false);
            }
            this.getMboValue("DISPATCH").setFlag(7L, this.getString("STRATEGY").equals(Strategy.EVENT.toString()));
        }
        catch (Exception e) {
            NotifyConstants.INFORMER_LOGGER.warn((Object)e);
        }
        try {
            if ("ISPROPERTIES".equals(this.getString("CATALOG"))) {
                this.getMboValue("DESCRIPTION").setFlag(7L, true);
                this.getMboValue("WHERECLAUSE").setFlag(7L, true);
                this.getMboValue("PARTITIONTYPE").setFlag(7L, true);
            }
            if (this.getOwner() != null && this.getOwner().isBasedOn("ISNOTIFY") && this.getOwner().getBoolean("ACTIVE")) {
                this.setFlag(7L, true);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void save() throws RemoteException, MXException {
        String strategy;
        String partitionType = this.getString("PARTITIONTYPE");
        if (partitionType == null || partitionType.isEmpty()) {
            Object[] args = new String[]{this.getString("CATALOG")};
            throw new MXApplicationException("informer", "partitionTypeNotSpecify", args);
        }
        String partitionByAttr = this.getString("PARTITIONBYATTR");
        String partitionerClass = this.getString("PARTITIONERCLASS");
        if ((partitionType.equals(PartitionType.PARTITIONED.toString()) || partitionType.equals(PartitionType.BOTH.toString())) && (partitionByAttr == null || partitionByAttr.isEmpty()) && (partitionerClass == null || partitionerClass.isEmpty())) {
            Object[] args = new String[]{this.getString("CATALOG")};
            throw new MXApplicationException("informer", "partitionNotSpecify", args);
        }
        if (partitionType.equals(PartitionType.UNPARTITIONED.toString())) {
            this.setValueNull("PARTITIONBYATTR", 2L);
            this.setValueNull("PARTITIONERCLASS", 2L);
        }
        if ((strategy = this.getString("STRATEGY")) == null || strategy.isEmpty()) {
            Object[] args = new String[]{this.getString("CATALOG")};
            throw new MXApplicationException("informer", "strategyNotSpecified", args);
        }
        if ("ISPROPERTIES".equals(this.getString("CATALOG")) && this.getBoolean("PRELOAD")) {
            this.setValueNull("PRELOADTHRESHOLD");
            this.setValueNull("PAGESIZE");
            this.setValue("PRELOAD", false);
        }
        super.save();
        if (this.isModified("INITIALIZED") && !this.getBoolean("INITIALIZED")) {
            MboSetRemote msr = this.getMboSet("$RESOURCES", "ISNOTIFYRESOURCE", "notifyid = :notifyid and resourcetype = 'DATABASE'");
            msr.deleteAll();
        }
    }

    private boolean requiresNewRevision() throws RemoteException, MXException {
        if (this.toBeAdded()) {
            return true;
        }
        if (this.getBoolean("NOTIFY.ACTIVE") || this.toBeDeleted()) {
            return false;
        }
        if (this.isModified("WHERECLAUSE")) {
            return true;
        }
        if (this.isModified("PARTITIONERCLASS")) {
            return true;
        }
        if (this.isModified("PARTITIONBYATTR")) {
            return true;
        }
        if (this.isModified("PARTITIONTYPE")) {
            return true;
        }
        return this.getMboSet("CATALOGATTRIBUTES").toBeSaved();
    }

    public void delete(long flag) throws RemoteException, MXException {
        MboSetRemote set;
        super.delete(flag);
        DeleteTransactable.onDelete(this);
        if (!this.getBoolean("ISCHILD")) {
            set = this.getMboSet("CATALOGATTRIBUTES");
            DeleteTransactable.resetDeleteAll(set, flag);
        }
        if (!this.getBoolean("ISCHILD")) {
            DeleteTransactable.resetDeleteAll(this.getMboSet("CATALOGLISTENER"), flag);
        }
        set = this.getMboSet("CHILDREN");
        DeleteTransactable.resetDeleteAll(set, flag);
        if (this.getOwner() != null) {
            this.getOwner().setModified(true);
        }
    }

    public void undelete() throws MXException, RemoteException {
        super.undelete();
        DeleteTransactable.onUndelete(this);
        this.getMboSet("CATALOGLISTENER").undeleteAll();
        this.getMboSet("CATALOGATTRIBUTES").undeleteAll();
        this.getMboSet("CHILDREN").undeleteAll();
    }

    @Override
    public String[] getAttributes() throws RemoteException, MXException {
        MboSetRemote attributeSet = this.getMboSet("CATALOGATTRIBUTES");
        ArrayList<String> attributes = new ArrayList<String>();
        MboSetIterator attrSetItr = new MboSetIterator(attributeSet);
        MboRemote mbo = attrSetItr.moveFirst();
        while (mbo != null) {
            if (mbo.getBoolean("INCATALOG")) {
                attributes.add(mbo.getString("ATTRIBUTENAME"));
            }
            mbo = attrSetItr.moveNext();
        }
        return attributes.toArray(new String[attributes.size()]);
    }

    @Override
    public String[] getFilterAttributes() throws RemoteException, MXException {
        MboSetRemote attributeSet = this.getMboSet("CATALOGATTRIBUTES");
        ArrayList<String> attributes = new ArrayList<String>();
        MboSetIterator attrSetItr = new MboSetIterator(attributeSet);
        MboRemote mbo = attrSetItr.moveFirst();
        while (mbo != null) {
            if (mbo.getBoolean("INFILTER")) {
                attributes.add(mbo.getString("ATTRIBUTENAME"));
            }
            mbo = attrSetItr.moveNext();
        }
        return attributes.toArray(new String[attributes.size()]);
    }

    @Override
    public void initCatalog() throws RemoteException, MXException {
        this.initCatalog(new EvalContext());
    }

    @Override
    public void initCatalog(@NotNull EvalContext evalContext) throws RemoteException, MXException {
        if (this.getThisMboSet().toBeSaved()) {
            throw new MXApplicationException("informer", "mustSaveProfileBeforeUse");
        }
        UserInfo userInfo = MXServer.getMXServer().getSystemUserInfo();
        long catalogId = this.getUniqueIDValue();
        final long[] revisionArr = new long[1];
        MboUtil.visitSingleMbo(userInfo, "ISCATALOG", catalogId, new NotifyUtil.MboVisitor(){

            @Override
            public void visit(@NotNull MboRemote remote) throws RemoteException, MXException {
                revisionArr[0] = ((Catalog)remote).incrementRevisionNumber();
            }
        });
        long newRevision = revisionArr[0];
        JobConfig.getJobDispatcher().cancelBefore(evalContext.duplicate(), catalogId, newRevision);
        JobConfig.getJobDispatcher().doInit(evalContext.duplicate(), new JobInit.JobSpecInit(-1L, catalogId, newRevision));
        MboSetIterator children = new MboSetIterator(this.getMboSet("CHILDREN"));
        MboRemote child = children.moveFirst();
        while (child != null) {
            ((CatalogRemote)child).initCatalog(evalContext);
            child = children.moveNext();
        }
        try {
            SqlFormat sqlf = new SqlFormat("catalogid = :1 AND revision < :2");
            sqlf.setLong(1, catalogId);
            sqlf.setLong(2, newRevision);
            MboUtil.visitMbosWithRetry(userInfo, "ISCATALOGDEVICE", sqlf.format(), (NotifyUtil.MboVisitor)new MboUtil.MboDeleter(0L), 3);
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Failed to clear all invalidated device registrations before starting a new initialization of Catalog " + this.getString("CATALOG")));
        }
    }

    @Override
    public void preload() throws RemoteException, MXException {
        this.preload(new EvalContext());
    }

    @Override
    public void preload(@NotNull EvalContext evalContext) throws RemoteException, MXException {
        if (this.getBoolean("PRELOAD")) {
            JobConfig.getJobDispatcher().doPreload(evalContext, new JobPreload.JobSpecPreload(this.getLong("CATALOGID"), this.getLong("REVISION")));
            MboSetRemote children = this.getMboSet("CHILDREN");
            MboRemote child = children.moveFirst();
            while (child != null) {
                ((CatalogRemote)child).preload(evalContext);
                child = children.moveNext();
            }
        }
    }

    @Override
    public void reload() throws RemoteException, MXException {
        this.reload(new EvalContext());
    }

    @Override
    public void reload(@NotNull EvalContext evalContext) throws RemoteException, MXException {
        JobConfig.getJobDispatcher().doReconciliation(evalContext, new JobReconcile.JobSpecReconcile(this.getLong("CATALOGID"), this.getLong("REVISION")));
        MboSetRemote children = this.getMboSet("CHILDREN");
        MboRemote child = children.moveFirst();
        while (child != null) {
            ((CatalogRemote)child).reload(evalContext);
            child = children.moveNext();
        }
    }

    @Override
    public void modify() throws MXException, RemoteException {
        super.modify();
        MboRemote owner = this.getOwner();
        if (owner != null) {
            if (owner.isBasedOn("ISCATALOG") && owner.getString("CATALOG").equals(this.getString("PARENT"))) {
                ((CatalogRemote)owner).modify();
            } else if (owner.isBasedOn("ISNOTIFY") && owner.getLong("NOTIFYID") == this.getLong("NOTIFYID")) {
                ((NotifyRemote)owner).modify();
            }
        }
        if (this.requiresNewRevision()) {
            this.incrementRevisionNumber();
        }
        if (this.doChildUpdating) {
            MboRemote child;
            MboSetIterator childItr = new MboSetIterator(this.getMboSet("CHILDREN"));
            if (this.getMboValue("PRELOAD").isModified()) {
                child = childItr.moveFirst();
                while (child != null) {
                    child.setValue("PRELOAD", this.getBoolean("PRELOAD"));
                    child = childItr.moveNext();
                }
            }
            if (this.getMboValue("PAGESIZE").isModified()) {
                child = childItr.moveFirst();
                while (child != null) {
                    child.setValue("PAGESIZE", this.getLong("PAGESIZE"));
                    child = childItr.moveNext();
                }
            }
            if (this.getMboValue("PRELOADTHRESHOLD").isModified()) {
                child = childItr.moveFirst();
                while (child != null) {
                    child.setValue("PRELOADTHRESHOLD", this.getLong("PRELOADTHRESHOLD"));
                    child = childItr.moveNext();
                }
            }
        }
    }

    public long incrementRevisionNumber() throws MXException, RemoteException {
        Object oldRev = this.getDatabaseValue("REVISION");
        long lastSavedRevision = oldRev == null ? 0L : Long.valueOf(oldRev.toString());
        long newRevision = lastSavedRevision + 1L;
        this.setValue("REVISION", newRevision, 2L);
        this.setValue("INITIALIZED", false, 2L);
        this.getMboSet("CATALOGDEVICE").deleteAll();
        return newRevision;
    }

    public void childUpdating(boolean doUpdate) {
        this.doChildUpdating = doUpdate;
    }

    @Override
    public boolean isEventStrategy() throws MXException, RemoteException {
        return Strategy.valueOf(this.getMboValue("STRATEGY").getString()).equals((Object)Strategy.EVENT);
    }

    @Override
    public void setDeleteTransactable(@Nullable CatalogDeleteTransactable transactable) {
        this.deleteTransactable = transactable;
    }

    @Override
    @Nullable
    public CatalogDeleteTransactable getDeleteTransactable() {
        return this.deleteTransactable;
    }

    @Override
    @NotNull
    public CatalogDeleteTransactable newDeleteTransactable() {
        return new CatalogDeleteTransactable(this);
    }

    public static enum PartitionType {
        UNPARTITIONED,
        PARTITIONED,
        BOTH;

    }

    public static enum Strategy {
        EVENT,
        MONITORING;

    }
}

