/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify;

import com.interlocsolutions.maximo.notify.util.codec.Base64;
import java.rmi.RemoteException;
import java.text.NumberFormat;
import java.util.Locale;
import psdi.mbo.Mbo;
import psdi.mbo.MboSet;
import psdi.server.MXServer;
import psdi.util.MXException;

public class ApplicationDeploy
extends Mbo {
    private static final long serialVersionUID = 5469905100617513378L;

    public ApplicationDeploy(MboSet ms) throws RemoteException {
        super(ms);
    }

    public void add() throws MXException, RemoteException {
        super.add();
        if (this.getOwner() != null && this.getOwner().isBasedOn("ISNOTIFY")) {
            this.setValue("NOTIFYID", this.getOwner().getUniqueIDValue());
        }
    }

    public void save() throws MXException, RemoteException {
        if (!this.toBeDeleted()) {
            this.setValue("UPDATED", MXServer.getMXServer().getDate());
            if (!this.isNull("APPLICATION")) {
                long size = Base64.decodeBase64(this.getString("APPLICATION")).length;
                NumberFormat nf = NumberFormat.getInstance(Locale.US);
                nf.setMinimumFractionDigits(2);
                if (size > 1000000L) {
                    double mb = size / 1000000L;
                    this.setValue("FILESIZE", nf.format(mb) + " MB");
                } else {
                    double k = size / 1000L;
                    this.setValue("FILESIZE", nf.format(k) + " K");
                }
            }
        }
        super.save();
    }
}

