/*
 * Copyright (c) 2025.  Interloc Solutions Inc.  All rights reserved.
 * Unauthorized copying, modification, or distribution of this file, via
 * any medium is strictly prohibited.  Proprietary and confidential.
 *
 * File: pushqueue_sqlite.sql
 */

CREATE TABLE "ISPUSHQUEUE" (
    "ACTIVE"             INTEGER NOT NULL,
    "CATALOG"            TEXT,
    "ERRORCOUNT"         INTEGER,
    "ERRORMSG"           TEXT,
    "HOST"               TEXT,
    "INERROR"            INTEGER,
    "LANGCODE"           TEXT,
    "NODE"               TEXT,
    "NOTIFYNUM"          TEXT,
    "PARTITIONNAME"      TEXT,
    "PUSHDEVICEID"       INTEGER,
    "PUSHQUEUEID"        INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "PUSHTYPE"           TEXT,
    "THREADNAME"         TEXT,
    "TRACKINGID"         INTEGER,
    "TRIGGEROBJECT"      TEXT,
    "TRIGGEROBJECTID"    INTEGER
);

CREATE INDEX "ISPUSHQUEUE_NDX10" ON "ISPUSHQUEUE" ("INERROR","ACTIVE");
CREATE INDEX "ISPUSHQUEUE_NDX11" ON "ISPUSHQUEUE" ("PUSHTYPE","PUSHDEVICEID","ACTIVE");
CREATE INDEX "ISPUSHQUEUE_NDX12" ON "ISPUSHQUEUE" ("ACTIVE","HOST","NODE","THREADNAME","PUSHQUEUEID");
