/*
 * Copyright (c) 2025.  Interloc Solutions Inc.  All rights reserved.
 * Unauthorized copying, modification, or distribution of this file, via
 * any medium is strictly prohibited.  Proprietary and confidential.
 *
 * File: pushqueue_oracle.sql
 */

--------------------------------------------------------
--  DDL for Table ISPUSHQUEUE
--------------------------------------------------------

CREATE TABLE "ISPUSHQUEUE" (
    "ACTIVE"             NUMBER NOT NULL ENABLE,
    "CATALOG"            VARCHAR2(50 BYTE),
    "ERRORCOUNT"         NUMBER,
    "ERRORMSG"           CLOB,
    "HOST"               VARCHAR2(100 BYTE),
    "INERROR"            NUMBER,
    "LANGCODE"           VARCHAR2(4 BYTE),
    "NODE"               VARCHAR2(100 BYTE),
    "NOTIFYNUM"          VARCHAR2(20 BYTE),
    "PARTITIONNAME"      VARCHAR2(30 BYTE),
    "PUSHDEVICEID"       NUMBER,
    "PUSHQUEUEID"        NUMBER NOT NULL ENABLE CONSTRAINT ispushqueue_pk PRIMARY KEY,
    "PUSHTYPE"           VARCHAR2(50 BYTE),
    "THREADNAME"         VARCHAR2(100 BYTE),
    "TRACKINGID"         NUMBER,
    "TRIGGEROBJECT"      VARCHAR2(30 BYTE),
    "TRIGGEROBJECTID"    NUMBER
)
NOLOGGING NOCACHE NOCOMPRESS;

CREATE SEQUENCE "ISPUSHQUEUEID_SEQ";

-- DELIMITER \
CREATE OR REPLACE TRIGGER "ISPUSHQUEUEID_T"
BEFORE INSERT ON "ISPUSHQUEUE"
FOR EACH ROW
BEGIN
    SELECT "ISPUSHQUEUEID_SEQ".nextval
    INTO :new.pushqueueid
    FROM DUAL;
END ENABLE;
\
-- DELIMITER ;

CREATE INDEX "ISPUSHQUEUE_NDX10" ON "ISPUSHQUEUE" ("INERROR","ACTIVE");
CREATE INDEX "ISPUSHQUEUE_NDX11" ON "ISPUSHQUEUE" ("PUSHTYPE","PUSHDEVICEID","ACTIVE");
CREATE INDEX "ISPUSHQUEUE_NDX12" ON "ISPUSHQUEUE" ("ACTIVE","HOST","NODE","THREADNAME","PUSHQUEUEID");
