/*
 * Copyright (c) 2025.  Interloc Solutions Inc.  All rights reserved.
 * Unauthorized copying, modification, or distribution of this file, via
 * any medium is strictly prohibited.  Proprietary and confidential.
 *
 * File: notificationqueue_sqlite.sql
 */

--------------------------------------------------------
--  DDL FOR TABLE ISNOTIFYREFRESHQUEUE
--------------------------------------------------------

CREATE TABLE "ISNOTIFYREFRESHQUEUE" (
    "ACTIVE"                 INTEGER NOT NULL,
    "DATEADDED"              DATE DEFAULT ( datetime('now', 'localtime') ) NOT NULL,
    "ERRORCOUNT"             INTEGER,
    "HOST"                   TEXT,
    "INERROR"                INTEGER NOT NULL,
    "ISUSEREXPAND"           INTEGER NOT NULL,
    "ISUSERREFRESH"          INTEGER NOT NULL,
    "LASTERRORMSG"           TEXT,
    "LOCKED"                 INTEGER NOT NULL,
    "NODE"                   TEXT,
    "NOTIFYID"               INTEGER NOT NULL,
    "NOTIFYREFRESHQUEUID"    INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "PRIORITY"               INTEGER NOT NULL,
    "RECORDID"               INTEGER,
    "THREADNAME"             TEXT
);

CREATE INDEX "ISNOTIFYREFRESHQUEUE_NDX3" ON
    "ISNOTIFYREFRESHQUEUE"(
        "RECORDID",
        "ISUSERREFRESH"
    );

CREATE INDEX "ISNOTIFYREFRESHQUEUE_NDX5" ON
    "ISNOTIFYREFRESHQUEUE" (
        "ACTIVE",
        "ISUSEREXPAND",
        "ISUSERREFRESH",
        "NOTIFYID",
        "RECORDID",
        "HOST",
        "NODE",
        "THREADNAME"
    );

CREATE INDEX "ISNOTIFYREFRESHQUEUE_NDX6" ON
    "ISNOTIFYREFRESHQUEUE" (
        "ACTIVE",
        "HOST",
        "NODE",
        "THREADNAME",
        "NOTIFYID",
        "RECORDID"
    );

CREATE INDEX "ISNOTIFYREFRESHQUEUE_NDX8" ON
    "ISNOTIFYREFRESHQUEUE" (
        "NOTIFYID",
        "RECORDID"
    );
