/*
 * Copyright (c) 2025.  Interloc Solutions Inc.  All rights reserved.
 * Unauthorized copying, modification, or distribution of this file, via
 * any medium is strictly prohibited.  Proprietary and confidential.
 *
 * File: notificationqueue_oracle.sql
 */

--------------------------------------------------------
--  DDL FOR TABLE ISNOTIFYREFRESHQUEUE
--------------------------------------------------------

CREATE TABLE "ISNOTIFYREFRESHQUEUE" (
    "ACTIVE"                 NUMBER NOT NULL,
    "DATEADDED"              DATE DEFAULT (sysdate) NOT NULL,
    "ERRORCOUNT"             NUMBER,
    "HOST"                   VARCHAR2(100 BYTE),
    "INERROR"                NUMBER NOT NULL,
    "ISUSEREXPAND"           NUMBER NOT NULL,
    "ISUSERREFRESH"          NUMBER NOT NULL,
    "LASTERRORMSG"           CLOB,
    "LOCKED"                 NUMBER NOT NULL,
    "NODE"                   VARCHAR2(100 BYTE),
    "NOTIFYID"               NUMBER NOT NULL,
    "NOTIFYREFRESHQUEUID"    NUMBER NOT NULL CONSTRAINT isnotifyrefreshqueue_pk PRIMARY KEY,
    "PRIORITY"               NUMBER NOT NULL,
    "RECORDID"               NUMBER,
    "THREADNAME"             VARCHAR2(100 BYTE)
)
NOCOMPRESS NOLOGGING NOCACHE;

CREATE SEQUENCE "ISNOTIFYREFRESHQUEUID_SEQ";

-- DELIMITER \
CREATE OR REPLACE TRIGGER "ISNOTIFYREFRESHQUEUEID_T"
BEFORE INSERT ON "ISNOTIFYREFRESHQUEUE"
FOR EACH ROW
BEGIN
    SELECT "ISNOTIFYREFRESHQUEUID_SEQ".nextval
    INTO :new.notifyrefreshqueuid
    FROM DUAL;
END;
\
-- DELIMITER ;

ALTER TRIGGER "ISNOTIFYREFRESHQUEUEID_T" ENABLE;

CREATE INDEX "ISNOTIFYREFRESHQUEUE_NDX3" ON
    "ISNOTIFYREFRESHQUEUE" (
        "RECORDID",
        "ISUSERREFRESH"
    );

-- Already indexed by virtue of being the primary key
--CREATE UNIQUE INDEX "ISNOTIFYREFRESHQUEUE_NDX4" ON
--    "ISNOTIFYREFRESHQUEUE" (
--        "NOTIFYREFRESHQUEUID"
--    );

CREATE INDEX "ISNOTIFYREFRESHQUEUE_NDX5" ON
    "ISNOTIFYREFRESHQUEUE" (
        "ACTIVE",
        "ISUSEREXPAND",
        "ISUSERREFRESH",
        "NOTIFYID",
        "RECORDID",
        "HOST",
        "NODE",
        "THREADNAME"
    );

CREATE INDEX "ISNOTIFYREFRESHQUEUE_NDX6" ON
    "ISNOTIFYREFRESHQUEUE" (
        "ACTIVE",
        "HOST",
        "NODE",
        "THREADNAME",
        "NOTIFYID",
        "RECORDID"
    );

CREATE INDEX "ISNOTIFYREFRESHQUEUE_NDX8" ON
    "ISNOTIFYREFRESHQUEUE" (
        "NOTIFYID",
        "RECORDID"
    );
