/*
 * Copyright (c) 2025.  Interloc Solutions Inc.  All rights reserved.
 * Unauthorized copying, modification, or distribution of this file, via
 * any medium is strictly prohibited.  Proprietary and confidential.
 *
 * File: notificationqueue_db2.sql
 */

CREATE TABLE isnotifyrefreshqueue (
    active                 INTEGER NOT NULL,
    dateadded              TIMESTAMP NOT NULL WITH DEFAULT,
    errorcount             INTEGER,
    host                   VARCHAR(100),
    inerror                INTEGER NOT NULL,
    isuserexpand           INTEGER NOT NULL,
    isuserrefresh          INTEGER NOT NULL,
    lasterrormsg           CLOB,
    locked                 INTEGER NOT NULL,
    node                   VARCHAR(100),
    notifyid               INT,
    notifyrefreshqueuid    BIGINT NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1 INCREMENT BY 1) PRIMARY KEY,
    priority               INTEGER NOT NULL,
    recordid               BIGINT,
    threadname             VARCHAR(100)
);

CREATE INDEX isnotifyrefreshqueue_ndx3 ON
        isnotifyrefreshqueue (
        recordid,
        isuserrefresh
);

CREATE INDEX isnotifyrefreshqueue_ndx5 ON
        isnotifyrefreshqueue (
        active,
        isuserexpand,
        isuserrefresh,
        notifyid,
        recordid,
        host,
        node,
        threadname
);

CREATE INDEX isnotifyrefreshqueue_ndx6 ON
        isnotifyrefreshqueue (
        active,
        host,
        node,
        threadname,
        notifyid,
        recordid
);

CREATE INDEX isnotifyrefreshqueue_ndx8 ON
        isnotifyrefreshqueue (
        notifyid,
        recordid
);