/*
 * Copyright (c) 2025.  Interloc Solutions Inc.  All rights reserved.
 * Unauthorized copying, modification, or distribution of this file, via
 * any medium is strictly prohibited.  Proprietary and confidential.
 *
 * File: catalogqueue_sqlite.sql
 */

--NULL. The value is a NULL value.
--
--INTEGER. The value is a signed integer, stored in 1, 2, 3, 4, 6, or 8 bytes depending on the magnitude of the value.
--
--REAL. The value is a floating point value, stored as an 8-byte IEEE floating point number.
--
--TEXT. The value is a text string, stored using the database encoding (UTF-8, UTF-16BE or UTF-16LE).
--
--BLOB. The value is a blob of data, stored exactly as it was input.

CREATE TABLE "ISCATALOGJOBQUEUE" (
    "CATALOGID"              INTEGER NOT NULL,
    "DATEADDED"              DATE DEFAULT ( datetime('now', 'localtime') ) NOT NULL,
    "ERRORCOUNT"             INTEGER,
    "HOSTNAME"               TEXT,
    "ISCATALOGJOBQUEUEID"    INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "JOBSTATUS"              INTEGER NOT NULL,
    "JOBTYPE"                INTEGER NOT NULL,
    "LANGCODE"               TEXT,
    "LASTERRORMSG"           TEXT,
    "MXNAME"                 TEXT,
    "OBJECTNAME"             TEXT,
    "PARENT"                 INTEGER,
    "PRIORITY"               INTEGER NOT NULL,
    "PROCTYPE"               INTEGER NOT NULL,
    "RECORDID"               INTEGER,
    "REVISION"               INTEGER NOT NULL,
    "THREADNAME"             TEXT,
    "WHERECLAUSE"            TEXT
);

-- Already indexed by virtue of being the primary key
--CREATE UNIQUE INDEX "ISCATALOGJOBQUEUE_NDX1" ON
--    "ISCATALOGJOBQUEUE" (
--        "ISCATALOGJOBQUEUEID"
--    );

CREATE INDEX "ISCATALOGJOBQUEUE_NDX2" ON
    "ISCATALOGJOBQUEUE" (
        "PROCTYPE",
        "JOBSTATUS",
        "PRIORITY",
        "ISCATALOGJOBQUEUEID"
    );

CREATE INDEX "ISCATALOGJOBQUEUE_NDX3" ON
    "ISCATALOGJOBQUEUE" (
        "PROCTYPE",
        "JOBSTATUS",
        "ISCATALOGJOBQUEUEID"
    );

CREATE INDEX "ISCATALOGJOBQUEUE_NDX4" ON
    "ISCATALOGJOBQUEUE" (
        "CATALOGID",
        "REVISION",
        "JOBTYPE",
        "RECORDID",
        "LANGCODE",
        "JOBSTATUS"
    );

CREATE INDEX "ISCATALOGJOBQUEUE_NDX5" ON
    "ISCATALOGJOBQUEUE" (
        "HOSTNAME",
        "MXNAME",
        "THREADNAME",
        "JOBSTATUS"
    );
