/*
 * Copyright (c) 2025.  Interloc Solutions Inc.  All rights reserved.
 * Unauthorized copying, modification, or distribution of this file, via
 * any medium is strictly prohibited.  Proprietary and confidential.
 *
 * File: catalogqueue_postgresql.sql
 */

CREATE TABLE "iscatalogjobqueue"(
    "catalogid"              INT NOT NULL,
    "dateadded"              TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
    "errorcount"             INT,
    "hostname"               VARCHAR(50),
    "iscatalogjobqueueid"    SERIAL PRIMARY KEY,
    "jobstatus"              INTEGER NOT NULL,
    "jobtype"                INTEGER NOT NULL,
    "langcode"               VARCHAR(4),
    "lasterrormsg"           TEXT,
    "mxname"                 VARCHAR(50),
    "objectname"             VARCHAR(30),
    "parent"                 INT,
    "priority"               INTEGER NOT NULL,
    "proctype"               INTEGER NOT NULL,
    "recordid"               BIGINT,
    "revision"               INT NOT NULL,
    "threadname"             VARCHAR(100),
    "whereclause"            text
);

CREATE INDEX "iscatalogjobqueue_ndx1" ON
    "iscatalogjobqueue" (
    "proctype",
    "jobstatus",
    "priority",
    "iscatalogjobqueueid"
);

CREATE INDEX "iscatalogjobqueue_ndx2" ON
    "iscatalogjobqueue" (
    "proctype",
    "jobstatus",
    "iscatalogjobqueueid"
);

CREATE INDEX "iscatalogjobqueue_ndx3" ON
    "iscatalogjobqueue" (
    "catalogid",
    "revision",
    "jobtype",
    "recordid",
    "langcode",
    "jobstatus"
);

CREATE INDEX "iscatalogjobqueue_ndx4" ON
    "iscatalogjobqueue" (
    "hostname",
    "mxname",
    "threadname",
    "jobstatus"
);

CREATE INDEX "iscatalogjobqueue_ndx6" ON
    "iscatalogjobqueue" (
    "jobstatus",
    "priority",
    "iscatalogjobqueueid"
);
