/*
 * Copyright (c) 2025.  Interloc Solutions Inc.  All rights reserved.
 * Unauthorized copying, modification, or distribution of this file, via
 * any medium is strictly prohibited.  Proprietary and confidential.
 *
 * File: catalogqueue_oracle.sql
 */

--------------------------------------------------------
--  DDL for Table ISCATALOGJOBQUEUE
--------------------------------------------------------

CREATE TABLE "ISCATALOGJOBQUEUE" (
    "CATALOGID"              NUMBER NOT NULL ENABLE,
    "DATEADDED"              DATE DEFAULT (sysdate) NOT NULL,
    "ERRORCOUNT"             NUMBER,
    "HOSTNAME"               VARCHAR2(50 BYTE),
    "ISCATALOGJOBQUEUEID"    NUMBER NOT NULL ENABLE CONSTRAINT iscatalogjobqueue_pk PRIMARY KEY,
    "JOBSTATUS"              NUMBER NOT NULL ENABLE,
    "JOBTYPE"                NUMBER NOT NULL ENABLE,
    "LANGCODE"               VARCHAR2(4 BYTE),
    "LASTERRORMSG"           CLOB,
    "MXNAME"                 VARCHAR2(50 BYTE),
    "OBJECTNAME"             VARCHAR2(30 BYTE),
    "PARENT"                 NUMBER,
    "PRIORITY"               NUMBER NOT NULL ENABLE,
    "PROCTYPE"               NUMBER NOT NULL ENABLE,
    "RECORDID"               NUMBER,
    "REVISION"               NUMBER NOT NULL ENABLE,
    "THREADNAME"             VARCHAR2(100 BYTE),
    "WHERECLAUSE"            CLOB
)
NOCOMPRESS NOLOGGING NOCACHE;

CREATE SEQUENCE "ISCATALOGJOBQUEUEID_SEQ";

-- DELIMITER \
CREATE OR REPLACE TRIGGER "ISCATALOGJOBQUEUEID_T"
BEFORE INSERT ON "ISCATALOGJOBQUEUE"
FOR EACH ROW
BEGIN
    SELECT "ISCATALOGJOBQUEUEID_SEQ".nextval
    INTO :new.iscatalogjobqueueid
    FROM DUAL;
END ENABLE;
\
-- DELIMITER ;

ALTER TRIGGER "ISCATALOGJOBQUEUEID_T" ENABLE;

-- Already indexed by virtue of being the primary key
--CREATE UNIQUE INDEX "ISCATALOGJOBQUEUE_NDX1" ON
--    "ISCATALOGJOBQUEUE" (
--        "ISCATALOGJOBQUEUEID"
--    );

CREATE INDEX "ISCATALOGJOBQUEUE_NDX2" ON
    "ISCATALOGJOBQUEUE" (
        "PROCTYPE",
        "JOBSTATUS",
        "PRIORITY",
        "ISCATALOGJOBQUEUEID"
    );

CREATE INDEX "ISCATALOGJOBQUEUE_NDX3" ON
    "ISCATALOGJOBQUEUE" (
        "PROCTYPE",
        "JOBSTATUS",
        "ISCATALOGJOBQUEUEID"
    );

CREATE INDEX "ISCATALOGJOBQUEUE_NDX4" ON
    "ISCATALOGJOBQUEUE" (
        "CATALOGID",
        "REVISION",
        "JOBTYPE",
        "RECORDID",
        "LANGCODE",
        "JOBSTATUS"
    );

CREATE INDEX "ISCATALOGJOBQUEUE_NDX5" ON
    "ISCATALOGJOBQUEUE" (
        "HOSTNAME",
        "MXNAME",
        "THREADNAME",
        "JOBSTATUS"
    );

CREATE INDEX "ISCATALOGJOBQUEUE_NDX6" ON
    "ISCATALOGJOBQUEUE" (
        "JOBSTATUS",
        "PRIORITY",
        "ISCATALOGJOBQUEUEID"
    );
