/*
 * Copyright (c) 2025.  Interloc Solutions Inc.  All rights reserved.
 * Unauthorized copying, modification, or distribution of this file, via
 * any medium is strictly prohibited.  Proprietary and confidential.
 *
 * File: catalogqueue_mssql.sql
 */

CREATE TABLE "iscatalogjobqueue"(
    "catalogid"              INT NOT NULL,
    "dateadded"              DATETIME DEFAULT getdate() NOT NULL,
    "errorcount"             INT,
    "hostname"               VARCHAR(50),
    "iscatalogjobqueueid"    BIGINT NOT NULL IDENTITY,
    "jobstatus"              INTEGER NOT NULL,
    "jobtype"                INTEGER NOT NULL,
    "langcode"               VARCHAR(4),
    "lasterrormsg"           VARCHAR(max),
    "mxname"                 VARCHAR(50),
    "objectname"             VARCHAR(30),
    "parent"                 INT,
    "priority"               INTEGER NOT NULL,
    "proctype"               INTEGER NOT NULL,
    "recordid"               BIGINT,
    "revision"               INT NOT NULL,
    "threadname"             VARCHAR(100),
    "whereclause"            VARCHAR(max),
    CONSTRAINT "iscatalogjobqueue_ndx0" PRIMARY KEY CLUSTERED ("iscatalogjobqueueid" ASC)
    WITH (ALLOW_PAGE_LOCKS = OFF, ALLOW_ROW_LOCKS = ON)
);

CREATE INDEX "iscatalogjobqueue_ndx1" ON
    "iscatalogjobqueue" (
    "proctype",
    "jobstatus",
    "priority",
    "iscatalogjobqueueid"
) WITH (ALLOW_PAGE_LOCKS = OFF, ALLOW_ROW_LOCKS = ON);

CREATE INDEX "iscatalogjobqueue_ndx2" ON
    "iscatalogjobqueue" (
    "proctype",
    "jobstatus",
    "iscatalogjobqueueid"
) WITH (ALLOW_PAGE_LOCKS = OFF, ALLOW_ROW_LOCKS = ON);

CREATE INDEX "iscatalogjobqueue_ndx3" ON
    "iscatalogjobqueue" (
    "catalogid",
    "revision",
    "jobtype",
    "recordid",
    "langcode",
    "jobstatus"
) WITH (ALLOW_PAGE_LOCKS = OFF, ALLOW_ROW_LOCKS = ON);

CREATE INDEX "iscatalogjobqueue_ndx4" ON
    "iscatalogjobqueue" (
    "hostname",
    "mxname",
    "threadname",
    "jobstatus"
) WITH (ALLOW_PAGE_LOCKS = OFF, ALLOW_ROW_LOCKS = ON);

CREATE INDEX "iscatalogjobqueue_ndx6" ON
    "iscatalogjobqueue" (
    "jobstatus",
    "priority",
    "iscatalogjobqueueid"
) WITH (ALLOW_PAGE_LOCKS = OFF, ALLOW_ROW_LOCKS = ON);

CREATE INDEX "iscatalogjobqueue_mssql_ndx1" ON
    "iscatalogjobqueue" (
    "proctype",
    "jobstatus",
    "priority",
    "iscatalogjobqueueid",
    "hostname",
    "mxname",
    "threadname"
) WITH (ALLOW_PAGE_LOCKS = OFF, ALLOW_ROW_LOCKS = ON);

ALTER TABLE iscatalogjobqueue SET (LOCK_ESCALATION = DISABLE);
