
create TABLE iscatalogjobqueue(
    catalogid              INT NOT NULL,
    dateadded              TIMESTAMP NOT NULL with DEFAULT,
    errorcount             INT,
    hostname               VARCHAR(50),
    iscatalogjobqueueid    BIGINT NOT NULL GENERATED ALWAYS AS IDENTITY (START with 1 INCREMENT BY 1) PRIMARY KEY,
    jobstatus              INTEGER NOT NULL,
    jobtype                INTEGER NOT NULL,
    langcode               VARCHAR(4),
    lasterrormsg           CLOB,
    mxname                 VARCHAR(50),
    objectname             VARCHAR(30),
    parent                 INT,
    priority               INTEGER NOT NULL,
    proctype               INTEGER NOT NULL,
    recordid               BIGINT,
    revision               INT NOT NULL,
    threadname             VARCHAR(100),
    whereclause            CLOB
);
/*
 * Copyright (c) 2025.  Interloc Solutions Inc.  All rights reserved.
 * Unauthorized copying, modification, or distribution of this file, via
 * any medium is strictly prohibited.  Proprietary and confidential.
 *
 * File: catalogqueue_db2.sql
 */

-- Already indexed by virtue of being the primary key

create INDEX iscatalogjobqueue_ndx1 ON
    iscatalogjobqueue (
    proctype,
    jobstatus,
    priority,
    iscatalogjobqueueid
);

create INDEX iscatalogjobqueue_ndx2 ON
    iscatalogjobqueue (
    proctype,
    jobstatus,
    iscatalogjobqueueid
);

create INDEX iscatalogjobqueue_ndx3 ON
    iscatalogjobqueue (
    catalogid,
    revision,
    jobtype,
    recordid,
    langcode,
    jobstatus
);

create INDEX iscatalogjobqueue_ndx4 ON
    iscatalogjobqueue (
    hostname,
    mxname,
    threadname,
    jobstatus
);

create INDEX iscatalogjobqueue_ndx6 ON
    iscatalogjobqueue (
    jobstatus,
    priority,
    iscatalogjobqueueid
);
