/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.xml;

import com.interlocsolutions.maximo.notify.NotifyEvent;
import com.interlocsolutions.maximo.notify.util.ISO8601Formatter;
import java.util.Date;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="event", namespace="http://www.interlocsolutions.com/maximo/notify")
@XmlType(propOrder={"objectName", "recordId", "notificationId", "name", "updateDate", "active", "catalogId", "catalog", "catalogPartition", "sequence"}, namespace="http://www.interlocsolutions.com/maximo/notify")
public class NotificationEvent {
    private String objectName = null;
    private long recordId = -1L;
    private long notificationId = -1L;
    private String name = null;
    private boolean active = false;
    private String updateDate = null;
    private long catalogId = -1L;
    private String catalog = null;
    private String catalogPartition = null;
    private long sequence = -1L;
    private EVENT_TYPE eventType = EVENT_TYPE.NOTIFICATION;

    public NotificationEvent() {
    }

    public NotificationEvent(NotifyEvent event) {
        this.objectName = event.getObjectName();
        this.recordId = event.getRecordId();
        this.notificationId = event.getNotificationId();
        this.name = event.getNotificationName();
        if (event.getUpdateDate() != null) {
            this.updateDate = ISO8601Formatter.format(event.getUpdateDate());
        }
        this.active = event.isActive();
        this.eventType = event.getType();
        this.catalogId = event.getCatalogId();
        this.catalog = event.getCatalog();
        this.catalogPartition = event.getCatalogPartition();
        this.sequence = event.getSequence();
    }

    @XmlElement(name="objectname", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    @XmlElement(name="recordid", namespace="http://www.interlocsolutions.com/maximo/notify")
    public long getRecordId() {
        return this.recordId;
    }

    public void setRecordId(long recordId) {
        this.recordId = recordId;
    }

    @XmlElement(name="notificationid", namespace="http://www.interlocsolutions.com/maximo/notify")
    public long getNotificationId() {
        return this.notificationId;
    }

    public void setNotificationId(long notificationId) {
        this.notificationId = notificationId;
    }

    @XmlElement(name="notificationname", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement(name="active", namespace="http://www.interlocsolutions.com/maximo/notify")
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @XmlElement(name="updatedate", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(String updateDate) {
        this.updateDate = updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = ISO8601Formatter.format(updateDate);
    }

    @XmlAttribute(name="type", required=true)
    public EVENT_TYPE getEventType() {
        return this.eventType;
    }

    public void setEventType(EVENT_TYPE eventType) {
        this.eventType = eventType;
    }

    @XmlElement(name="catalogid", namespace="http://www.interlocsolutions.com/maximo/notify")
    public long getCatalogId() {
        return this.catalogId;
    }

    public void setCatalogId(long catalogId) {
        this.catalogId = catalogId;
    }

    @XmlElement(name="catalog", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    @XmlElement(name="catalogpartition", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getCatalogPartition() {
        return this.catalogPartition;
    }

    public void setCatalogPartition(String catalogPartition) {
        this.catalogPartition = catalogPartition;
    }

    @XmlElement(name="sequence", namespace="http://www.interlocsolutions.com/maximo/notify")
    public long getSequence() {
        return this.sequence;
    }

    public void setSequence(long sequence) {
        this.sequence = sequence;
    }

    public static enum EVENT_TYPE {
        NOTIFICATION,
        CATALOG,
        INSTRUMENTATION,
        LOG,
        SCREENSHOT,
        LOG_LEVEL;

    }
}

