/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.xml;

import com.interlocsolutions.maximo.notify.commands.Command;
import com.interlocsolutions.maximo.notify.util.ISO8601Formatter;
import com.interlocsolutions.maximo.notify.xml.NotificationContent;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="notification", namespace="http://www.interlocsolutions.com/maximo/notify")
@XmlType(propOrder={"content", "commands"}, namespace="http://www.interlocsolutions.com/maximo/notify")
public class Notification {
    private long notificationId;
    private String name;
    private NotificationContent content;
    private List<Command> commands = new LinkedList<Command>();
    private long sequence = 0L;
    private String lastUpdateDate = null;

    @XmlAttribute(name="lastupdate")
    public String getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public void setLastUpdateDate(String lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
    }

    public void setLastUpdateDate(Date lastUpdateDate) {
        this.lastUpdateDate = ISO8601Formatter.format(lastUpdateDate);
    }

    @XmlAttribute(name="sequence")
    public long getSequence() {
        return this.sequence;
    }

    public void setSequence(long sequence) {
        this.sequence = sequence;
    }

    @XmlAttribute(name="id", required=true)
    public long getNotificationId() {
        return this.notificationId;
    }

    public void setNotificationId(long notificationId) {
        this.notificationId = notificationId;
    }

    @XmlAttribute(name="name", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement(name="content", namespace="http://www.interlocsolutions.com/maximo/notify")
    public NotificationContent getContent() {
        return this.content;
    }

    public void setContent(NotificationContent content) {
        this.content = content;
    }

    @XmlElementWrapper(name="commands", namespace="http://www.interlocsolutions.com/maximo/notify")
    @XmlAnyElement
    public List<Command> getCommands() {
        return this.commands;
    }

    public void setCommands(List<Command> commands) {
        this.commands = commands;
    }

    public void addCommand(Command command) {
        if (this.commands == null) {
            this.commands = new LinkedList<Command>();
        }
        this.commands.add(command);
    }
}

