/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.xml;

import com.interlocsolutions.maximo.notify.util.ISO8601Formatter;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import java.text.ParseException;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="receipt", namespace="http://www.interlocsolutions.com/maximo/notify")
public class ConfirmPushReceipt {
    private long trackingId;
    private String receiptDate;

    public ConfirmPushReceipt() {
    }

    public ConfirmPushReceipt(long trackingId, Date receiptDate) {
        this.trackingId = trackingId;
        this.receiptDate = ISO8601Formatter.format(receiptDate);
    }

    public ConfirmPushReceipt(long trackingId, String receiptDate) {
        this.trackingId = trackingId;
        this.receiptDate = receiptDate;
    }

    @XmlElement(name="trackingId", namespace="http://www.interlocsolutions.com/maximo/notify")
    public long getTrackingId() {
        return this.trackingId;
    }

    public void setTrackingId(long trackingId) {
        this.trackingId = trackingId;
    }

    public Date getReceiptDateAsDate() {
        if (this.receiptDate != null) {
            try {
                return ISO8601Formatter.parse(this.receiptDate);
            }
            catch (ParseException e) {
                NotifyConstants.INFORMER_LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @XmlElement(name="receiptdate", namespace="http://www.interlocsolutions.com/maximo/notify")
    public String getReceiptDate() {
        return this.receiptDate;
    }

    public void setReceiptDate(String receiptDate) {
        this.receiptDate = receiptDate;
    }
}

