/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.xml;

import com.interlocsolutions.maximo.notify.xml.CatalogObject;
import com.interlocsolutions.maximo.notify.xml.CatalogSQLiteDatabase;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="catalog", namespace="http://www.interlocsolutions.com/maximo/notify")
@XmlType(propOrder={"objects", "database"}, namespace="http://www.interlocsolutions.com/maximo/notify")
public class CatalogObjects
implements Serializable {
    private static final long serialVersionUID = 3186893958150394452L;
    private long deviceId = -1L;
    private int position = -1;
    private int count = 0;
    private boolean hasMoreRecords = false;
    private String name = null;
    private String partition = null;
    private long sequence = -1L;
    private int pageNumber = -1;
    private List<CatalogObject> objects = new LinkedList<CatalogObject>();
    private CatalogSQLiteDatabase database = null;

    @XmlAttribute(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlAttribute(name="partition")
    public String getPartition() {
        return this.partition;
    }

    public void setPartition(String partition) {
        this.partition = partition;
    }

    @XmlAttribute(name="more")
    public boolean isHasMoreRecords() {
        return this.hasMoreRecords;
    }

    public void setHasMoreRecords(boolean hasMoreRecords) {
        this.hasMoreRecords = hasMoreRecords;
    }

    @XmlAttribute(name="count")
    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    @XmlAttribute(name="position")
    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    @XmlAttribute(name="deviceid")
    public long getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(long deviceId) {
        this.deviceId = deviceId;
    }

    @XmlElement(name="object", namespace="http://www.interlocsolutions.com/maximo/notify")
    public List<CatalogObject> getObjects() {
        return this.objects;
    }

    public void setObjects(List<CatalogObject> objects) {
        if (objects == null) {
            this.objects.clear();
        } else {
            this.objects = objects;
        }
    }

    public void addObject(CatalogObject object) {
        if (object != null) {
            if (object.getSeqeunce() > this.sequence) {
                this.sequence = object.getSeqeunce();
            }
            this.objects.add(object);
        }
    }

    @XmlAttribute(name="sequence")
    public long getSequence() {
        return this.sequence;
    }

    public void setSequence(long sequence) {
        this.sequence = sequence;
    }

    public long getEndSequence() {
        long highest = -1L;
        for (CatalogObject obj : this.objects) {
            long seqNum = obj.getSeqeunce();
            if (seqNum <= highest) continue;
            highest = seqNum;
        }
        return highest;
    }

    public long getStartSequence() {
        long lowest = -1L;
        for (CatalogObject obj : this.objects) {
            long seqNum = obj.getSeqeunce();
            if (seqNum >= lowest && lowest >= 0L) continue;
            lowest = seqNum;
        }
        return lowest;
    }

    @XmlAttribute(name="pagenumber")
    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public CatalogSQLiteDatabase getDatabase() {
        return this.database;
    }

    public void setDatabase(CatalogSQLiteDatabase database) {
        this.database = database;
    }
}

