/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.xml;

import com.interlocsolutions.maximo.notify.xml.CatalogAttribute;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jetbrains.annotations.NotNull;
import psdi.mbo.MboRemote;
import psdi.util.MXException;

@XmlRootElement(name="object", namespace="http://www.interlocsolutions.com/maximo/notify")
@XmlType(propOrder={"attributes"}, namespace="http://www.interlocsolutions.com/maximo/notify")
public class CatalogObject
implements Serializable {
    private static final long serialVersionUID = 8387116206610712412L;
    private List<CatalogAttribute> attributes = null;
    private boolean deleted = false;
    private long recordId = -1L;
    private long seqeunce = -1L;

    public CatalogObject() {
    }

    public CatalogObject(MboRemote object, String[] attributes, long sequence, String langCode) throws RemoteException, MXException {
        this.recordId = object.getUniqueIDValue();
        this.seqeunce = sequence;
        for (String attribute : attributes) {
            this.addAttribute(new CatalogAttribute(attribute, object, langCode));
        }
    }

    @NotNull
    public static CatalogObject create(@NotNull MboRemote object, @NotNull String[] attributes, String langCode) throws RemoteException, MXException {
        return new CatalogObject(object, attributes, 0L, langCode);
    }

    @NotNull
    public static CatalogObject existing(@NotNull MboRemote object, @NotNull String[] attributes, long sequence, String langCode) throws RemoteException, MXException {
        return new CatalogObject(object, attributes, sequence, langCode);
    }

    @NotNull
    public static CatalogObject deleted(long recordid, long sequence) {
        return new CatalogObject(recordid, true, sequence);
    }

    public CatalogObject(long recordId, boolean deleted, long sequence) {
        this.deleted = deleted;
        this.recordId = recordId;
        this.seqeunce = sequence;
    }

    @XmlElement(name="attribute", namespace="http://www.interlocsolutions.com/maximo/notify")
    public List<CatalogAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<CatalogAttribute> attributes) {
        this.attributes = attributes;
    }

    public void addAttribute(CatalogAttribute attribute) {
        if (this.attributes == null) {
            this.attributes = new LinkedList<CatalogAttribute>();
        }
        if (attribute.getValue() != null) {
            this.attributes.add(attribute);
        }
    }

    @XmlAttribute(name="deleted")
    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @XmlAttribute(name="recordid")
    public long getRecordId() {
        return this.recordId;
    }

    public void setRecordId(long recordId) {
        this.recordId = recordId;
    }

    @XmlAttribute(name="sequence")
    public long getSeqeunce() {
        return this.seqeunce;
    }

    public void setSeqeunce(long seqeunce) {
        this.seqeunce = seqeunce;
    }
}

