/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.virtual;

import com.interlocsolutions.maximo.notify.util.License;
import com.interlocsolutions.maximo.notify.util.LicenseManager;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import java.time.ZoneId;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.mbo.Mbo;
import psdi.mbo.MboRemote;
import psdi.mbo.MboServerInterface;
import psdi.mbo.MboSet;
import psdi.mbo.NonPersistentMbo;
import psdi.mbo.NonPersistentMboSet;
import psdi.util.MXException;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/interlocsolutions/maximo/notify/virtual/LicenseDetailSet;", "Lpsdi/mbo/NonPersistentMboSet;", "ms", "Lpsdi/mbo/MboServerInterface;", "(Lpsdi/mbo/MboServerInterface;)V", "getMboInstance", "Lpsdi/mbo/Mbo;", "p0", "Lpsdi/mbo/MboSet;", "setup", "Lpsdi/mbo/MboRemote;", "isinformer"})
public class LicenseDetailSet
extends NonPersistentMboSet {
    public LicenseDetailSet(@NotNull MboServerInterface ms) {
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        super(ms);
    }

    @NotNull
    protected Mbo getMboInstance(@Nullable MboSet p0) {
        MboSet mboSet = p0;
        Intrinsics.checkNotNull((Object)mboSet);
        return (Mbo)new NonPersistentMbo(mboSet);
    }

    @Nullable
    public MboRemote setup() {
        MboRemote mr;
        block5: {
            mr = super.setup();
            mr.setValue("INFVERSION", NotifyUtil.getVersion());
            try {
                License license = LicenseManager.INSTANCE.getLicense();
                if (license != null) {
                    mr.setValue("USERS", license.getUserCount());
                    mr.setValue("DEVICES", license.getDeviceCount());
                    mr.setValue("DEVELOPMENT", license.isForDevelopment());
                    mr.setValue("LICENSEE", license.getLicensee());
                    if (license.getExpDate() == null) {
                        mr.setValueNull("EXPIRATION");
                    } else {
                        mr.setValue("EXPIRATION", Date.from(license.getExpDateAsLocalDate().atStartOfDay(ZoneId.systemDefault()).toInstant()));
                    }
                    mr.setValue("APPLICATIONS", license.getApplicationList());
                    mr.setValue("LICVERSION", license.getVersion());
                }
            }
            catch (MXException e) {
                if (Intrinsics.areEqual((Object)e.getErrorGroup(), (Object)"informer") || Intrinsics.areEqual((Object)e.getErrorKey(), (Object)"missingLicense")) break block5;
                throw e;
            }
        }
        mr.setFlag(7L, true);
        String[] stringArray = new String[]{"USERS", "DEVICES", "DEVELOPMENT", "LICENSEE", "EXPIRATION", "APPLICATIONS", "LICVERSION", "INFVERSION"};
        mr.setFieldFlag(stringArray, 7L, true);
        return mr;
    }
}

