/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.virtual;

import com.interlocsolutions.maximo.notify.NotificationEventListenerManager;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalContext;
import com.interlocsolutions.maximo.notify.queue.catalog.EvalFlags;
import com.interlocsolutions.maximo.notify.queue.catalog.JobConfig;
import com.interlocsolutions.maximo.notify.queue.catalog.JobPartialReconcile;
import com.interlocsolutions.maximo.notify.queue.catalog.JobReconcile;
import com.interlocsolutions.maximo.notify.util.CachedCatalog;
import com.interlocsolutions.maximo.notify.virtual.CatalogReconcile;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import psdi.mbo.Mbo;
import psdi.mbo.MboRemote;
import psdi.mbo.MboServerInterface;
import psdi.mbo.MboSet;
import psdi.mbo.MboSetInfo;
import psdi.mbo.NonPersistentMboSet;
import psdi.mbo.SqlFormat;
import psdi.server.MXServer;
import psdi.util.MXException;

public class CatalogReconcileSet
extends NonPersistentMboSet {
    private static final long serialVersionUID = 6523807613842439167L;

    public CatalogReconcileSet(MboServerInterface ms) throws RemoteException {
        super(ms);
    }

    protected Mbo getMboInstance(MboSet mboSet) throws MXException, RemoteException {
        return new CatalogReconcile(mboSet);
    }

    public void execute() throws MXException, RemoteException {
        ArrayList<JobPartialReconcile.JobSpecPartialReconcile> partialReconciles = new ArrayList<JobPartialReconcile.JobSpecPartialReconcile>();
        ArrayList<JobReconcile.JobSpecReconcile> reconciles = new ArrayList<JobReconcile.JobSpecReconcile>();
        MboRemote mbo = this.moveFirst();
        while (mbo != null) {
            String reconcileWhereClause = mbo.getString("WHERECLAUSE").trim();
            if (mbo.getBoolean("SCOPE")) {
                this.processScopeReconcile(partialReconciles, mbo, reconcileWhereClause);
            } else if (mbo.getBoolean("DATA")) {
                this.processDataReconcile(partialReconciles, mbo, reconcileWhereClause);
            } else if (reconcileWhereClause.length() > 0) {
                this.processPartialReconcile(partialReconciles, mbo, reconcileWhereClause);
            } else {
                this.processFullReconcile(reconciles, mbo);
            }
            mbo = this.moveNext();
        }
        EvalContext evalContext = new EvalContext().setFlag(EvalFlags.USER_WAITING);
        if (reconciles.size() > 0) {
            JobConfig.getJobDispatcher().doReconciliations(evalContext.duplicate(), reconciles);
        }
        if (partialReconciles.size() > 0) {
            JobConfig.getJobDispatcher().doPartialReconciles(evalContext.duplicate(), partialReconciles);
        }
    }

    protected void processFullReconcile(Collection<JobReconcile.JobSpecReconcile> reconciles, MboRemote mbo) throws RemoteException, MXException {
        JobReconcile.JobSpecReconcile jobSpec = new JobReconcile.JobSpecReconcile(mbo.getLong("CATALOGID"), mbo.getLong("REVISION"));
        reconciles.add(jobSpec);
    }

    protected void processPartialReconcile(Collection<JobPartialReconcile.JobSpecPartialReconcile> partialReconciles, MboRemote mbo, String reconcileWhereClause) throws RemoteException, MXException {
        JobPartialReconcile.JobSpecPartialReconcile jobSpec = new JobPartialReconcile.JobSpecPartialReconcile(mbo.getLong("CATALOGID"), mbo.getLong("REVISION"), reconcileWhereClause);
        partialReconciles.add(jobSpec);
    }

    protected void processScopeReconcile(Collection<JobPartialReconcile.JobSpecPartialReconcile> partialReconciles, MboRemote mbo, String reconcileWhereClause) throws RemoteException, MXException {
        long catalogId = mbo.getLong("CATALOGID");
        long revision = mbo.getLong("REVISION");
        CachedCatalog catalog = NotificationEventListenerManager.CatalogCache.getCatalogOrThrow(catalogId, revision);
        String catalogWhereClause = catalog.whereClause != null ? catalog.whereClause.trim() : "";
        String catalogDataMembershipWhereClause = this.getCatalogDataMembershipWhereClause(mbo);
        StringBuilder addedReconcileWhereClause = new StringBuilder();
        addedReconcileWhereClause.append("not ").append(catalogDataMembershipWhereClause);
        if (catalogWhereClause.length() > 0) {
            addedReconcileWhereClause.append(" and (").append(catalogWhereClause).append(")");
        }
        if (reconcileWhereClause.length() > 0) {
            addedReconcileWhereClause.append(" and (").append(reconcileWhereClause).append(")");
        }
        JobPartialReconcile.JobSpecPartialReconcile addedJobSpec = new JobPartialReconcile.JobSpecPartialReconcile(catalogId, revision, addedReconcileWhereClause.toString());
        partialReconciles.add(addedJobSpec);
        StringBuilder removedReconcileWhereClause = new StringBuilder();
        removedReconcileWhereClause.append(catalogDataMembershipWhereClause);
        if (catalogWhereClause.length() > 0) {
            removedReconcileWhereClause.append(" and not (").append(catalogWhereClause).append(")");
        }
        if (reconcileWhereClause.length() > 0) {
            removedReconcileWhereClause.append(" and (").append(reconcileWhereClause).append(")");
        }
        JobPartialReconcile.JobSpecPartialReconcile removedJobSpec = new JobPartialReconcile.JobSpecPartialReconcile(catalogId, revision, removedReconcileWhereClause.toString());
        partialReconciles.add(removedJobSpec);
    }

    protected void processDataReconcile(Collection<JobPartialReconcile.JobSpecPartialReconcile> partialReconciles, MboRemote mbo, String reconcileWhereClause) throws RemoteException, MXException {
        long catalogId = mbo.getLong("CATALOGID");
        long revision = mbo.getLong("REVISION");
        String catalogDataMembershipWhereClause = this.getCatalogDataMembershipWhereClause(mbo);
        StringBuilder withinCatalogWhereClause = new StringBuilder(catalogDataMembershipWhereClause);
        if (reconcileWhereClause.length() > 0) {
            withinCatalogWhereClause.append(" and (").append(reconcileWhereClause).append(")");
        }
        JobPartialReconcile.JobSpecPartialReconcile removedJobSpec = new JobPartialReconcile.JobSpecPartialReconcile(catalogId, revision, withinCatalogWhereClause.toString());
        partialReconciles.add(removedJobSpec);
    }

    protected String getCatalogDataMembershipWhereClause(MboRemote mbo) throws RemoteException, MXException {
        MboSetInfo mboSetInfo = MXServer.getMXServer().getMaximoDD().getMboSetInfo(mbo.getString("OBJECTNAME"));
        String uniqueColumnName = mboSetInfo.getAttribute(mboSetInfo.getUniqueIDName()).getEntityColumnName();
        String query = "exists (select 1 from iscatalogdata where recordid=" + uniqueColumnName + " and catalogid=:1 and revision=:2 and inscope=1)";
        SqlFormat sqlFormat = new SqlFormat(query);
        sqlFormat.setLong(1, mbo.getLong("CATALOGID"));
        sqlFormat.setLong(2, mbo.getLong("REVISION"));
        return sqlFormat.format();
    }
}

