/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util.db;

import com.interlocsolutions.maximo.notify.err.InformerConfException;
import com.interlocsolutions.maximo.notify.util.db.DbAccessorBase;
import com.interlocsolutions.maximo.notify.util.db.DbServerType;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.sqlite.SQLiteConfig;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u000eH\u0014J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u000eH\u0014R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lcom/interlocsolutions/maximo/notify/util/db/SqliteDbConnectionAccessor;", "Lcom/interlocsolutions/maximo/notify/util/db/DbAccessorBase;", "jdbcString", "", "driverClassName", "(Ljava/lang/String;Ljava/lang/String;)V", "dbServerType", "Lcom/interlocsolutions/maximo/notify/util/db/DbServerType;", "getDbServerType", "()Lcom/interlocsolutions/maximo/notify/util/db/DbServerType;", "isMaximoDB", "", "()Z", "singleConnection", "Ljava/sql/Connection;", "getSingleConnection", "()Ljava/sql/Connection;", "singleConnection$delegate", "Lkotlin/Lazy;", "destroy", "", "obtain", "release", "conn", "isinformer"})
public final class SqliteDbConnectionAccessor
extends DbAccessorBase {
    @NotNull
    private final String jdbcString;
    @NotNull
    private final String driverClassName;
    @NotNull
    private final Lazy singleConnection$delegate;

    public SqliteDbConnectionAccessor(@NotNull String jdbcString, @NotNull String driverClassName) {
        Intrinsics.checkNotNullParameter((Object)jdbcString, (String)"jdbcString");
        Intrinsics.checkNotNullParameter((Object)driverClassName, (String)"driverClassName");
        this.jdbcString = jdbcString;
        this.driverClassName = driverClassName;
        try {
            Class.forName(this.driverClassName);
        }
        catch (ClassNotFoundException e) {
            throw new InformerConfException("Expected SQLite driver not found", e);
        }
        this.singleConnection$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Connection>(this){
            final /* synthetic */ SqliteDbConnectionAccessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final Connection invoke() {
                void $this$invoke_u24lambda_u240;
                SQLiteConfig sQLiteConfig;
                SQLiteConfig sQLiteConfig2 = sQLiteConfig = new SQLiteConfig();
                String string = SqliteDbConnectionAccessor.access$getJdbcString$p(this.this$0);
                boolean bl = false;
                $this$invoke_u24lambda_u240.setSynchronous(SQLiteConfig.SynchronousMode.NORMAL);
                $this$invoke_u24lambda_u240.setJournalMode(SQLiteConfig.JournalMode.WAL);
                $this$invoke_u24lambda_u240.setDateClass(SQLiteConfig.DateClass.TEXT.getValue());
                $this$invoke_u24lambda_u240.setDateStringFormat("yyyy-MM-dd HH:mm:ss");
                Connection conn = DriverManager.getConnection(string, sQLiteConfig.toProperties());
                try {
                    conn.setAutoCommit(true);
                }
                catch (Exception e) {
                    conn.close();
                    throw e;
                }
                return conn;
            }
        }));
    }

    @Override
    @NotNull
    public DbServerType getDbServerType() {
        return DbServerType.SQLITE;
    }

    @Override
    public boolean isMaximoDB() {
        return false;
    }

    private final Connection getSingleConnection() {
        Lazy lazy = this.singleConnection$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-singleConnection>(...)");
        return (Connection)object;
    }

    @Override
    @NotNull
    protected Connection obtain() throws SQLException {
        return this.getSingleConnection();
    }

    @Override
    protected void release(@NotNull Connection conn) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
    }

    @Override
    public void destroy() {
        try {
            this.getSingleConnection().close();
        }
        catch (Exception e) {
            this.getLOGGER().error((Object)"Error closing Connection", (Throwable)e);
        }
    }

    public static final /* synthetic */ String access$getJdbcString$p(SqliteDbConnectionAccessor $this) {
        return $this.jdbcString;
    }
}

