/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util.db;

import com.interlocsolutions.maximo.notify.util.db.DataUtils;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import psdi.util.MXException;

public class ResultSetHandlers {
    private static final DataUtils.ResultSetHandler<String> FIRST_STRING = new DataUtils.ResultSetHandler<String>(){

        @Override
        public String useResultSet(@NotNull ResultSet rs) throws RemoteException, MXException, SQLException {
            if (rs.next()) {
                return rs.getString(0);
            }
            return null;
        }
    };
    private static final DataUtils.ResultSetHandler<Boolean> FIRST_BOOLEAN = new DataUtils.ResultSetHandler<Boolean>(){

        @Override
        public Boolean useResultSet(@NotNull ResultSet rs) throws RemoteException, MXException, SQLException {
            if (rs.next()) {
                return rs.getBoolean(0);
            }
            return null;
        }
    };

    public static DataUtils.ResultSetHandler<String> firstString() {
        return FIRST_STRING;
    }

    public static DataUtils.ResultSetHandler<String> singleString(final @NotNull String columnName) {
        return new DataUtils.ResultSetHandler<String>(){

            @Override
            public String useResultSet(@NotNull ResultSet rs) throws RemoteException, MXException, SQLException {
                if (rs.next()) {
                    return rs.getString(columnName);
                }
                return null;
            }
        };
    }

    public static DataUtils.ResultSetHandler<Boolean> firstBoolean() {
        return FIRST_BOOLEAN;
    }

    public static DataUtils.ResultSetHandler<Boolean> singleBoolean(final @NotNull String columnName) {
        return new DataUtils.ResultSetHandler<Boolean>(){

            @Override
            public Boolean useResultSet(@NotNull ResultSet rs) throws RemoteException, MXException, SQLException {
                if (rs.next()) {
                    return rs.getBoolean(columnName);
                }
                return null;
            }
        };
    }

    public static DataUtils.ResultSetHandler<Set<String>> uniqueStrings(final @NotNull String columnName) {
        return new DataUtils.ResultSetHandler<Set<String>>(){

            @Override
            public Set<String> useResultSet(@NotNull ResultSet rs) throws RemoteException, MXException, SQLException {
                Set<String> results;
                if (rs.next()) {
                    results = new HashSet();
                    int colIdx = rs.findColumn(columnName);
                    results.add(rs.getString(colIdx));
                    while (rs.next()) {
                        results.add(rs.getString(colIdx));
                    }
                } else {
                    results = Collections.emptySet();
                }
                return results;
            }
        };
    }
}

