/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util.db;

import com.interlocsolutions.maximo.notify.util.ImmutableLongSet;
import com.interlocsolutions.maximo.notify.util.db.DbServerType;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.mbo.MaximoDD;
import psdi.mbo.MboSetInfo;
import psdi.mbo.SqlFormat;
import psdi.security.ConnectionKey;
import psdi.security.UserInfo;
import psdi.server.DBManager;
import psdi.server.MXServer;
import psdi.util.MXException;
import psdi.util.MXUnknownObjectException;

public class DataUtils {
    public static <T> T queryByMbo(@NotNull UserInfo userInfo, @NotNull String mboName, @Nullable String[] attrs, @Nullable String whereClause, @Nullable String orderBy, @NotNull ResultSetHandler<T> resultSetHandler) throws RemoteException, MXException, SQLException {
        MboSetInfo msi = ((MaximoDD)MXServer.getMXServer().getFromMaximoCache("MAXIMODD")).getMboSetInfo(mboName);
        if (msi == null) {
            throw new MXUnknownObjectException("system", "unknownobject", new Object[]{mboName});
        }
        return DataUtils.query(userInfo, msi.getEntityName(), attrs, whereClause, orderBy, resultSetHandler);
    }

    /*
     * Exception decompiling
     */
    public static <T> T query(@NotNull UserInfo userInfo, @NotNull String entityName, @Nullable String[] attrs, @Nullable String whereClause, @Nullable String orderBy, @NotNull ResultSetHandler<T> resultSetHandler) throws RemoteException, MXException, SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static ResultSet directQuery(@NotNull Statement statement, @NotNull String entityName, @Nullable String[] attrs, @Nullable String whereClause, @Nullable String orderBy) throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        if (attrs == null || attrs.length < 1) {
            sb.append("*");
        } else {
            boolean first = true;
            for (String attr : attrs) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(attr);
            }
        }
        sb.append(" FROM ").append(entityName);
        if (whereClause != null && !whereClause.trim().isEmpty()) {
            sb.append(" WHERE ").append(whereClause);
        }
        if (orderBy != null && !orderBy.trim().isEmpty()) {
            sb.append(" ORDER BY ").append(orderBy);
        }
        String query = new SqlFormat(sb.toString()).format();
        return statement.executeQuery(query);
    }

    public static ImmutableLongSet collectUniqueIdsByMbo(@NotNull UserInfo userInfo, @NotNull String mboName, @NotNull String whereClause) throws RemoteException, MXException, SQLException {
        MboSetInfo msi = ((MaximoDD)MXServer.getMXServer().getFromMaximoCache("MAXIMODD")).getMboSetInfo(mboName);
        if (msi == null) {
            throw new MXUnknownObjectException("system", "unknownobject", new Object[]{mboName});
        }
        return DataUtils.collectUniqueLongs(userInfo, msi.getEntityName(), msi.getUniqueIDName(), whereClause);
    }

    public static ImmutableLongSet collectUniqueLongsByMbo(@NotNull UserInfo userInfo, @NotNull String mboName, @NotNull String targetAttribute, @NotNull String whereClause) throws RemoteException, MXException, SQLException {
        MboSetInfo msi = ((MaximoDD)MXServer.getMXServer().getFromMaximoCache("MAXIMODD")).getMboSetInfo(mboName);
        if (msi == null) {
            throw new MXUnknownObjectException("system", "unknownobject", new Object[]{mboName});
        }
        return DataUtils.collectUniqueLongs(userInfo, msi.getEntityName(), targetAttribute, whereClause);
    }

    public static ImmutableLongSet collectUniqueLongs(@NotNull UserInfo userInfo, @NotNull String entityName, final @NotNull String targetAttribute, @NotNull String whereClause) throws RemoteException, MXException, SQLException {
        return DataUtils.query(userInfo, entityName, new String[]{targetAttribute}, whereClause, null, new ResultSetHandler<ImmutableLongSet>(){

            @Override
            public ImmutableLongSet useResultSet(@NotNull ResultSet rs) throws RemoteException, MXException, SQLException {
                ImmutableLongSet.Builder longSetBuilder = new ImmutableLongSet.Builder();
                int idxId = rs.findColumn(targetAttribute);
                while (rs.next()) {
                    longSetBuilder.add(rs.getLong(idxId));
                }
                return longSetBuilder.build();
            }
        });
    }

    public static String formNotifyIdQuery(List<String> profileNames) throws RemoteException, MXException {
        return new SqlFormat("SELECT notifyid FROM isnotify WHERE " + DataUtils.formSafeInClause("notifynum", "ISNOTIFY", "NOTIFYNUM", profileNames)).format();
    }

    public static String formSafeInClause(String colToMatch, String tbName, String colName, List<String> values) throws RemoteException, MXException {
        if (values == null || values.size() < 1) {
            return new SqlFormat("1=2").format();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(colToMatch).append(" IN (");
        for (int i = 1; i <= values.size(); ++i) {
            if (i > 1) {
                sb.append(",");
            }
            sb.append(":").append(i);
        }
        sb.append(")");
        SqlFormat sqlf = new SqlFormat(sb.toString());
        for (int i = 1; i <= values.size(); ++i) {
            sqlf.setObject(i, tbName, colName, values.get(i - 1));
        }
        return sqlf.format();
    }

    public static String formSafeNotInClause(String colToMatch, String tbName, String colName, String[] values) throws RemoteException, MXException {
        return DataUtils.formSafeNotInClause(colToMatch, tbName, colName, Arrays.asList(values));
    }

    public static String formSafeNotInClause(String colToMatch, String tbName, String colName, List<String> values) throws RemoteException, MXException {
        if (values == null || values.size() < 1) {
            return new SqlFormat("1=2").format();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(colToMatch).append(" NOT IN (");
        for (int i = 1; i <= values.size(); ++i) {
            if (i > 1) {
                sb.append(",");
            }
            sb.append(":").append(i);
        }
        sb.append(")");
        SqlFormat sqlf = new SqlFormat(sb.toString());
        for (int i = 1; i <= values.size(); ++i) {
            sqlf.setObject(i, tbName, colName, values.get(i - 1));
        }
        return sqlf.format();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T systemDbConn(@NotNull DbConnectionCallback<T> callback) throws RemoteException, MXException, SQLException {
        DBManager dbManager = MXServer.getMXServer().getDBManager();
        ConnectionKey key = dbManager.getSystemConnectionKey();
        try {
            T t;
            Connection c = dbManager.getConnection(key);
            try {
                if (!c.getAutoCommit()) {
                    c.rollback();
                }
                t = callback.useConnection(c, DbServerType.identify((Connection)c));
            }
            catch (Throwable throwable) {
                if (!c.getAutoCommit()) {
                    c.rollback();
                }
                throw throwable;
            }
            if (!c.getAutoCommit()) {
                c.rollback();
            }
            return t;
        }
        finally {
            dbManager.freeConnection(key);
        }
    }

    public static <T> T systemRawQuery(final @NotNull String query, final @NotNull ResultSetHandler<T> callback) throws RemoteException, MXException, SQLException {
        return DataUtils.systemDbConn(new DbConnectionCallback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T useConnection(@NotNull Connection conn, @NotNull DbServerType dbServerType) throws RemoteException, MXException, SQLException {
                try (Statement stmt = conn.createStatement();){
                    Object ReturnType;
                    ResultSet resultSet = stmt.executeQuery(new SqlFormat(query).format());
                    try {
                        ReturnType = callback.useResultSet(resultSet);
                    }
                    catch (Throwable throwable) {
                        resultSet.close();
                        throw throwable;
                    }
                    resultSet.close();
                    return ReturnType;
                }
            }
        });
    }

    public static boolean systemExistsQuery(@NotNull String query) throws RemoteException, MXException, SQLException {
        return DataUtils.systemRawQuery(query, new ResultSetHandler<Boolean>(){

            @Override
            public Boolean useResultSet(@NotNull ResultSet rs) throws SQLException {
                return rs.next();
            }
        });
    }

    public static boolean existsQuery(@NotNull UserInfo userInfo, @NotNull String query) throws RemoteException, MXException, SQLException {
        return DataUtils.rawQuery(userInfo, query, new ResultSetHandler<Boolean>(){

            @Override
            public Boolean useResultSet(@NotNull ResultSet rs) throws SQLException {
                return rs.next();
            }
        });
    }

    public static <T> T rawQuery(final @NotNull UserInfo userInfo, final @NotNull String query, final @NotNull ResultSetHandler<T> callback) throws RemoteException, MXException, SQLException {
        return DataUtils.dbConn(userInfo, new DbConnectionCallback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T useConnection(@NotNull Connection conn, @NotNull DbServerType dbServerType) throws RemoteException, MXException, SQLException {
                try (Statement stmt = conn.createStatement();){
                    Object ReturnType;
                    ResultSet resultSet = stmt.executeQuery(new SqlFormat(userInfo, query).format());
                    try {
                        ReturnType = callback.useResultSet(resultSet);
                    }
                    catch (Throwable throwable) {
                        resultSet.close();
                        throw throwable;
                    }
                    resultSet.close();
                    return ReturnType;
                }
            }
        });
    }

    public static int systemRawCUD(final @NotNull String statement) throws RemoteException, MXException, SQLException {
        return DataUtils.systemDbConn(new DbConnectionCallback<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer useConnection(@NotNull Connection conn, @NotNull DbServerType dbServerType) throws SQLException {
                int result;
                try (Statement stmt = conn.createStatement();){
                    result = stmt.executeUpdate(new SqlFormat(statement).format());
                }
                if (!conn.getAutoCommit()) {
                    conn.commit();
                }
                return result;
            }
        });
    }

    public static int rawCUD(final @NotNull UserInfo userInfo, final @NotNull String statement) throws RemoteException, MXException, SQLException {
        return DataUtils.dbConn(userInfo, new DbConnectionCallback<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer useConnection(@NotNull Connection conn, @NotNull DbServerType dbServerType) throws SQLException {
                int result;
                try (Statement stmt = conn.createStatement();){
                    result = stmt.executeUpdate(new SqlFormat(userInfo, statement).format());
                }
                if (!conn.getAutoCommit()) {
                    conn.commit();
                }
                return result;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T dbConn(@NotNull UserInfo userInfo, @NotNull DbConnectionCallback<T> callback) throws RemoteException, MXException, SQLException {
        DBManager dbManager = MXServer.getMXServer().getDBManager();
        ConnectionKey key = userInfo.getConnectionKey();
        try {
            T t;
            Connection c = dbManager.getConnection(key);
            try {
                if (!c.getAutoCommit()) {
                    c.rollback();
                }
                t = callback.useConnection(c, DbServerType.identify((Connection)c));
            }
            catch (Throwable throwable) {
                if (!c.getAutoCommit()) {
                    c.rollback();
                }
                throw throwable;
            }
            if (!c.getAutoCommit()) {
                c.rollback();
            }
            return t;
        }
        finally {
            dbManager.freeConnection(key);
        }
    }

    public static interface ResultSetHandler<ReturnType> {
        public ReturnType useResultSet(@NotNull ResultSet var1) throws RemoteException, MXException, SQLException;
    }

    public static interface DbConnectionCallback<ReturnType> {
        public ReturnType useConnection(@NotNull Connection var1, @NotNull DbServerType var2) throws RemoteException, MXException, SQLException;
    }

    public static interface CascadeDeletion {
        public void deleteChildrenOf(Long var1) throws Exception;
    }

    public static interface DbConnectionConsumer {
        public void useConnection(@NotNull Connection var1, @NotNull DbServerType var2) throws RemoteException, MXException, SQLException;
    }
}

