/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import java.text.ParseException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000e\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0014B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0007H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/interlocsolutions/maximo/notify/util/SemanticVersion;", "", "major", "", "minor", "patch", "preRelease", "", "metaData", "(IIILjava/lang/String;Ljava/lang/String;)V", "getMajor", "()I", "getMetaData", "()Ljava/lang/String;", "getMinor", "getPatch", "getPreRelease", "compareTo", "o", "toString", "Companion", "isinformer"})
public final class SemanticVersion
implements Comparable<SemanticVersion> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int major;
    private final int minor;
    private final int patch;
    @Nullable
    private final String preRelease;
    @Nullable
    private final String metaData;
    @NotNull
    private static final Regex semverRegex = new Regex("^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");

    public SemanticVersion(int major, int minor, int patch, @Nullable String preRelease, @Nullable String metaData) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.preRelease = preRelease;
        this.metaData = metaData;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getPatch() {
        return this.patch;
    }

    @Nullable
    public final String getPreRelease() {
        return this.preRelease;
    }

    @Nullable
    public final String getMetaData() {
        return this.metaData;
    }

    @NotNull
    public String toString() {
        return this.preRelease != null && this.metaData != null ? "" + this.major + '.' + this.minor + '.' + this.patch + '-' + this.preRelease + '+' + this.metaData : (this.preRelease != null ? "" + this.major + '.' + this.minor + '.' + this.patch + '-' + this.preRelease : (this.metaData != null ? "" + this.major + '.' + this.minor + '.' + this.patch + '+' + this.metaData : "" + this.major + '.' + this.minor + '.' + this.patch));
    }

    @Override
    public int compareTo(@NotNull SemanticVersion o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        int result = SemanticVersion.Companion.intCompare(this.major, o.major);
        if (result == 0 && (result = SemanticVersion.Companion.intCompare(this.minor, o.minor)) == 0 && (result = SemanticVersion.Companion.intCompare(this.patch, o.patch)) == 0) {
            int n;
            CharSequence charSequence = this.preRelease;
            boolean weArePreRelease = !(charSequence == null || charSequence.length() == 0);
            CharSequence charSequence2 = o.preRelease;
            boolean theyArePreRelease = !(charSequence2 == null || charSequence2.length() == 0);
            if (weArePreRelease && !theyArePreRelease) {
                n = -1;
            } else if (!weArePreRelease && theyArePreRelease) {
                n = 1;
            } else if (!weArePreRelease && !theyArePreRelease) {
                n = 0;
            } else {
                String string = this.preRelease;
                Intrinsics.checkNotNull((Object)string);
                String string2 = o.preRelease;
                Intrinsics.checkNotNull((Object)string2);
                n = string.compareTo(string2);
            }
            result = n;
        }
        return result;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/interlocsolutions/maximo/notify/util/SemanticVersion$Companion;", "", "()V", "semverRegex", "Lkotlin/text/Regex;", "intCompare", "", "thisOne", "thatOne", "parse", "Lcom/interlocsolutions/maximo/notify/util/SemanticVersion;", "versionStr", "", "isinformer"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SemanticVersion parse(@NotNull String versionStr) {
            CharSequence charSequence;
            CharSequence charSequence2;
            String string;
            int n;
            int n2;
            int n3;
            Intrinsics.checkNotNullParameter((Object)versionStr, (String)"versionStr");
            Object object = Regex.find$default((Regex)semverRegex, (CharSequence)versionStr, (int)0, (int)2, null);
            if (object == null || (object = object.getGroupValues()) == null) {
                throw new ParseException("The semantic version \"" + versionStr + "\" could not be parsed based on Semantic Versioning 2.0.0 (https://semver.org)", 0);
            }
            Object parts = object;
            int n4 = Integer.parseInt((String)parts.get(1));
            int n5 = Integer.parseInt((String)parts.get(2));
            int n6 = Integer.parseInt((String)parts.get(3));
            CharSequence charSequence3 = (CharSequence)parts.get(4);
            if (StringsKt.isBlank((CharSequence)charSequence3)) {
                n3 = n6;
                n2 = n5;
                n = n4;
                boolean bl = false;
                string = null;
                n4 = n;
                n5 = n2;
                n6 = n3;
                charSequence2 = string;
            } else {
                charSequence2 = charSequence3;
            }
            String string2 = (String)charSequence2;
            charSequence3 = (CharSequence)parts.get(5);
            if (StringsKt.isBlank((CharSequence)charSequence3)) {
                string = string2;
                n3 = n6;
                n2 = n5;
                n = n4;
                boolean bl = false;
                Object var9_9 = null;
                n4 = n;
                n5 = n2;
                n6 = n3;
                string2 = string;
                charSequence = var9_9;
            } else {
                charSequence = charSequence3;
            }
            String string3 = (String)charSequence;
            String string4 = string2;
            int n7 = n6;
            int n8 = n5;
            int n9 = n4;
            return new SemanticVersion(n9, n8, n7, string4, string3);
        }

        private final int intCompare(int thisOne, int thatOne) {
            return thisOne < thatOne ? -1 : (thisOne == thatOne ? 0 : 1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

