/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import psdi.server.MXServer;

public class RuntimeInfo {
    public final String host;
    public final String mxName;
    public final String ipAddr;
    public final String threadName;

    private RuntimeInfo(String host, String mxName, String ipAddr) {
        this.host = host;
        this.mxName = mxName;
        this.ipAddr = ipAddr;
        this.threadName = Thread.currentThread().getName();
    }

    public static RuntimeInfo getRuntimeInfo() {
        MXServer mxServer;
        try {
            mxServer = MXServer.getMXServer();
        }
        catch (RemoteException e) {
            return new RuntimeInfo("UNKNOWN", "UNKNOWN", "UNKNOWN");
        }
        String mxName = mxServer.getName();
        if (mxName == null) {
            mxName = "UNKNOWN";
        }
        try {
            String registryHostName;
            String host;
            InetAddress localHost = InetAddress.getLocalHost();
            String ipAddr = localHost.getHostAddress();
            if (ipAddr == null) {
                ipAddr = "UNKNOWN";
            }
            String string = host = (registryHostName = mxServer.getRegistryHostName()) != null ? registryHostName : localHost.getHostName();
            if (host == null) {
                host = "UNKNOWN";
            }
            return new RuntimeInfo(host, mxName, ipAddr);
        }
        catch (UnknownHostException e) {
            return new RuntimeInfo("UNKNOWN", mxName, "UNKNOWN");
        }
    }
}

