/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import com.interlocsolutions.maximo.notify.util.Predicate;
import org.jetbrains.annotations.NotNull;

public final class Predicates<T> {
    private Predicates() {
    }

    public static <T> Predicate<T> and(final @NotNull Predicate<T> first, final Predicate<T> ... others) {
        return new Predicate<T>(){

            @Override
            public boolean apply(T arg) {
                boolean result = first.apply(arg);
                if (!result) {
                    return false;
                }
                for (Predicate other : others) {
                    if (other.apply(arg)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <T> Predicate<T> or(final @NotNull Predicate<T> first, final Predicate<T> ... others) {
        return new Predicate<T>(){

            @Override
            public boolean apply(T arg) {
                boolean result = first.apply(arg);
                if (result) {
                    return true;
                }
                for (Predicate other : others) {
                    if (!other.apply(arg)) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

