/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import com.interlocsolutions.maximo.notify.util.LogLevel;
import java.util.concurrent.TimeUnit;
import psdi.util.logging.MXLogger;

public class PerformanceTimer {
    private final MXLogger mxLogger;
    private final LogLevel logLevel;
    private final TimeUnit timeUnit;
    private final String msgFormat;
    private long startTime;

    public PerformanceTimer(MXLogger mxLogger, LogLevel logLevel, TimeUnit timeUnit, String msgFormat) {
        this.mxLogger = mxLogger;
        this.logLevel = logLevel;
        this.msgFormat = "ISINFPERF: " + msgFormat;
        this.timeUnit = timeUnit;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    public long stop() {
        long endTime = System.currentTimeMillis();
        long convertedTime = this.timeUnit.convert(endTime - this.startTime, TimeUnit.MILLISECONDS);
        if (this.logLevel.enabled(this.mxLogger)) {
            this.logLevel.log(this.mxLogger, String.format(this.msgFormat, convertedTime));
        }
        return convertedTime;
    }
}

