/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import com.interlocsolutions.maximo.notify.NotificationEventListenerManager;
import com.interlocsolutions.maximo.notify.UserNotificationRemote;
import com.interlocsolutions.maximo.notify.err.NoSuchCatalogException;
import com.interlocsolutions.maximo.notify.util.CachedCatalog;
import com.interlocsolutions.maximo.notify.util.ImmutableLongSet;
import com.interlocsolutions.maximo.notify.util.InformerClassUtils;
import com.interlocsolutions.maximo.notify.util.LogLevel;
import com.interlocsolutions.maximo.notify.util.MboUtil;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.PerformanceTimer;
import com.interlocsolutions.maximo.notify.util.PropUtils;
import com.interlocsolutions.maximo.notify.util.StringUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.common.condition.CustomCondition;
import psdi.common.condition.MaxConditionCache;
import psdi.mbo.MaximoDD;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.security.ConnectionKey;
import psdi.security.UserInfo;
import psdi.server.DBManager;
import psdi.server.MXServer;
import psdi.server.MXServerInfo;
import psdi.server.MaxVarServiceRemote;
import psdi.util.MXApplicationException;
import psdi.util.MXException;
import psdi.util.MXSession;
import psdi.util.logging.MXLoggerFactory;

public class NotifyUtil {
    private static final PerformanceTimer timerCondExpExec = new PerformanceTimer(MXLoggerFactory.getLogger((String)"maximo.informer.crqp.nycha"), LogLevel.DEBUG, TimeUnit.MILLISECONDS, "Evaluating conditional expression to determine record's presence in Catalog scope took %dms");
    private static String instanceURL = null;
    private static Collection<String> sSystemLanguages;
    private static Collection<String> sInformerLanguages;

    public static void unregister(String topic, int id) {
        try {
            MXServer.getEventTopicTree().unregister(topic, id);
        }
        catch (MXException e) {
            NotifyConstants.INFORMER_LOGGER.warn((Object)("Unable to unregister event " + topic + " with id " + id));
        }
    }

    public static void close(MboSetRemote set) {
        try {
            if (set != null) {
                set.close();
            }
        }
        catch (MXException e) {
            if (!"FauxNotImp".equals(e.getErrorKey())) {
                NotifyConstants.INFORMER_LOGGER.debug((Object)"Error closing MboSet.", (Throwable)e);
            }
        }
        catch (Throwable e) {
            NotifyConstants.INFORMER_LOGGER.debug((Object)"Error closing MboSet.", e);
        }
    }

    public static void closeAndCleanup(MboSetRemote set) {
        NotifyUtil.cleanup(set);
        NotifyUtil.clear(set);
    }

    public static void clear(MboSetRemote set) {
        try {
            if (set != null) {
                set.clear();
            }
        }
        catch (MXException e) {
            if (!"FauxNotImp".equals(e.getErrorKey())) {
                NotifyConstants.INFORMER_LOGGER.debug((Object)"Error cleaning up MboSet.", (Throwable)e);
            }
        }
        catch (Throwable e) {
            NotifyConstants.INFORMER_LOGGER.debug((Object)"Error cleaning up MboSet.", e);
        }
    }

    public static void cleanup(MboSetRemote set) {
        try {
            if (set != null) {
                set.cleanup();
            }
        }
        catch (MXException e) {
            if (!"FauxNotImp".equals(e.getErrorKey())) {
                NotifyConstants.INFORMER_LOGGER.debug((Object)"Error cleaning up MboSet.", (Throwable)e);
            }
        }
        catch (Throwable e) {
            NotifyConstants.INFORMER_LOGGER.debug((Object)"Error cleaning up MboSet.", e);
        }
    }

    public static void close(Connection dbConnection) {
        try {
            if (dbConnection != null) {
                dbConnection.close();
            }
        }
        catch (Throwable e) {
            NotifyConstants.INFORMER_LOGGER.debug((Object)"Error closing database.", e);
        }
    }

    public static void close(Statement s) {
        try {
            if (s != null) {
                s.close();
            }
        }
        catch (Throwable e) {
            NotifyConstants.INFORMER_LOGGER.debug((Object)"Error closing Statement.", e);
        }
    }

    public static void close(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Throwable e) {
            NotifyConstants.INFORMER_LOGGER.debug((Object)"Error closing Result Set.", e);
        }
    }

    public static void close(MXSession session) {
        if (session != null && session.isConnected()) {
            try {
                session.disconnect();
            }
            catch (RemoteException e) {
                NotifyConstants.INFORMER_LOGGER.debug((Object)"Error closing Session.", (Throwable)e);
            }
            catch (MXException e) {
                NotifyConstants.INFORMER_LOGGER.debug((Object)"Error closing Session.", (Throwable)e);
            }
        }
    }

    public static String getVersion() {
        return "Interloc Mobile Informer v6.4.1-rc.2 Release " + NotifyUtil.getRelease();
    }

    public static String getRelease() {
        String rc2;
        try {
            MaxVarServiceRemote mvs = (MaxVarServiceRemote)MXServer.getMXServer().lookup("MAXVARS");
            rc2 = mvs.getString("ISINF", null);
        }
        catch (NullPointerException e) {
            rc2 = "Unretrievable";
        }
        catch (RemoteException e) {
            rc2 = "Unretrievable";
        }
        catch (MXException e) {
            rc2 = "Unretrievable";
        }
        return rc2;
    }

    public static boolean isTrackingNotification() {
        try {
            String tracking = MXServer.getMXServer().getProperty("informer.stats");
            String n = MXServer.getMXServer().getProperty("informer.stats.notification");
            return !(!"true".equalsIgnoreCase(tracking) && !"1".equalsIgnoreCase(tracking) || !"true".equalsIgnoreCase(n) && !"1".equalsIgnoreCase(n));
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public static boolean isTrackingCatalog() {
        try {
            String tracking = MXServer.getMXServer().getProperty("informer.stats");
            String c = MXServer.getMXServer().getProperty("informer.stats.catalog");
            return !(!"true".equalsIgnoreCase(tracking) && !"1".equalsIgnoreCase(tracking) || !"true".equalsIgnoreCase(c) && !"1".equalsIgnoreCase(c));
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public static boolean isTrackingPush() {
        try {
            String tracking = MXServer.getMXServer().getProperty("informer.stats");
            String p = MXServer.getMXServer().getProperty("informer.stats.push");
            return !(!"true".equalsIgnoreCase(tracking) && !"1".equalsIgnoreCase(tracking) || !"true".equalsIgnoreCase(p) && !"1".equalsIgnoreCase(p));
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public static boolean isTrackingRetrieval() {
        try {
            String tracking = MXServer.getMXServer().getProperty("informer.stats");
            String r = MXServer.getMXServer().getProperty("informer.stats.retrieval");
            return !(!"true".equalsIgnoreCase(tracking) && !"1".equalsIgnoreCase(tracking) || !"true".equalsIgnoreCase(r) && !"1".equalsIgnoreCase(r));
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public static boolean isMaximoRunning() {
        boolean maximoRunning = MXServerInfo.getMXServerInfo().isRunning();
        if (maximoRunning && PropUtils.getBooleanMaxProp("informer.stopOnRMIShutdown", false)) {
            try {
                if (instanceURL == null) {
                    instanceURL = MXServer.getMXServer().getURL();
                }
                if (instanceURL == null) {
                    return false;
                }
                Naming.lookup(instanceURL);
            }
            catch (Throwable t) {
                return false;
            }
        }
        return maximoRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void directDelete(MboSetRemote mboSet) {
        if (mboSet == null) {
            return;
        }
        String table = null;
        String where = null;
        Statement s = null;
        ConnectionKey key = null;
        try {
            key = mboSet.getUserInfo().getConnectionKey();
            Connection c = MXServer.getMXServer().getDBManager().getConnection(key);
            s = c.createStatement();
            where = mboSet.getCompleteWhere();
            if (where == null || where.trim().length() <= 0) {
                where = "1=1";
            }
            table = mboSet.getMboSetInfo().getEntityName();
            s.executeUpdate("delete " + table + " where " + where);
            c.commit();
        }
        catch (Throwable t) {
            try {
                NotifyConstants.INFORMER_LOGGER.error((Object)("Error direct deleting " + table + " with where clause " + where), t);
            }
            catch (Throwable throwable) {
                NotifyUtil.close(s);
                if (key != null) {
                    try {
                        MXServer.getMXServer().getDBManager().freeConnection(key);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            NotifyUtil.close(s);
            if (key != null) {
                try {
                    MXServer.getMXServer().getDBManager().freeConnection(key);
                }
                catch (RemoteException remoteException) {}
            }
        }
        NotifyUtil.close(s);
        if (key != null) {
            try {
                MXServer.getMXServer().getDBManager().freeConnection(key);
            }
            catch (RemoteException c) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int deleteViaJDBC(UserInfo userInfo, String mboName, String whereClause) throws RemoteException, SQLException {
        int numDeleted;
        DBManager dbManager = MXServer.getMXServer().getDBManager();
        ConnectionKey key = userInfo.getConnectionKey();
        Connection c = dbManager.getConnection(key);
        try {
            Statement s = c.createStatement();
            try {
                String table = ((MaximoDD)MXServer.getMXServer().getFromMaximoCache("MAXIMODD")).getMboSetInfo(mboName).getEntityName();
                String query = whereClause != null && !whereClause.trim().isEmpty() ? new SqlFormat("DELETE " + table + " WHERE " + whereClause).format() : new SqlFormat("DELETE " + table).format();
                numDeleted = s.executeUpdate(query);
                c.commit();
            }
            finally {
                NotifyUtil.close(s);
            }
        }
        finally {
            dbManager.freeConnection(key);
        }
        return numDeleted;
    }

    public static int deleteIteratively(UserInfo userInfo, String mboName, String whereClause) throws RemoteException, MXException {
        return MboUtil.deleteIteratively(userInfo, mboName, whereClause);
    }

    public static int visitMbos(@NotNull UserInfo userInfo, @NotNull String mboName, @NotNull String whereClause, @NotNull MboVisitor visitor) throws RemoteException, MXException {
        return MboUtil.visitMbos(userInfo, mboName, whereClause, visitor);
    }

    public static ImmutableLongSet collectUniqueIds(@NotNull UserInfo userInfo, @NotNull String mboName, @NotNull String whereClause) throws RemoteException, MXException {
        return MboUtil.collectUniqueIds(userInfo, mboName, whereClause);
    }

    public static int visitMbosWithRetry(@NotNull UserInfo userInfo, @NotNull String mboName, @NotNull String whereClause, @NotNull MboVisitor visitor, int concurrentModificationRetries) throws RemoteException, MXException {
        return MboUtil.visitMbosWithRetry(userInfo, mboName, whereClause, visitor, concurrentModificationRetries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean visitSingleMbo(@NotNull UserInfo userInfo, @NotNull String mboName, long uniqueId, @NotNull MboVisitor visitor) throws RemoteException, MXException {
        boolean found;
        MboSetRemote mboSet = MXServer.getMXServer().getMboSet(mboName, userInfo);
        try {
            MboRemote mbo = mboSet.getMboForUniqueId(uniqueId);
            if (mbo == null) {
                found = false;
            } else {
                visitor.visit(mbo);
                mboSet.save();
                found = true;
            }
        }
        finally {
            NotifyUtil.closeAndCleanup(mboSet);
        }
        return found;
    }

    public static String getTitle(UserNotificationRemote n) throws MXException {
        try {
            MboSetRemote objectSet;
            if (!n.isNull("OBJECTNAME") && (objectSet = n.getMboSet("OBJECT", n.getString("OBJECTNAME"))) != null) {
                MboRemote obj = objectSet.getMboForUniqueId(n.getLong("RECORDID"));
                StringBuilder sb = new StringBuilder();
                String[] keys = objectSet.getKeyAttributes();
                if (obj != null) {
                    boolean hasSite = false;
                    for (String key : keys) {
                        if (key.equals("SITEID")) {
                            hasSite = true;
                            continue;
                        }
                        if (key.equals("ORGID")) continue;
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        sb.append(key).append(" = ").append(obj.getString(key));
                    }
                    if (hasSite) {
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        sb.append("SITEID = ").append(obj.getString("SITEID"));
                    }
                    if (objectSet.getMboSetInfo().getMboValueInfo("DESCRIPTION") != null) {
                        sb.append(", ").append(obj.getString("DESCRIPTION"));
                    }
                    String ret = sb.toString();
                    int fieldLength = n.getMboValueData("TITLE").getLength();
                    if (ret.length() > fieldLength) {
                        ret = ret.substring(0, fieldLength);
                    }
                    return ret;
                }
            }
        }
        catch (RemoteException e) {
            NotifyConstants.INFORMER_LOGGER.error((Object)e);
        }
        return null;
    }

    public static String stringifyStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static Collection<String> getSystemLanguages() throws RemoteException, MXException {
        if (sSystemLanguages == null) {
            String[][] langList = MXServer.getMXServer().getLanguageList();
            ArrayList<String> langCodes = new ArrayList<String>(langList.length);
            for (String[] lang : langList) {
                langCodes.add(lang[0]);
            }
            Collections.sort(langCodes);
            sSystemLanguages = Collections.unmodifiableList(langCodes);
        }
        return sSystemLanguages;
    }

    public static Collection<String> getLangCodes() throws RemoteException, MXException {
        if (sInformerLanguages == null) {
            HashSet<String> supportedLangcodeSet;
            String supportedLangcodeCsv = PropUtils.getMaxProp("informer.lang.whitelist.csv", null);
            Set<String> langCodeWhitelist = StringUtils.splitSetByDelimiter(supportedLangcodeCsv, ",");
            if (langCodeWhitelist.isEmpty()) {
                supportedLangcodeSet = new HashSet<String>(NotifyUtil.getSystemLanguages());
            } else {
                HashSet<String> langCodeWhiltelistUpper = new HashSet<String>(langCodeWhitelist.size());
                for (String langCode : langCodeWhitelist) {
                    langCodeWhiltelistUpper.add(langCode.toUpperCase());
                }
                supportedLangcodeSet = new HashSet<String>(NotifyUtil.getSystemLanguages());
                supportedLangcodeSet.retainAll(langCodeWhiltelistUpper);
                supportedLangcodeSet.add(MXServer.getMXServer().getBaseLang());
            }
            ArrayList<String> supportedLangcodeList = new ArrayList<String>(supportedLangcodeSet);
            Collections.sort(supportedLangcodeList);
            supportedLangcodeList.trimToSize();
            sInformerLanguages = Collections.unmodifiableList(supportedLangcodeList);
        }
        return sInformerLanguages;
    }

    @Nullable
    public static Boolean evalCatalogCondition(long catalogId, long revision, MboRemote mbo) throws RemoteException, MXException, NoSuchCatalogException {
        return NotifyUtil.evalCatalogCondition(NotificationEventListenerManager.CatalogCache.getCatalogOrThrow(catalogId, revision), mbo);
    }

    @Nullable
    public static Boolean evalCatalogCondition(CachedCatalog catalog, MboRemote mbo) throws MXException, RemoteException {
        if (!StringUtils.isEmpty(catalog.conditionName)) {
            timerCondExpExec.start();
            boolean result = MXServer.getMXServer().getConditionCache().get(catalog.conditionName).evaluate(mbo);
            timerCondExpExec.stop();
            return result;
        }
        if (!StringUtils.isEmpty(catalog.conditionClass)) {
            try {
                CustomCondition evaluator = (CustomCondition)InformerClassUtils.loadClass(catalog.conditionClass).newInstance();
                timerCondExpExec.start();
                boolean result = evaluator.evaluateCondition(mbo, (Object)catalog.conditionExpr);
                timerCondExpExec.stop();
                return result;
            }
            catch (Exception e) {
                throw new MXApplicationException("system", "conditionClassError", new Object[]{catalog.conditionClass}, (Throwable)e);
            }
        }
        if (!StringUtils.isEmpty(catalog.conditionExpr)) {
            timerCondExpExec.start();
            boolean result = MaxConditionCache.getExpressionEvaluator().evaluateCondition(mbo, (Object)catalog.conditionExpr);
            timerCondExpExec.stop();
            return result;
        }
        return null;
    }

    public static String getAppDownloadUrl(@NotNull String notificationName) throws RemoteException, MXApplicationException {
        try {
            URL url;
            String urlStr = PropUtils.getMaxProp("informer.system.deploy.url", null);
            if (urlStr == null) {
                urlStr = MXServer.getMXServer().getProperty("mxe.int.webappurl");
                url = new URL(urlStr);
                url = url.getPort() <= 0 || url.getPort() == 80 || url.getPort() == 443 ? new URL(url.getProtocol(), url.getHost(), "/maximo/informer/apps/") : new URL(url, "/maximo/informer/apps/");
            } else {
                if (!urlStr.endsWith("/")) {
                    urlStr = urlStr + "/";
                }
                url = new URL(urlStr);
            }
            return new URL(url, notificationName.toLowerCase()).toString();
        }
        catch (MalformedURLException e) {
            throw new MXApplicationException("informer", "appLinkNoDeployURL");
        }
    }

    public static UserInfo getLocalUserInfo(String userId) throws MXException, RemoteException {
        UserInfo userInfo = MXServer.getMXServer().getUserInfo(userId);
        userInfo.setLocalSession(true);
        return userInfo;
    }

    public static interface MboVisitor {
        public void visit(@NotNull MboRemote var1) throws RemoteException, MXException;
    }

    public static enum TrackingType {
        NOTIFICATION,
        CATALOG,
        PUSH;

    }
}

