/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import psdi.util.logging.MXLogger;

public enum LogLevel {
    DEBUG,
    INFO,
    WARN,
    ERROR,
    FATAL;


    public boolean enabled(MXLogger mxLogger) {
        boolean enabled;
        switch (this) {
            case DEBUG: {
                enabled = mxLogger.isDebugEnabled();
                break;
            }
            case INFO: {
                enabled = mxLogger.isInfoEnabled();
                break;
            }
            case WARN: {
                enabled = mxLogger.isWarnEnabled();
                break;
            }
            case ERROR: {
                enabled = mxLogger.isErrorEnabled();
                break;
            }
            default: {
                enabled = mxLogger.isFatalEnabled();
            }
        }
        return enabled;
    }

    public void log(MXLogger mxLogger, Object o) {
        switch (this) {
            case DEBUG: {
                mxLogger.debug(o);
                break;
            }
            case INFO: {
                mxLogger.info(o);
                break;
            }
            case WARN: {
                mxLogger.warn(o);
                break;
            }
            case ERROR: {
                mxLogger.error(o);
                break;
            }
            case FATAL: {
                mxLogger.fatal(o);
            }
        }
    }

    public void log(MXLogger mxLogger, Object o, Throwable t) {
        switch (this) {
            case DEBUG: {
                mxLogger.debug(o, t);
                break;
            }
            case INFO: {
                mxLogger.debug(o, t);
                break;
            }
            case WARN: {
                mxLogger.debug(o, t);
                break;
            }
            case ERROR: {
                mxLogger.debug(o, t);
            }
        }
    }
}

