/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import com.interlocsolutions.maximo.notify.util.ListenerRegisterable;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import java.util.ArrayList;
import java.util.Collection;
import psdi.server.event.EventListener;
import psdi.util.MXException;

public class ListenerRegistrations {
    private Collection<ListenerRegisterable> registrations = new ArrayList<ListenerRegisterable>();

    public ListenerRegisterable register(EventListener listener, String topic) throws MXException {
        ListenerRegisterable lr = new ListenerRegisterable(listener, topic);
        lr.register();
        this.registrations.add(lr);
        return lr;
    }

    public ListenerRegistrations add(EventListener listener, String ... topics) {
        for (String topic : topics) {
            this.registrations.add(new ListenerRegisterable(listener, topic));
        }
        return this;
    }

    public ListenerRegistrations registerAll() throws MXException {
        try {
            for (ListenerRegisterable lr : this.registrations) {
                if (lr.isRegistered()) continue;
                lr.register();
            }
        }
        catch (MXException e) {
            this.unregisterAll();
            throw e;
        }
        catch (RuntimeException e) {
            this.unregisterAll();
            throw e;
        }
        return this;
    }

    public ListenerRegistrations unregisterAll() {
        for (ListenerRegisterable lr : this.registrations) {
            if (!lr.isRegistered()) continue;
            try {
                lr.unregister();
            }
            catch (MXException e) {
                NotifyConstants.INFORMER_LOGGER.error((Object)String.format("Failed to unregister listener (%s)", lr), (Throwable)e);
            }
        }
        return this;
    }
}

