/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import psdi.server.MXServer;
import psdi.server.event.EventListener;
import psdi.util.MXException;

public class ListenerRegisterable {
    public final String topic;
    public final EventListener listener;
    private int regId = -1;

    public ListenerRegisterable(EventListener listener, String topic) {
        this.topic = topic;
        this.listener = listener;
    }

    public boolean isRegistered() {
        return this.regId > -1;
    }

    public ListenerRegisterable register() throws MXException {
        this.regId = MXServer.getEventTopicTree().register(this.topic, this.listener);
        return this;
    }

    public ListenerRegisterable unregister() throws MXException {
        MXServer.getEventTopicTree().unregister(this.topic, this.regId);
        this.regId = -1;
        return this;
    }

    public String toString() {
        if (this.regId > -1) {
            return String.format("Registered Maximo EventListener, registration ID %d, for a listener (%s) on topic (%s)", this.regId, this.listener, this.topic);
        }
        return String.format("Unregistered Maximo EventListener for a listener (%s) on topic (%s)", this.listener, this.topic);
    }
}

