/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import com.interlocsolutions.maximo.notify.err.InformerException;
import com.interlocsolutions.maximo.notify.util.InformerLoggers;
import com.interlocsolutions.maximo.notify.util.InformerThreadIndefinite;
import com.interlocsolutions.maximo.notify.util.License;
import com.interlocsolutions.maximo.notify.util.MboExtensionsKt;
import com.interlocsolutions.maximo.notify.util.MboSetRemoteClosableWrapper;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.util.MXServerFactory;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.util.Date;
import javax.xml.bind.JAXBException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.server.MXServer;
import psdi.util.MXApplicationException;
import psdi.util.MXException;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\r\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\b\u0010\u0010\u001a\u00020\fH\u0014J\u0006\u0010\u0011\u001a\u00020\u0006J\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\nJ\b\u0010\u0015\u001a\u00020\fH\u0014J\u0010\u0010\u0016\u001a\u00020\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0016\u001a\u00020\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000fR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/interlocsolutions/maximo/notify/util/LicenseManager;", "Lcom/interlocsolutions/maximo/notify/util/InformerThreadIndefinite;", "()V", "lastUpdated", "Ljava/util/Date;", "license", "Lcom/interlocsolutions/maximo/notify/util/License;", "checkLicenseForCount", "", "userCount", "", "cleanUpTask", "", "getLicense", "xml", "", "initTask", "requireValidLicense", "requireValidLicenseForCount", "requireValidLicenseForDeviceCount", "deviceCount", "runRecurringInformerTask", "updateLicense", "newLicense", "isinformer"})
public final class LicenseManager
extends InformerThreadIndefinite {
    @NotNull
    public static final LicenseManager INSTANCE = new LicenseManager();
    @Nullable
    private static License license;
    @Nullable
    private static Date lastUpdated;

    private LicenseManager() {
        super("Informer-LicenseManager", 60000L, false, true, NotifyConstants.INFORMER_LOGGER);
    }

    @NotNull
    public final License getLicense(@Nullable String xml) throws RemoteException, MXException {
        try {
            License license = License.getLicense((String)xml);
            Intrinsics.checkNotNullExpressionValue((Object)license, (String)"getLicense(xml)");
            return license;
        }
        catch (JAXBException e) {
            Object[] objectArray = new String[]{"License", e.getMessage()};
            throw new MXApplicationException("informer", "jaxberror", objectArray, (Throwable)e);
        }
        catch (NullPointerException e) {
            throw new MXApplicationException("informer", "missingLicense", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final License getLicense() throws RemoteException, MXException {
        MboSetRemote licSet;
        if (license != null) return license;
        MboSetRemote mboSetRemote = licSet = MXServerFactory.getMXServer().getMboSet("ISLICENSE", MXServerFactory.getMXServer().getSystemUserInfo());
        if (mboSetRemote == null) return license;
        MboSetRemote $this$use$iv = mboSetRemote;
        boolean $i$f$use = false;
        Closeable closeable = new MboSetRemoteClosableWrapper($this$use$iv);
        Throwable throwable = null;
        try {
            Unit unit;
            MboSetRemoteClosableWrapper it$iv = (MboSetRemoteClosableWrapper)closeable;
            boolean bl = false;
            MboSetRemote it = $this$use$iv;
            boolean bl2 = false;
            try {
                SqlFormat sqlf = new SqlFormat("application=:1");
                sqlf.setObject(1, "MAXAPPS", "APP", "NOTIFY");
                licSet.setWhere(sqlf.format());
                if (licSet.isEmpty()) {
                    InputStream inputStream = License.class.getResourceAsStream("/informer.lic");
                    if (inputStream == null) throw new MXApplicationException("informer", "missingLicense");
                    BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
                    String line = null;
                    StringBuilder sb = new StringBuilder();
                    try {
                        while (true) {
                            String string;
                            String it2 = string = br.readLine();
                            boolean bl3 = false;
                            line = it2;
                            if (string == null) break;
                            sb.append(line).append("\n");
                        }
                        MboRemote lic = licSet.add();
                        lic.setValue("APPLICATION", "NOTIFY", 2L);
                        lic.setValue("LICENSE", sb.toString(), 2L);
                        licSet.save();
                        license = License.getLicense((String)sb.toString());
                    }
                    catch (IOException e) {
                        LicenseManager.INSTANCE.logger.debug((Object)"Error getting initial license value;", (Throwable)e);
                        license = null;
                    }
                } else {
                    license = INSTANCE.getLicense(licSet.getMbo(0).getString("LICENSE"));
                }
                unit = Unit.INSTANCE;
            }
            catch (MXException e) {
                if (!StringsKt.equals((String)"system", (String)e.getErrorGroup(), (boolean)true) || !StringsKt.equals((String)"major", (String)e.getErrorKey(), (boolean)true)) {
                    throw e;
                }
                unit = null;
            }
            Unit unit2 = unit;
            return license;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public final void updateLicense(@Nullable String newLicense) throws RemoteException, MXException {
        try {
            CharSequence charSequence = newLicense;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                this.updateLicense((License)null);
            } else {
                License license = License.getLicense((String)newLicense);
                this.updateLicense(license);
            }
        }
        catch (JAXBException e) {
            InformerLoggers.INSTANCE.getInformer().info((Object)"Error importing license.", (Throwable)e);
            throw new MXApplicationException("informer", "invalidLicense");
        }
        catch (IOException e) {
            InformerLoggers.INSTANCE.getInformer().info((Object)"Error importing license.", (Throwable)e);
            throw new MXApplicationException("informer", "invalidLicense");
        }
        catch (NullPointerException e) {
            InformerLoggers.INSTANCE.getInformer().info((Object)"Error importing license.", (Throwable)e);
            throw new MXApplicationException("informer", "invalidLicense");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateLicense(@Nullable License newLicense) throws RemoteException, MXException {
        MboSetRemote licSet;
        Date now = MXServer.getMXServer().getDate();
        MboSetRemote mboSetRemote = licSet = MXServerFactory.getMXServer().getMboSet("ISLICENSE", MXServerFactory.getMXServer().getSystemUserInfo());
        if (mboSetRemote != null) {
            MboSetRemote $this$use$iv = mboSetRemote;
            boolean $i$f$use = false;
            Closeable closeable = new MboSetRemoteClosableWrapper($this$use$iv);
            Throwable throwable = null;
            try {
                MboRemote licenseMbo;
                MboSetRemoteClosableWrapper it$iv = (MboSetRemoteClosableWrapper)closeable;
                boolean bl = false;
                MboSetRemote it = $this$use$iv;
                boolean bl2 = false;
                licSet.setWhere("application= 'NOTIFY'");
                MboRemote mboRemote = licSet.getMbo(0);
                if (mboRemote == null) {
                    mboRemote = licenseMbo = licSet.add();
                }
                if (newLicense == null) {
                    licenseMbo.delete();
                } else {
                    licenseMbo.setValue("APPLICATION", "NOTIFY", 2L);
                    licenseMbo.setValue("LICENSE", newLicense.toString(), 2L);
                    licenseMbo.setValue("UPDATEDATE", now, 2L);
                }
                licSet.save();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        license = newLicense;
        lastUpdated = now;
    }

    @NotNull
    public final License requireValidLicense() throws MXException {
        License license = LicenseManager.license;
        if (license == null) {
            throw new InformerException("missingLicense");
        }
        License license2 = license;
        if (!license2.isValid()) {
            Object[] objectArray = new String[]{license2.getInvalidReason()};
            throw new InformerException("invalidLicenseReason", objectArray);
        }
        return license2;
    }

    public final boolean checkLicenseForCount(int userCount) throws MXException {
        License lic = this.requireValidLicense();
        return lic.isForDevelopment() || lic.getUserCount() < 0 || userCount <= lic.getUserCount();
    }

    public final void requireValidLicenseForCount(int userCount) throws MXException {
        License lic = this.requireValidLicense();
        if (!this.checkLicenseForCount(userCount)) {
            Object[] objectArray = new String[]{String.valueOf(lic.getUserCount())};
            throw new InformerException("exceedLicenseUserCount", objectArray);
        }
    }

    public final void requireValidLicenseForDeviceCount(int deviceCount) throws MXException {
        License lic = this.requireValidLicense();
        if (!lic.isForDevelopment() && lic.getDeviceCount() >= 0 && deviceCount > lic.getDeviceCount()) {
            Object[] objectArray = new String[]{String.valueOf(lic.getDeviceCount())};
            throw new InformerException("exceedLicenseDeviceCount", objectArray);
        }
    }

    @Override
    protected void initTask() throws RemoteException, MXException, InformerThreadIndefinite.InformerTaskException {
    }

    @Override
    protected void cleanUpTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runRecurringInformerTask() throws RemoteException, MXException, InformerThreadIndefinite.InformerTaskException {
        MboSetRemote $this$use$iv = MboExtensionsKt.getNewMboSet$default("ISLICENSE", null, null, false, 14, null);
        boolean $i$f$use = false;
        Closeable closeable = new MboSetRemoteClosableWrapper($this$use$iv);
        Throwable throwable = null;
        try {
            MboRemote lic;
            MboSetRemoteClosableWrapper it$iv = (MboSetRemoteClosableWrapper)closeable;
            boolean bl = false;
            MboSetRemote licSet = $this$use$iv;
            boolean bl2 = false;
            SqlFormat sqlf = new SqlFormat("application=:1");
            sqlf.setObject(1, "MAXAPPS", "APP", "NOTIFY");
            licSet.setWhere(sqlf.format());
            if (!licSet.isEmpty() && !(lic = licSet.getMbo(0)).isNull("LICENSE")) {
                if (lic.isNull("UPDATEDATE")) {
                    lic.setValue("UPDATEDATE", MXServer.getMXServer().getDate(), 2L);
                    licSet.save();
                }
                Date date = lic.getDate("UPDATEDATE");
                if (lastUpdated == null) {
                    lastUpdated = date;
                    license = INSTANCE.getLicense(lic.getString("LICENSE"));
                } else if (date.after(lastUpdated)) {
                    license = INSTANCE.getLicense(lic.getString("LICENSE"));
                    lastUpdated = date;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

