/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import com.interlocsolutions.maximo.notify.util.InformerThread;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import java.rmi.RemoteException;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import psdi.server.MXServer;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

public abstract class InformerThreadIndefinite
extends InformerThread {
    private final Object waitLock = new Object();
    private final boolean shutdownUponError;
    private final boolean suspendDuringAdminMode;
    private final ReentrantLock syncLock = new ReentrantLock();
    private long interval;

    public InformerThreadIndefinite(String name, long interval, boolean shutdownUponError, boolean suspendDuringAdminMode, MXLogger logger2) {
        super(name, logger2);
        this.interval = interval;
        this.shutdownUponError = shutdownUponError;
        this.suspendDuringAdminMode = suspendDuringAdminMode;
    }

    public InformerThreadIndefinite(@NotNull ThreadGroup threadGroup, String name, long interval, boolean shutdownUponError, boolean suspendDuringAdminMode, MXLogger logger2) {
        super(threadGroup, name, logger2);
        this.interval = interval;
        this.shutdownUponError = shutdownUponError;
        this.suspendDuringAdminMode = suspendDuringAdminMode;
    }

    public long getInterval() {
        return this.interval;
    }

    protected void setInterval(long interval) {
        this.interval = interval;
    }

    protected void onAdminModePause() {
    }

    protected void onIntervalPause() {
    }

    @Override
    protected final void runInformerTask() {
        try {
            try {
                this.initTask();
            }
            catch (InformerTaskException | RemoteException | MXException e) {
                this.logger.error((Object)String.format("Thread \"%s\" failed to initialize, and will not run.", this.getName()), e);
                this.requestShutdown();
            }
            while (!this.shutdownRequested()) {
                try {
                    if (this.suspendDuringAdminMode && MXServer.getMXServer().isAdminModeOn(true)) {
                        this.logger.info((Object)String.format("Pausing %s while Maximo server is in Admin Mode.", this.getName()));
                        this.onAdminModePause();
                        long start = System.currentTimeMillis();
                        this.suspend(60000L);
                        this.logger.debug((Object)String.format("Waking %s from wait after %dms", this.getName(), System.currentTimeMillis() - start));
                        continue;
                    }
                }
                catch (InterruptedException start) {
                }
                catch (RuntimeException | RemoteException | MXException e) {
                    this.logger.warn((Object)String.format("Thread \"%s\" failed to check Admin Mode status, and will not pause.", this.getName()), e);
                }
                try {
                    this.runRecurringInformerTask();
                }
                catch (Throwable e) {
                    if (!NotifyUtil.isMaximoRunning()) {
                        this.requestShutdown();
                    }
                    if (this.shutdownUponError) {
                        this.logger.error((Object)String.format("Thread \"%s\" encountered an error and will shut down.", this.getName()), e);
                        this.requestShutdown();
                    }
                    this.logger.error((Object)String.format("Thread \"%s\" encountered an error and will retry.", this.getName()), e);
                }
                if (this.shutdownRequested()) continue;
                try {
                    this.onIntervalPause();
                    this.suspend(this.interval);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        finally {
            this.cleanUpTask();
        }
    }

    protected abstract void initTask() throws RemoteException, MXException, InformerTaskException;

    protected abstract void cleanUpTask();

    protected abstract void runRecurringInformerTask() throws RemoteException, MXException, InformerTaskException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suspend(long timeout) throws InterruptedException {
        Object object = this.waitLock;
        synchronized (object) {
            this.waitLock.wait(timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wake() {
        Object object = this.waitLock;
        synchronized (object) {
            this.waitLock.notifyAll();
        }
    }

    public static class InformerTaskException
    extends Exception {
        public InformerTaskException(String message2) {
            super(message2);
        }

        public InformerTaskException(Throwable cause) {
            this(cause.getMessage(), cause);
        }

        public InformerTaskException(String message2, Throwable cause) {
            super(message2, cause);
        }
    }
}

