/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import com.interlocsolutions.maximo.notify.util.InformerThread;
import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.util.Predicate;
import com.interlocsolutions.maximo.notify.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import psdi.util.logging.MXLogger;

public class InformerThreadGroup
extends ThreadGroup {
    private static final Predicate<Thread> LIVE_THREADS = new Predicate<Thread>(){

        @Override
        public boolean apply(Thread thread) {
            return thread instanceof InformerThread && thread.isAlive();
        }
    };
    static InformerThreadGroup singleton;
    protected final MXLogger LOGGER = NotifyConstants.INFORMER_LOGGER;

    public InformerThreadGroup() {
        super("Informer Thread Group");
    }

    public InformerThreadGroup(@NotNull InformerThreadGroup parentGroup) {
        super(parentGroup, "Informer Thread Group");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InformerThreadGroup getInformerThreadGroup() {
        Class<InformerThreadGroup> clazz = InformerThreadGroup.class;
        synchronized (InformerThreadGroup.class) {
            if (singleton == null) {
                singleton = new InformerThreadGroup();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public void awaitShutdown(long timeout, @NotNull TimeUnit timeUnit) {
        boolean admitDefeat;
        this.LOGGER.info((Object)"Shutting down all Informer Threads");
        List<InformerThread> myThreads = this.getInformerThreads();
        this.LOGGER.info((Object)("Shutting down " + myThreads.size() + " Informer Threads"));
        if (myThreads.size() > 0) {
            for (InformerThread thread : myThreads) {
                thread.requestShutdown();
            }
            myThreads = this.getInformerThreads();
        }
        long timeShutdownRequested = System.currentTimeMillis();
        long timeoutMs = System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
        boolean bl = admitDefeat = System.currentTimeMillis() > timeoutMs;
        if (!admitDefeat && myThreads.size() > 0) {
            for (InformerThread thread : myThreads) {
                admitDefeat = System.currentTimeMillis() > timeoutMs;
                if (admitDefeat) break;
                try {
                    thread.requestShutdown();
                    thread.join(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (!(admitDefeat |= System.currentTimeMillis() > timeoutMs) && (myThreads = this.getInformerThreads()).size() > 0) {
            for (InformerThread thread : myThreads) {
                admitDefeat = System.currentTimeMillis() > timeoutMs;
                if (admitDefeat) break;
                try {
                    thread.requestShutdown();
                    thread.join(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!thread.isAlive()) continue;
                this.LOGGER.warn((Object)String.format("Informer Thread %s has not shut down in a timely fashion.", thread.getName()));
            }
            myThreads = this.getInformerThreads();
        }
        admitDefeat |= System.currentTimeMillis() > timeoutMs;
        while (!admitDefeat && myThreads.size() > 0) {
            for (InformerThread thread : myThreads) {
                if (admitDefeat |= System.currentTimeMillis() > timeoutMs) break;
                try {
                    thread.requestShutdown();
                    thread.join(10000L);
                }
                catch (InterruptedException ignored) {
                    admitDefeat = true;
                }
                if (!thread.isAlive()) continue;
                this.LOGGER.warn((Object)String.format("Informer Thread %s has not shut down in a timely fashion.", thread.getName()));
            }
            myThreads = this.getInformerThreads();
        }
        if (admitDefeat && myThreads.size() > 0) {
            StringBuilder sb = new StringBuilder("The following Informer Threads failed to terminate after ").append(TimeUnit.MINUTES.convert(System.currentTimeMillis() - timeShutdownRequested, TimeUnit.MILLISECONDS)).append(" minutes. The Informer service will give up waiting, as these may run forever:");
            StringUtils.join(sb, myThreads, "\n", "\n", null);
            this.LOGGER.error((Object)sb.toString());
        } else {
            this.LOGGER.info((Object)"All Informer Threads have been successfully shut down");
        }
    }

    @NotNull
    public List<InformerThread> getInformerThreads() {
        return this.getInformerThreads(LIVE_THREADS);
    }

    @NotNull
    public List<InformerThread> getInformerThreads(@NotNull Predicate<Thread> predicate2) {
        ArrayList<InformerThread> results = new ArrayList<InformerThread>();
        for (Thread thread : this.getThreadIterable()) {
            if (!(thread instanceof InformerThread) || !predicate2.apply(thread)) continue;
            results.add((InformerThread)thread);
        }
        return results;
    }

    @NotNull
    public Iterable<Thread> getThreadIterable() {
        Thread[] myThreads = new Thread[10];
        int numThreads = this.enumerate(myThreads);
        while (numThreads == myThreads.length) {
            myThreads = new Thread[myThreads.length * 2];
            numThreads = this.enumerate(myThreads, true);
        }
        return Arrays.asList(myThreads).subList(0, numThreads);
    }
}

