/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import com.interlocsolutions.maximo.notify.StartupMonitor;
import com.interlocsolutions.maximo.notify.util.InformerThreadGroup;
import psdi.util.logging.MXLogger;

public abstract class InformerThread
extends Thread {
    protected final MXLogger logger;
    private volatile boolean shutdownRequested = false;
    private boolean isInitThread;

    public InformerThread(String name, MXLogger logger2) {
        this((ThreadGroup)InformerThreadGroup.getInformerThreadGroup(), name, logger2);
    }

    public InformerThread(ThreadGroup threadGroup, String name, MXLogger logger2) {
        super(threadGroup, name);
        this.logger = logger2;
        this.setDaemon(true);
        this.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                InformerThread.this.logger.error((Object)String.format("Informer Thread \"%s\" encountered a fatal error.", InformerThread.this.getName()), e);
            }
        });
    }

    protected void setInitThread(boolean initThread) {
        this.isInitThread = initThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void requestShutdown() {
        InformerThread informerThread = this;
        synchronized (informerThread) {
            this.shutdownRequested = true;
        }
        this.interrupt();
        this.onShutdownRequested();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean shutdownRequested() {
        InformerThread informerThread = this;
        synchronized (informerThread) {
            return this.shutdownRequested;
        }
    }

    protected void onShutdownRequested() {
    }

    @Override
    public final void run() {
        StartupMonitor monitor = StartupMonitor.getInstance();
        if (this.isInitThread) {
            while (!this.shutdownRequested()) {
                try {
                    monitor.awaitInformerInstalled();
                    break;
                }
                catch (InterruptedException interruptedException) {
                }
            }
        } else {
            while (!this.shutdownRequested()) {
                try {
                    monitor.awaitInformerInitialized();
                    break;
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
        this.runInformerTask();
    }

    protected abstract void runInformerTask();
}

