/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import com.interlocsolutions.maximo.notify.util.NotifyConstants;
import com.interlocsolutions.maximo.notify.xml.NotifyXMLUtils;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import psdi.util.logging.MXLogger;

public class InformerObjectSerializer {
    public static final String[] packages = new String[]{"com.interlocsolutions.maximo.notify", "com.interlocsolutions.maximo.notify.commands", "com.interlocsolutions.maximo.notify.util", "com.interlocsolutions.maximo.notify.xml", "com.interlocsolutions.maximo.notify.xml.export"};
    public static final Set<String> packageSet = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(packages)));
    public static final MarshallingPolicy<String> MARSHAL_BASIC = new MarshalPolicyBasic();
    public static final MarshallingPolicy<String> MARSHAL_PPRINT = new MarshalPolicyPPrint();
    @Deprecated
    public static final MarshallingPolicy<String> MARSHAL_PPRINT_STRIPCONTROL = MARSHAL_PPRINT;
    public static final UnmarshallingPolicy<Reader> UNMARSHAL_BASIC = new UnmarshalPolicyBasicReader();
    public static final UnmarshallingPolicy<InputStream> UNMARSHAL_BASIC_STREAM = new UnmarshalPolicyBasicStream();
    private static final Pattern sControlCharRegex = Pattern.compile("[\u0000-\b\u000b\f\u000e-\u001f]");
    public static final MXLogger INFORMER_LOGGER = NotifyConstants.INFORMER_LOGGER;
    private static JAXBContext informerContext;
    private static InformerObjectSerializer singleton;
    protected final WeakHashMap<UnmarshallingPolicy, ConcurrentLinkedQueue<Unmarshaller>> unmarshallerPools = new WeakHashMap();
    private final ThreadLocal<XMLInputFactory> inputFactoryThreadlocal = new ThreadLocal<XMLInputFactory>(){

        @Override
        protected XMLInputFactory initialValue() {
            XMLInputFactory xif;
            try {
                xif = XMLInputFactory.newFactory();
            }
            catch (NoSuchMethodError msme) {
                INFORMER_LOGGER.debug((Object)"XMLInputFactory#newFactory did not work. This can be an issue when using older versions of WebSphere using an IBM JDK, which omitted this newer method signature. Attempting to use the older method signature instead.");
                xif = XMLInputFactory.newInstance();
            }
            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            xif.setProperty("javax.xml.stream.supportDTD", false);
            return xif;
        }
    };

    private InformerObjectSerializer() {
    }

    private static JAXBContext initJAXBContext() throws JAXBException {
        return InformerObjectSerializer.initJAXBContext(packages);
    }

    private static JAXBContext initJAXBContext(String[] packages) throws JAXBException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < packages.length; ++i) {
            if (i > 0) {
                sb.append(":");
            }
            sb.append(packages[i]);
        }
        String pkgString = sb.toString();
        informerContext = JAXBContext.newInstance((String)pkgString);
        return informerContext;
    }

    public static InformerObjectSerializer getInstance() {
        if (singleton == null) {
            singleton = new InformerObjectSerializer();
        }
        return singleton;
    }

    public JAXBContext getInformerContext() throws JAXBException {
        if (informerContext == null) {
            informerContext = InformerObjectSerializer.initJAXBContext();
        }
        return informerContext;
    }

    public XMLInputFactory getXMLInputFactory() {
        return this.inputFactoryThreadlocal.get();
    }

    public String serialize(Object object) throws JAXBException {
        return this.serialize(object, MARSHAL_BASIC);
    }

    public <OutType> OutType serialize(Object object, MarshallingPolicy<OutType> policy) throws JAXBException {
        if (packageSet.contains(object.getClass().getPackage().getName())) {
            Marshaller m = this.getInformerContext().createMarshaller();
            policy.configureMarshaller(m);
            return policy.useMarshaller(m, object);
        }
        NotifyConstants.INFORMER_LOGGER.warn((Object)String.format("%1$s was passed to the InformerObjectSerializer, but its package, %2$s,is not managed by Informer's unified (de)serialization manager. An ad-hoc marshaller will be created and the request served, but this in the unexpected generation of additional class loaders, decreasing performance and impacting global GC times.", object.getClass().getName(), object.getClass().getPackage().getName()));
        return NotifyXMLUtils.serializeCustom(object, policy);
    }

    public Object deserialize(InputStream inputStream) throws JAXBException, XMLStreamException {
        return this.deserialize(inputStream, UNMARSHAL_BASIC_STREAM);
    }

    public Object deserialize(Reader reader) throws JAXBException, XMLStreamException {
        return this.deserialize(reader, UNMARSHAL_BASIC);
    }

    public Object deserialize(String xml) throws JAXBException, XMLStreamException {
        return this.deserialize(new StringReader(xml));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <InType, InParam extends InType> Object deserialize(InParam message2, UnmarshallingPolicy<InType> policy) throws JAXBException, XMLStreamException {
        ConcurrentLinkedQueue<Object> poolForPolicy;
        Unmarshaller um = null;
        UnmarshallingPolicy<Object> key = policy.modifiesConfiguration() ? policy : UNMARSHAL_BASIC;
        WeakHashMap<UnmarshallingPolicy, ConcurrentLinkedQueue<Unmarshaller>> weakHashMap = this.unmarshallerPools;
        synchronized (weakHashMap) {
            if (this.unmarshallerPools.containsKey(key)) {
                poolForPolicy = this.unmarshallerPools.get(key);
                um = (Unmarshaller)poolForPolicy.poll();
            } else {
                poolForPolicy = new ConcurrentLinkedQueue();
                this.unmarshallerPools.put(key, poolForPolicy);
            }
        }
        if (um == null) {
            um = this.getInformerContext().createUnmarshaller();
            if (policy.modifiesConfiguration()) {
                policy.configureUnmarshaller(um);
            }
        }
        Object result = policy.useUnmarshaller(um, message2);
        poolForPolicy.offer(um);
        return result;
    }

    static {
        try {
            informerContext = InformerObjectSerializer.initJAXBContext();
        }
        catch (JAXBException e) {
            NotifyConstants.INFORMER_LOGGER.fatal((Object)"JAXB Context could be created", (Throwable)e);
        }
    }

    public static interface MarshallingPolicy<OutType> {
        public OutType useMarshaller(Marshaller var1, Object var2) throws JAXBException;

        public boolean modifiesConfiguration();

        public void configureMarshaller(Marshaller var1) throws PropertyException;
    }

    public static interface UnmarshallingPolicy<InType> {
        public Object useUnmarshaller(Unmarshaller var1, InType var2) throws JAXBException, XMLStreamException;

        public boolean modifiesConfiguration();

        public void configureUnmarshaller(Unmarshaller var1) throws PropertyException;
    }

    private static class MarshalPolicyBasic
    implements MarshallingPolicy<String> {
        private MarshalPolicyBasic() {
        }

        @Override
        public String useMarshaller(Marshaller marshaller, Object object) throws JAXBException {
            StringWriter writer = new StringWriter();
            marshaller.marshal(object, (Writer)writer);
            return sControlCharRegex.matcher(writer.toString()).replaceAll("");
        }

        @Override
        public boolean modifiesConfiguration() {
            return false;
        }

        @Override
        public void configureMarshaller(Marshaller marshaller) throws PropertyException {
        }
    }

    private static class MarshalPolicyPPrint
    implements MarshallingPolicy<String> {
        private MarshalPolicyPPrint() {
        }

        @Override
        public String useMarshaller(Marshaller marshaller, Object object) throws JAXBException {
            StringWriter writer = new StringWriter();
            marshaller.marshal(object, (Writer)writer);
            String resp = writer.toString();
            resp = sControlCharRegex.matcher(resp).replaceAll("");
            return resp;
        }

        @Override
        public boolean modifiesConfiguration() {
            return true;
        }

        @Override
        public void configureMarshaller(Marshaller marshaller) throws PropertyException {
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
        }
    }

    private static class UnmarshalPolicyBasicReader
    implements UnmarshallingPolicy<Reader> {
        private UnmarshalPolicyBasicReader() {
        }

        @Override
        public Object useUnmarshaller(Unmarshaller unmarshaller, Reader message2) throws JAXBException, XMLStreamException {
            XMLStreamReader xsr = InformerObjectSerializer.getInstance().getXMLInputFactory().createXMLStreamReader(message2);
            return unmarshaller.unmarshal(xsr);
        }

        @Override
        public boolean modifiesConfiguration() {
            return false;
        }

        @Override
        public void configureUnmarshaller(Unmarshaller unmarshaller) throws PropertyException {
        }
    }

    private static class UnmarshalPolicyBasicStream
    implements UnmarshallingPolicy<InputStream> {
        private UnmarshalPolicyBasicStream() {
        }

        @Override
        public Object useUnmarshaller(Unmarshaller unmarshaller, InputStream message2) throws JAXBException, XMLStreamException {
            XMLStreamReader xsr = InformerObjectSerializer.getInstance().getXMLInputFactory().createXMLStreamReader(message2);
            return unmarshaller.unmarshal(xsr);
        }

        @Override
        public boolean modifiesConfiguration() {
            return false;
        }

        @Override
        public void configureUnmarshaller(Unmarshaller unmarshaller) throws PropertyException {
        }
    }
}

