/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import com.interlocsolutions.maximo.notify.NotifyCommandRemote;
import com.interlocsolutions.maximo.notify.commands.Command;
import com.interlocsolutions.maximo.notify.util.InformerObjectSerializer;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.HashMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamException;
import psdi.util.MXException;

public class InformerCommandSerializer {
    private static InformerCommandSerializer singleton;
    protected final WeakHashMap<PrivateContext, ConcurrentLinkedQueue<Unmarshaller>> unmarshallerPools = new WeakHashMap();
    final HashMap<String, PrivateContext> contexts = new HashMap();

    private InformerCommandSerializer() {
    }

    public static InformerCommandSerializer getInstance() {
        if (singleton == null) {
            singleton = new InformerCommandSerializer();
        }
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <OutType> OutType serialize(NotifyCommandRemote cmdMbo, Command cmdObj, InformerObjectSerializer.MarshallingPolicy<OutType> policy) throws JAXBException, RemoteException, MXException {
        PrivateContext ctxPojo;
        Class<?> cmdClass = cmdObj.getClass();
        String cmdClassName = cmdClass.getName();
        Date cmdVersion = cmdMbo.getDate("UPDATED");
        HashMap<String, PrivateContext> hashMap = this.contexts;
        synchronized (hashMap) {
            ctxPojo = this.contexts.get(cmdClassName);
            if (ctxPojo != null && !ctxPojo.version.equals(cmdVersion)) {
                ctxPojo = null;
            }
            if (ctxPojo == null) {
                ctxPojo = new PrivateContext(cmdClass, cmdClassName, cmdVersion);
                this.contexts.put(cmdClassName, ctxPojo);
            }
        }
        Marshaller m = ctxPojo.jaxbContext.createMarshaller();
        policy.configureMarshaller(m);
        return policy.useMarshaller(m, cmdObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command deserialize(NotifyCommandRemote cmdMbo, InputStream xml) throws RemoteException, MXException, JAXBException, XMLStreamException {
        ConcurrentLinkedQueue<Object> poolForClass;
        PrivateContext ctxPojo;
        Command cmdInstance = cmdMbo.getCommand();
        Class<?> cmdClass = cmdInstance.getClass();
        String cmdClassName = cmdClass.getName();
        Date cmdVersion = cmdMbo.getDate("UPDATED");
        HashMap<String, PrivateContext> hashMap = this.contexts;
        synchronized (hashMap) {
            ctxPojo = this.contexts.get(cmdClassName);
            if (ctxPojo != null && !ctxPojo.version.equals(cmdVersion)) {
                ctxPojo = null;
            }
            if (ctxPojo == null) {
                ctxPojo = new PrivateContext(cmdClass, cmdClassName, cmdVersion);
                this.contexts.put(cmdClassName, ctxPojo);
            }
        }
        Unmarshaller um = null;
        WeakHashMap<PrivateContext, ConcurrentLinkedQueue<Unmarshaller>> weakHashMap = this.unmarshallerPools;
        synchronized (weakHashMap) {
            if (this.unmarshallerPools.containsKey(ctxPojo)) {
                poolForClass = this.unmarshallerPools.get(ctxPojo);
                um = (Unmarshaller)poolForClass.poll();
            } else {
                poolForClass = new ConcurrentLinkedQueue();
                this.unmarshallerPools.put(ctxPojo, poolForClass);
            }
        }
        if (um == null) {
            um = ctxPojo.jaxbContext.createUnmarshaller();
            InformerObjectSerializer.UNMARSHAL_BASIC_STREAM.configureUnmarshaller(um);
        }
        Command result = (Command)InformerObjectSerializer.UNMARSHAL_BASIC_STREAM.useUnmarshaller(um, xml);
        poolForClass.offer(um);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearContexts() {
        HashMap<String, PrivateContext> hashMap = this.contexts;
        synchronized (hashMap) {
            this.contexts.clear();
        }
    }

    static class PrivateContext {
        JAXBContext jaxbContext;
        String className;
        Date version;

        public PrivateContext(Class c, String className, Date version) throws JAXBException {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{c});
            this.className = className;
            this.version = version;
        }
    }
}

