/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ISO8601Formatter {
    private static final String PATTERN_IS08601 = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final ThreadLocal<SimpleDateFormat> ISO8601 = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat(ISO8601Formatter.PATTERN_IS08601);
        }
    };

    private ISO8601Formatter() {
    }

    public static String format(Date date) {
        String sDate = ISO8601.get().format(date);
        if (!sDate.substring(sDate.length() - 3).startsWith(":")) {
            sDate = sDate.substring(0, sDate.length() - 2) + ":" + sDate.substring(sDate.length() - 2);
        }
        return sDate;
    }

    public static Date parse(String date) throws ParseException {
        if (date == null) {
            return null;
        }
        if (date.substring(date.length() - 3).startsWith(":")) {
            date = date.substring(0, date.length() - 3) + date.substring(date.length() - 2);
        }
        return ISO8601.get().parse(date);
    }
}

