/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import com.interlocsolutions.maximo.notify.util.MaximoVersion;
import com.interlocsolutions.maximo.notify.util.db.DataUtils;
import java.util.Calendar;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import psdi.app.system.CrontaskParamInfo;
import psdi.mbo.SqlFormat;
import psdi.server.SimpleCronTask;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0013\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0002\u0010\b\u00a8\u0006\n"}, d2={"Lcom/interlocsolutions/maximo/notify/util/FileTransferPurgeCronTask;", "Lpsdi/server/SimpleCronTask;", "()V", "cronAction", "", "getParameters", "", "Lpsdi/app/system/CrontaskParamInfo;", "()[Lpsdi/app/system/CrontaskParamInfo;", "Companion", "isinformer"})
public final class FileTransferPurgeCronTask
extends SimpleCronTask {
    @NotNull
    public static final Companion Companion;
    @NotNull
    public static final String RETENTION_PERIOD = "RetentionPeriod";
    @NotNull
    private static final CrontaskParamInfo[] params;

    public void cronAction() {
        int n;
        this.getCronTaskLogger().info((Object)"Initializing the Informer file transfer purge cron task");
        super.init();
        try {
            n = this.getParamAsInt(RETENTION_PERIOD);
        }
        catch (Exception e) {
            String errMsg2 = "RetentionPeriod parameter could not be parsed";
            this.getCronTaskLogger().error((Object)errMsg2, (Throwable)e);
            if (MaximoVersion.Companion.getSystemVersion().handlesCronExceptions()) {
                throw new RuntimeException(errMsg2, e);
            }
            return;
        }
        int retPeriod = n;
        try {
            FileTransferPurgeCronTask it = this;
            boolean bl = false;
            Calendar c = Calendar.getInstance();
            c.add(6, -1 * retPeriod);
            String thresholdDate = SqlFormat.getDateFunction((Date)c.getTime());
            this.getCronTaskLogger().info((Object)("Purging expired Informer file transfer before " + thresholdDate));
            DataUtils.systemRawCUD("DELETE isfilefragment where createdate < " + thresholdDate);
        }
        catch (Exception e) {
            String errMsg3 = "An error occurred while purging file transfer fragments; " + e.getMessage();
            this.getCronTaskLogger().error((Object)errMsg3, (Throwable)e);
            if (MaximoVersion.Companion.getSystemVersion().handlesCronExceptions()) {
                throw new RuntimeException(errMsg3, e);
            }
            return;
        }
    }

    @NotNull
    public CrontaskParamInfo[] getParameters() {
        return params;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$params_u24lambda_u241;
        CrontaskParamInfo crontaskParamInfo;
        Companion = new Companion(null);
        CrontaskParamInfo[] crontaskParamInfoArray = new CrontaskParamInfo[1];
        CrontaskParamInfo crontaskParamInfo2 = crontaskParamInfo = new CrontaskParamInfo();
        int n = 0;
        CrontaskParamInfo[] crontaskParamInfoArray2 = crontaskParamInfoArray;
        boolean bl = false;
        $this$params_u24lambda_u241.setName(RETENTION_PERIOD);
        $this$params_u24lambda_u241.setDescription("informer", "retentionPeriod");
        $this$params_u24lambda_u241.setDefault(Integer.toString(7));
        Unit unit = Unit.INSTANCE;
        crontaskParamInfoArray2[n] = crontaskParamInfo;
        params = crontaskParamInfoArray;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/interlocsolutions/maximo/notify/util/FileTransferPurgeCronTask$Companion;", "", "()V", "RETENTION_PERIOD", "", "params", "", "Lpsdi/app/system/CrontaskParamInfo;", "[Lpsdi/app/system/CrontaskParamInfo;", "isinformer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

