/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import com.interlocsolutions.maximo.notify.commands.CommandUtilities;
import com.interlocsolutions.maximo.notify.util.MaximoVersion;
import com.interlocsolutions.maximo.notify.util.db.DbConnectionAccessor;
import com.interlocsolutions.maximo.notify.util.db.DbConnectionAccessorKt;
import com.interlocsolutions.maximo.notify.util.db.DbConnectionManager;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import psdi.app.system.CrontaskParamInfo;
import psdi.server.SimpleCronTask;
import psdi.util.logging.MXLogger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\u0013\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/interlocsolutions/maximo/notify/util/CommandHistoryPurgeCronTask;", "Lpsdi/server/SimpleCronTask;", "()V", "RETENTION_PERIOD", "", "logger", "Lpsdi/util/logging/MXLogger;", "kotlin.jvm.PlatformType", "params", "", "Lpsdi/app/system/CrontaskParamInfo;", "[Lpsdi/app/system/CrontaskParamInfo;", "cronAction", "", "getParameters", "()[Lpsdi/app/system/CrontaskParamInfo;", "isinformer"})
public final class CommandHistoryPurgeCronTask
extends SimpleCronTask {
    private final MXLogger logger = this.getCronTaskLogger();
    @NotNull
    private final String RETENTION_PERIOD;
    @NotNull
    private final CrontaskParamInfo[] params;

    /*
     * WARNING - void declaration
     */
    public CommandHistoryPurgeCronTask() {
        void $this$params_u24lambda_u240;
        CrontaskParamInfo crontaskParamInfo;
        this.RETENTION_PERIOD = "RetentionPeriod";
        CrontaskParamInfo[] crontaskParamInfoArray = new CrontaskParamInfo[1];
        CrontaskParamInfo crontaskParamInfo2 = crontaskParamInfo = new CrontaskParamInfo();
        int n = 0;
        CrontaskParamInfo[] crontaskParamInfoArray2 = crontaskParamInfoArray;
        CommandHistoryPurgeCronTask commandHistoryPurgeCronTask = this;
        boolean bl = false;
        $this$params_u24lambda_u240.setName(this.RETENTION_PERIOD);
        $this$params_u24lambda_u240.setDescription("informer", "retentionPeriodDays");
        $this$params_u24lambda_u240.setDefault(Integer.toString(30));
        Unit unit = Unit.INSTANCE;
        crontaskParamInfoArray2[n] = crontaskParamInfo;
        commandHistoryPurgeCronTask.params = crontaskParamInfoArray;
    }

    public void cronAction() {
        block2: {
            this.logger.info((Object)"Purging expired Informer command history data.");
            try {
                Object[] objectArray;
                int retPeriod = this.getParamAsInt(this.RETENTION_PERIOD);
                Object[] $this$cronAction_u24lambda_u241 = objectArray = Calendar.getInstance();
                boolean bl = false;
                $this$cronAction_u24lambda_u241.add(6, -1 * retPeriod);
                Object[] c = objectArray;
                DbConnectionAccessor dbConnectionAccessor = DbConnectionManager.getInstance().getMaximoConnection();
                Intrinsics.checkNotNullExpressionValue((Object)dbConnectionAccessor, (String)"getInstance().maximoConnection");
                objectArray = new Object[]{c.getTime(), CommandUtilities.ExecutionStatus.SUCCEEDED.getValue()};
                DbConnectionAccessorKt.deleteIteratively$default(dbConnectionAccessor, "iscommandhistory", "commandhistoryid", "executiondate < ? and inexecution = ?", objectArray, null, 16, null);
            }
            catch (Exception e) {
                this.logger.error((Object)("An error occurred while purging command history; " + e.getMessage()));
                if (!MaximoVersion.Companion.getSystemVersion().handlesCronExceptions()) break block2;
                throw new RuntimeException(e);
            }
        }
    }

    @NotNull
    public CrontaskParamInfo[] getParameters() {
        return this.params;
    }
}

