/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import com.interlocsolutions.maximo.notify.Catalog;
import com.interlocsolutions.maximo.notify.util.JDBCExtensionsKt;
import com.interlocsolutions.maximo.notify.util.MboExtensionsKt;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.util.db.DbConnectionAccessor;
import com.interlocsolutions.maximo.notify.util.db.DbConnectionAccessorKt;
import com.interlocsolutions.maximo.notify.util.db.DbConnectionManager;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0002J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lcom/interlocsolutions/maximo/notify/util/CatalogDataCleanupUtil;", "", "()V", "identifyThreshold", "", "conn", "Ljava/sql/Connection;", "catalog", "Lpsdi/mbo/MboRemote;", "langCode", "", "partitionName", "purgeOldDeletes", "", "logger", "Lpsdi/util/logging/MXLogger;", "catalogSet", "Lpsdi/mbo/MboSetRemote;", "isinformer"})
public final class CatalogDataCleanupUtil {
    @NotNull
    public static final CatalogDataCleanupUtil INSTANCE = new CatalogDataCleanupUtil();

    private CatalogDataCleanupUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public final void purgeOldDeletes(@NotNull MXLogger logger2, @NotNull Connection conn, @NotNull MboSetRemote catalogSet) throws SQLException, RemoteException, MXException {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)catalogSet, (String)"catalogSet");
        Collection<String> supportedLanguages = NotifyUtil.getLangCodes();
        DbConnectionAccessor dbAccessor = DbConnectionManager.getInstance().getMaximoConnection();
        MboSetRemote $this$forEach$iv = catalogSet;
        boolean $i$f$forEach = false;
        Sequence<MboRemote> $this$forEach$iv$iv = MboExtensionsKt.asSequence($this$forEach$iv);
        boolean $i$f$forEach2 = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            Map map;
            Object[] objectArray;
            Object[] objectArray2;
            MboRemote catalog = (MboRemote)element$iv$iv;
            boolean bl = false;
            long numDeleted = 0L;
            String string = new SqlFormat(catalog, "SELECT DISTINCT partitionname FROM iscatalogdata\nWHERE catalogid = :catalogid AND revision = :revision\nAND partitionname IS NOT NULL").format();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlFormat(catalog, \"\"\"\n \u2026()\n            ).format()");
            Set allPartitions = JDBCExtensionsKt.collectStringSet$default((Connection)conn, (String)string, null, (int)2, null);
            String string2 = catalog.getString("PARTITIONTYPE");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"catalog.getString(\"PARTITIONTYPE\")");
            Catalog.PartitionType partitionType = Catalog.PartitionType.valueOf(string2);
            switch (WhenMappings.$EnumSwitchMapping$0[partitionType.ordinal()]) {
                case 1: 
                case 2: {
                    void $this$fold$iv;
                    void initial$iv;
                    Intrinsics.checkNotNullExpressionValue(supportedLanguages, (String)"supportedLanguages");
                    objectArray2 = supportedLanguages;
                    Map map2 = new LinkedHashMap();
                    boolean $i$f$fold = false;
                    void accumulator$iv = initial$iv;
                    for (Object element$iv : $this$fold$iv) {
                        void langCode;
                        objectArray = (String)element$iv;
                        void map3 = accumulator$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)langCode, (String)"langCode");
                        map3.put(langCode, INSTANCE.identifyThreshold(conn, catalog, (String)langCode, null));
                        accumulator$iv = map3;
                    }
                    map = accumulator$iv;
                    break;
                }
                case 3: {
                    map = MapsKt.emptyMap();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Map unpartitionedThresholds = map;
            Intrinsics.checkNotNullExpressionValue(supportedLanguages, (String)"supportedLanguages");
            Iterable $this$forEach$iv2 = supportedLanguages;
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv2) {
                String langCode = (String)element$iv;
                boolean bl3 = false;
                Iterable $this$forEach$iv3 = allPartitions;
                boolean $i$f$forEach4 = false;
                for (Object element$iv2 : $this$forEach$iv3) {
                    Object[] objectArray3;
                    long l;
                    String partitionName = (String)element$iv2;
                    boolean bl4 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)langCode, (String)"langCode");
                    long datasetThreshold = INSTANCE.identifyThreshold(conn, catalog, langCode, partitionName);
                    switch (WhenMappings.$EnumSwitchMapping$0[partitionType.ordinal()]) {
                        case 1: 
                        case 2: {
                            Long l2 = (Long)unpartitionedThresholds.get(langCode);
                            if (l2 != null) {
                                Long l3 = l2;
                                long it = ((Number)l3).longValue();
                                boolean bl5 = false;
                                l2 = it > 0L ? l3 : null;
                                if (l2 != null) {
                                    long unpartitionedThreshold = ((Number)l2).longValue();
                                    boolean bl6 = false;
                                    l = RangesKt.coerceAtMost((long)datasetThreshold, (long)unpartitionedThreshold);
                                    break;
                                }
                            }
                            l = datasetThreshold;
                            break;
                        }
                        case 3: {
                            l = datasetThreshold;
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    long effectiveThreshold = l;
                    if (effectiveThreshold < 1L) {
                        Intrinsics.checkNotNullExpressionValue((Object)dbAccessor, (String)"dbAccessor");
                        objectArray3 = new Object[]{catalog.getUniqueIDValue(), catalog.getLong("REVISION"), langCode, partitionName, false};
                        numDeleted += DbConnectionAccessorKt.deleteIteratively$default(dbAccessor, "iscatalogdata", "catalogdataid", "catalogid = ? AND revision = ?\nAND langcode = ? AND partitionname = ?\nAND inscope = ?  ", objectArray3, null, 16, null).getSuccessfulDeletedIds().size();
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)dbAccessor, (String)"dbAccessor");
                    objectArray3 = new Object[]{catalog.getUniqueIDValue(), catalog.getLong("REVISION"), langCode, partitionName, false, effectiveThreshold};
                    numDeleted += DbConnectionAccessorKt.deleteIteratively$default(dbAccessor, "iscatalogdata", "catalogdataid", "catalogid = ? AND revision = ?\nAND langcode = ? AND partitionname = ?\nAND inscope = ? AND sequence <= ?", objectArray3, null, 16, null).getSuccessfulDeletedIds().size();
                }
            }
            $this$forEach$iv2 = supportedLanguages;
            $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv2) {
                long effectiveThreshold;
                String langCode = (String)element$iv;
                boolean bl7 = false;
                Long l = (Long)unpartitionedThresholds.get(langCode);
                long l4 = effectiveThreshold = l != null ? l : 0L;
                if (effectiveThreshold < 1L) {
                    Intrinsics.checkNotNullExpressionValue((Object)dbAccessor, (String)"dbAccessor");
                    objectArray = new Object[]{catalog.getUniqueIDValue(), catalog.getLong("REVISION"), langCode, false};
                    numDeleted += DbConnectionAccessorKt.deleteIteratively$default(dbAccessor, "iscatalogdata", "catalogdataid", "catalogid = ? AND revision = ?\nAND langcode = ? AND partitionname IS NULL\nAND inscope = ?", objectArray, null, 16, null).getSuccessfulDeletedIds().size();
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)dbAccessor, (String)"dbAccessor");
                objectArray = new Object[]{catalog.getUniqueIDValue(), catalog.getLong("REVISION"), langCode, false, effectiveThreshold};
                numDeleted += DbConnectionAccessorKt.deleteIteratively$default(dbAccessor, "iscatalogdata", "catalogdataid", "catalogid = ? AND revision = ?\nAND langcode = ? AND partitionname IS NULL\nAND inscope = ? AND sequence <= ?", objectArray, null, 16, null).getSuccessfulDeletedIds().size();
            }
            if ((numDeleted <= 0L || !logger2.isInfoEnabled()) && !logger2.isDebugEnabled()) continue;
            String string3 = "For Catalog %1$s:%2$s, deleted %3$d out-of-scope records from ISCATALOGDATA unneeded by any current or future devices";
            objectArray2 = new Object[]{catalog.getString("NOTIFY.NOTIFYNUM"), catalog.getString("CATALOG"), numDeleted};
            String string4 = String.format(string3, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
            logger2.info((Object)string4);
        }
    }

    private final long identifyThreshold(Connection conn, MboRemote catalog, String langCode, String partitionName) {
        SqlFormat sqlFormat;
        SqlFormat sqlFormat2;
        SqlFormat sqlFormat3;
        SqlFormat sqlFormat4;
        CatalogDataCleanupUtil $this$identifyThreshold_u24lambda_u249 = this;
        boolean bl = false;
        if (partitionName == null) {
            SqlFormat $this$identifyThreshold_u24lambda_u249_u24lambda_u247 = sqlFormat4 = new SqlFormat(catalog, "SELECT MIN(sequence)\nFROM iscatalogdevice\nWHERE catalogid = :catalogid AND revision = :revision\nAND langcode = :1 AND partitionname IS NULL");
            boolean bl2 = false;
            $this$identifyThreshold_u24lambda_u249_u24lambda_u247.setObject(1, "ISCATALOGDEVICE", "LANGCODE", langCode);
            sqlFormat3 = sqlFormat4;
        } else {
            SqlFormat $this$identifyThreshold_u24lambda_u249_u24lambda_u248 = sqlFormat4 = new SqlFormat(catalog, "SELECT MIN(sequence)\nFROM iscatalogdevice\nWHERE catalogid = :catalogid AND revision = :revision\nAND langcode = :1 AND partitionname = :2");
            boolean bl3 = false;
            $this$identifyThreshold_u24lambda_u249_u24lambda_u248.setObject(1, "ISCATALOGDEVICE", "LANGCODE", langCode);
            $this$identifyThreshold_u24lambda_u249_u24lambda_u248.setObject(2, "ISCATALOGDEVICE", "PARTITIONNAME", partitionName);
            sqlFormat3 = sqlFormat4;
        }
        SqlFormat sqlf = sqlFormat3;
        String string = sqlf.format();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sqlf.format()");
        Long l = JDBCExtensionsKt.queryForLong$default((Connection)conn, (String)string, null, (int)2, null);
        long lowestDeviceSeq = l != null ? l : 0L;
        CatalogDataCleanupUtil $this$identifyThreshold_u24lambda_u2412 = this;
        boolean bl4 = false;
        if (partitionName == null) {
            SqlFormat $this$identifyThreshold_u24lambda_u2412_u24lambda_u2410 = sqlFormat2 = new SqlFormat(catalog, "SELECT seqend FROM iscatpreload\nWHERE catalogid = :catalogid AND revision = :revision\nAND langcode = :1 AND partitionname IS NULL");
            boolean bl5 = false;
            $this$identifyThreshold_u24lambda_u2412_u24lambda_u2410.setObject(1, "ISCATALOGDEVICE", "LANGCODE", langCode);
            sqlFormat = sqlFormat2;
        } else {
            SqlFormat $this$identifyThreshold_u24lambda_u2412_u24lambda_u2411 = sqlFormat2 = new SqlFormat(catalog, "SELECT seqend FROM iscatpreload\nWHERE catalogid = :catalogid AND revision = :revision\nAND langcode = :1 AND partitionname = :2");
            boolean bl6 = false;
            $this$identifyThreshold_u24lambda_u2412_u24lambda_u2411.setObject(1, "ISCATALOGDEVICE", "LANGCODE", langCode);
            $this$identifyThreshold_u24lambda_u2412_u24lambda_u2411.setObject(2, "ISCATALOGDEVICE", "PARTITIONNAME", partitionName);
            sqlFormat = sqlFormat2;
        }
        SqlFormat sqlf2 = sqlFormat;
        String string2 = sqlf2.format();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sqlf.format()");
        Long l2 = JDBCExtensionsKt.queryForLong$default((Connection)conn, (String)string2, null, (int)2, null);
        long highestPrepageSeq = l2 != null ? l2 : 0L;
        return lowestDeviceSeq < 1L && highestPrepageSeq < 1L ? 0L : (lowestDeviceSeq < 1L ? highestPrepageSeq : (highestPrepageSeq < 1L ? lowestDeviceSeq : RangesKt.coerceAtMost((long)highestPrepageSeq, (long)lowestDeviceSeq)));
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Catalog.PartitionType.values().length];
            try {
                nArray[Catalog.PartitionType.UNPARTITIONED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Catalog.PartitionType.BOTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Catalog.PartitionType.PARTITIONED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

