/*
 * Decompiled with CFR 0.152.
 */
package com.interlocsolutions.maximo.notify.util;

import com.interlocsolutions.maximo.notify.err.InformerException;
import com.interlocsolutions.maximo.notify.queue.catalog.CatalogJobRepo;
import com.interlocsolutions.maximo.notify.util.CatalogDataCleanupUtil;
import com.interlocsolutions.maximo.notify.util.MaximoVersion;
import com.interlocsolutions.maximo.notify.util.MboSetIterator;
import com.interlocsolutions.maximo.notify.util.NotifyUtil;
import com.interlocsolutions.maximo.notify.util.db.DataUtils;
import com.interlocsolutions.maximo.notify.util.db.DbConnectionAccessor;
import com.interlocsolutions.maximo.notify.util.db.DbConnectionAccessorKt;
import com.interlocsolutions.maximo.notify.util.db.DbConnectionManager;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import psdi.mbo.MboRemote;
import psdi.mbo.MboSetRemote;
import psdi.mbo.SqlFormat;
import psdi.security.ConnectionKey;
import psdi.server.DBManager;
import psdi.server.MXServer;
import psdi.server.SimpleCronTask;
import psdi.util.MXException;
import psdi.util.logging.MXLogger;

public class CatalogCleanupCronTask
extends SimpleCronTask {
    private boolean initialized = false;
    private CatalogJobRepo catalogJobRepo;

    public void init() throws MXException {
        MXLogger logger2 = this.getCronTaskLogger();
        logger2.info((Object)"Initializing the Informer command purge cron task");
        super.init();
        this.catalogJobRepo = CatalogJobRepo.INSTANCE;
        this.initialized = true;
        logger2.info((Object)"Initialized the Informer catalog purge cron task");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cronAction() {
        DBManager dbManager;
        MXLogger logger2 = this.getCronTaskLogger();
        if (!this.initialized) {
            return;
        }
        logger2.info((Object)"Purging Informer catalog data for missing or invalid revisions.");
        try {
            dbManager = MXServer.getMXServer().getDBManager();
        }
        catch (RemoteException e) {
            logger2.error((Object)("An error occurred while trying to access the DB manager: " + e.getMessage()), (Throwable)e);
            return;
        }
        ConnectionKey key = dbManager.getSystemConnectionKey();
        Connection cnn = dbManager.getConnection(key);
        try {
            Statement s = cnn.createStatement();
            try {
                this.purgeOrphanedData(s);
                MboSetRemote catalogSet = MXServer.getMXServer().getMboSet("ISCATALOG", this.getRunasUserInfo());
                catalogSet.setFlag(7L, true);
                try {
                    this.purgeOldRevisionData(s, catalogSet);
                    CatalogDataCleanupUtil.INSTANCE.purgeOldDeletes(logger2, cnn, catalogSet);
                }
                finally {
                    NotifyUtil.closeAndCleanup(catalogSet);
                }
            }
            finally {
                NotifyUtil.close(s);
            }
            cnn.commit();
            logger2.info((Object)"Catalog data purge operation complete");
        }
        catch (RuntimeException e) {
            logger2.error((Object)("An error occurred while purging obsolete Catalog data; " + e.getMessage()), (Throwable)e);
            if (MaximoVersion.Companion.getSystemVersion().handlesCronExceptions()) {
                throw e;
            }
        }
        catch (Exception e) {
            logger2.error((Object)("An error occurred while purging obsolete Catalog data; " + e.getMessage()), (Throwable)e);
            if (MaximoVersion.Companion.getSystemVersion().handlesCronExceptions()) {
                throw new RuntimeException(e);
            }
        }
        finally {
            dbManager.freeConnection(key);
        }
    }

    private void purgeOldRevisionData(Statement s, MboSetRemote catalogSet) throws MXException, RemoteException, SQLException {
        MXLogger logger2 = this.getCronTaskLogger();
        final DbConnectionAccessor dbAccessor = DbConnectionManager.getInstance().getMaximoConnection();
        MboSetIterator catItr = new MboSetIterator(catalogSet);
        MboRemote catalog = catItr.moveFirst();
        while (catalog != null) {
            DbConnectionAccessor.DeletionResult result;
            long numDeleted = DbConnectionAccessorKt.deleteIteratively(dbAccessor, "iscatalogdata", "catalogdataid", "catalogid = ? AND revision < ?", new Long[]{catalog.getUniqueIDValue(), catalog.getLong("REVISION")}, null).getSuccessfulDeletedIds().size();
            if (numDeleted > 0L && logger2.isInfoEnabled() || logger2.isDebugEnabled()) {
                logger2.info((Object)String.format("For Catalog %1$s:%2$s, deleting %3$d ISCATALOGDATA records from earlier revisions", catalog.getString("NOTIFY.NOTIFYNUM"), catalog.getString("CATALOG"), numDeleted));
            }
            if ((result = DbConnectionAccessorKt.deleteIteratively(dbAccessor, "iscatpreload", "catpreloadid", "catalogid = ? AND revision < ?", new Long[]{catalog.getUniqueIDValue(), catalog.getLong("REVISION")}, new DataUtils.CascadeDeletion(){

                @Override
                public void deleteChildrenOf(Long catPreloadId) throws Exception {
                    DbConnectionAccessor.DeletionResult res = DbConnectionAccessorKt.deleteIteratively(dbAccessor, "iscatprepage", "catprepageid", "preloaduid = (SELECT preloaduid FROM iscatpreload WHERE catpreloadid = ?)", new Long[]{catPreloadId}, null);
                    if (res.getUnsuccessfulDeletedIds().size() > 0L) {
                        throw new InformerException("ISCATPREPAGE was not delete entirely for catpreloadid: " + catPreloadId);
                    }
                }
            })).getSuccessfulDeletedIds().size() > 0L && logger2.isInfoEnabled() || logger2.isDebugEnabled()) {
                logger2.info((Object)String.format("For Catalog %1$s:%2$s, deleting %3$d ISCATPRELOAD records from earlier revisions, as well as obsolete preloads of the current revision.", catalog.getString("NOTIFY.NOTIFYNUM"), catalog.getString("CATALOG"), result.getSuccessfulDeletedIds().size()));
            }
            if (result.getUnsuccessfulDeletedIds().size() > 0L) {
                logger2.error((Object)String.format("For Catalog %1$s:%2$s, %3$d ISCATPRELOAD records from earlier revisions could not be deleted", catalog.getString("NOTIFY.NOTIFYNUM"), catalog.getString("CATALOG"), result.getUnsuccessfulDeletedIds().size()));
            }
            SqlFormat oldResourceSqlf = new SqlFormat(catalog, "resourcetype = 'CATALOG' AND notifyid = :notifyid AND name = :catalog AND version < (   SELECT MAX(version) FROM isnotifyresource WHERE notifyid = :notifyid AND name = :catalog )");
            numDeleted = s.executeUpdate("DELETE isnotifyresource WHERE " + oldResourceSqlf.format());
            if (numDeleted > 0L && logger2.isInfoEnabled() || logger2.isDebugEnabled()) {
                logger2.info((Object)String.format("For Catalog %1$s:%2$s, deleting %3$d obsolete ISNOTIFYRESOURCE records", catalog.getString("NOTIFY.NOTIFYNUM"), catalog.getString("CATALOG"), numDeleted));
            }
            SqlFormat oldCatRevSqlf = new SqlFormat(catalog, "catalogid = :catalogid AND revision < :revision");
            numDeleted = s.executeUpdate("DELETE iscatalogdevice WHERE " + oldCatRevSqlf.format());
            if (numDeleted > 0L && logger2.isInfoEnabled() || logger2.isDebugEnabled()) {
                logger2.info((Object)String.format("For Catalog %1$s:%2$s, deleting %3$d ISCATALOGDEVICE records from earlier revisions", catalog.getString("NOTIFY.NOTIFYNUM"), catalog.getString("CATALOG"), numDeleted));
            }
            if ((numDeleted = (long)this.catalogJobRepo.discardJobsForOlderRevisions(catalog.getLong("CATALOGID"), catalog.getLong("REVISION"))) > 0L && logger2.isInfoEnabled() || logger2.isDebugEnabled()) {
                logger2.info((Object)String.format("Deleted %d orphaned Catalog queue jobs", numDeleted));
            }
            catalog = catItr.moveNext();
        }
    }

    private void purgeOrphanedData(Statement s) throws SQLException, RemoteException, MXException {
        MXLogger logger2 = this.getCronTaskLogger();
        DbConnectionAccessor dbAccessor = DbConnectionManager.getInstance().getMaximoConnection();
        long numDeleted = s.executeUpdate("DELETE iscatalogattribute WHERE catalogid NOT IN (SELECT catalogid FROM iscatalog)");
        if (numDeleted > 0L && logger2.isInfoEnabled()) {
            logger2.info((Object)String.format("Deleted %d orphaned ISCATALOGATTRIBUTE records.", numDeleted));
        }
        if ((numDeleted = (long)s.executeUpdate("DELETE iscataloglistener WHERE catalogid NOT IN (SELECT catalogid FROM iscatalog)")) > 0L && logger2.isInfoEnabled()) {
            logger2.info((Object)String.format("Deleted %d orphaned ISCATALOGLISTENER records.", numDeleted));
        }
        if ((numDeleted = DbConnectionAccessorKt.deleteIteratively(dbAccessor, "iscatalogdata", "catalogdataid", "catalogid NOT IN (SELECT catalogid FROM iscatalog)", new Object[0], null).getSuccessfulDeletedIds().size()) > 0L && logger2.isInfoEnabled()) {
            logger2.info((Object)String.format("Deleted %d orphaned ISCATALOGDATA records.", numDeleted));
        }
        if ((numDeleted = DbConnectionAccessorKt.deleteIteratively(dbAccessor, "iscatpreload", "catpreloadid", "catalogid NOT IN (SELECT catalogid FROM iscatalog)", new Object[0], null).getSuccessfulDeletedIds().size()) > 0L && logger2.isInfoEnabled()) {
            logger2.info((Object)String.format("Deleted %d orphaned ISCATPRELOAD records.", numDeleted));
        }
        if ((numDeleted = DbConnectionAccessorKt.deleteIteratively(dbAccessor, "iscatprepage", "catprepageid", "pagestate <> ? AND preloaduid NOT IN (SELECT preloaduid FROM iscatpreload)", new Integer[]{1}, null).getSuccessfulDeletedIds().size()) > 0L && logger2.isInfoEnabled()) {
            logger2.info((Object)String.format("Deleted %d orphaned ISCATPREPAGE records.", numDeleted));
        }
        if ((numDeleted = (long)s.executeUpdate("DELETE isnotifyresource WHERE resourcetype = 'CATALOG' AND notifyresourceid NOT IN (   SELECT r.notifyresourceid   FROM isnotifyresource r   INNER JOIN iscatalog c ON (r.notifyid = c.notifyid and c.catalog = r.name))")) > 0L && logger2.isInfoEnabled()) {
            logger2.info((Object)String.format("Deleted %d orphaned ISCATALOGDATA records.", numDeleted));
        }
        if ((numDeleted = (long)s.executeUpdate("DELETE iscatalogdevice WHERE catalogid NOT IN (SELECT catalogid FROM iscatalog)")) > 0L && logger2.isInfoEnabled()) {
            logger2.info((Object)String.format("Deleted %d orphaned ISCATALOGDEVICE records.", numDeleted));
        }
    }
}

